/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.wxpay.util;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class WxUtil {
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmssSSS");

    public static int buildRandom(int length) {
        int num = 1;
        double random = Math.random();
        if (random < 0.1) {
            random += 0.1;
        }
        for (int i = 0; i < length; ++i) {
            num *= 10;
        }
        return (int)(random * (double)num);
    }

    public static String getTradeNo() {
        return simpleDateFormat.format(new Date()) + WxUtil.buildRandom((int)4);
    }

    public static String getCurrTime() {
        Date now = new Date();
        SimpleDateFormat outFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String s = outFormat.format(now);
        return s;
    }

    public static String getLastTime() {
        Date now = new Date();
        SimpleDateFormat outFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String s = outFormat.format(now);
        return s.substring(8, s.length());
    }

    public static String generateSignature(Map<String, Object> data, String key, String signType) throws Exception {
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            String value;
            if (((String)k).equals("sign") || (value = String.valueOf(data.get(k))).trim().length() <= 0) continue;
            sb.append((String)k).append("=").append(value).append("&");
        }
        sb.append("key=").append(key);
        if ("MD5".equals(signType)) {
            return WxUtil.MD5((String)sb.toString()).toUpperCase();
        }
        if ("HMAC-SHA256".equals(signType)) {
            return WxUtil.HMACSHA256((String)sb.toString(), (String)key);
        }
        throw new Exception(String.format("Invalid sign_type: %s", signType));
    }

    public static String MD5(String data) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] array = md.digest(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static String HMACSHA256(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static Map<String, Object> xmlToMap(String strXML) throws Exception {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(strXML.getBytes("UTF-8"));
            Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
            try {
                ((InputStream)stream).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static String mapToXml(Map<String, Object> parameters) {
        StringBuffer sb = new StringBuffer();
        sb.append("<xml>");
        Set<Map.Entry<String, Object>> es = parameters.entrySet();
        for (Map.Entry<String, Object> entry : es) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            sb.append("<" + key + ">" + value + "</" + key + ">");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    public static String resultToStr(int type) {
        switch (type) {
            case 1: {
                return "\u76f4\u63a5\u652f\u4ed8\u6210\u529f\uff01";
            }
            case 4: {
                return "\u76f4\u63a5\u652f\u4ed8\u5931\u8d25\uff01";
            }
            case 7: {
                return "\u76f4\u63a5\u652f\u4ed8\u901a\u8baf\u5931\u8d25\uff01";
            }
            case 2: {
                return "\u67e5\u8be2\u652f\u4ed8\u6210\u529f\uff01";
            }
            case 5: {
                return "\u67e5\u8be2\u652f\u4ed8\u5931\u8d25\uff01";
            }
            case 8: {
                return "\u67e5\u8be2\u652f\u4ed8\u901a\u8baf\u5931\u8d25\uff01";
            }
            case 3: {
                return "\u64a4\u9500\u8ba2\u5355\u6210\u529f\uff01";
            }
            case 6: {
                return "\u64a4\u9500\u8ba2\u5355\u5931\u8d25\uff01";
            }
            case 9: {
                return "\u64a4\u9500\u8ba2\u5355\u901a\u8baf\u5931\u8d25\uff01";
            }
        }
        return "\u6ca1\u6709\u8fd9\u79cd\u7c7b\u578b\uff01";
    }

    public static String fenToYuan(Integer fen) {
        return BigDecimal.valueOf(Double.valueOf(fen.intValue()) / 100.0).setScale(2, 4).toPlainString();
    }

    public static <T> T mapToObject(Map<String, String> map, Class<T> beanClass) throws Exception {
        T bean = beanClass.newInstance();
        BeanUtils.populate(beanClass, map);
        return bean;
    }

    public static Map<String, Object> objectToMap(Object obj) {
        String jsonStr = JSONObject.toJSONString((Object)obj);
        return JSONObject.parseObject((String)jsonStr);
    }
}

