/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.ebaiyihui.aggregation.payment.common.model.ProfitSharingBind;
import com.ebaiyihui.aggregation.payment.common.vo.RequestBindReqVO;
import com.ebaiyihui.aggregation.payment.server.mapper.ProfitSharingBindMapper;
import com.ebaiyihui.aggregation.payment.server.service.ProfitSharingBindService;
import com.ebaiyihui.aggregation.payment.server.utils.Md5Utils;
import com.ebaiyihui.aggregation.payment.server.utils.PagingUtils;
import com.ebaiyihui.framework.page.PageResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProfitSharingBindServiceImpl
implements ProfitSharingBindService {
    private static final Logger log = LoggerFactory.getLogger(ProfitSharingBindServiceImpl.class);
    @Autowired
    private ProfitSharingBindMapper bindMapper;

    public int save(ProfitSharingBind profitSharingBind) {
        profitSharingBind.setParentCode(Md5Utils.get12Char((String)profitSharingBind.getMainMerchant()));
        profitSharingBind.setBindCode(Md5Utils.get12Char((String)profitSharingBind.getAccountId()));
        int insertSelective = this.bindMapper.insertSelective(profitSharingBind);
        return insertSelective;
    }

    public int updateBind(ProfitSharingBind profitSharingBind) {
        int keySelective = this.bindMapper.updateByPrimaryKeySelective(profitSharingBind);
        return keySelective;
    }

    public PageResult<ProfitSharingBind> getBinds(RequestBindReqVO bindReqVO) {
        PageResult result = new PageResult();
        List profitSharingBind = this.bindMapper.getProfitSharingBind(bindReqVO);
        result = PagingUtils.paging((Integer)bindReqVO.getPageNum(), (List)profitSharingBind, (Integer)bindReqVO.getPageSize());
        return result;
    }

    public int deleteBind(List<Long> list) {
        int deleteBind = this.bindMapper.deleteProfitSharingBind(list);
        return deleteBind;
    }

    public ProfitSharingBind getBindInfoByBindCode(String bindCode) {
        ProfitSharingBind byBindCode = this.bindMapper.getBindInfoByBindCode(bindCode);
        return byBindCode;
    }

    public List<ProfitSharingBind> getBindByMainMerchant(String merchant) {
        List byMainMerchant = this.bindMapper.getBindByMainMerchant(merchant);
        return byMainMerchant;
    }
}

