/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.mybank.notify;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.SharingRecord;
import com.ebaiyihui.aggregation.payment.common.model.ThirdNotifyRecord;
import com.ebaiyihui.aggregation.payment.server.enums.ApplyChannelEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.SharingRecordMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ThirdNotifyRecordMapper;
import com.ebaiyihui.aggregation.payment.server.mybank.bo.BusinessSharingResult;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.RequestHead;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.notify.BkcloudfundsOrderShareNotifyModel;
import com.ebaiyihui.aggregation.payment.server.mybank.enums.ShareStatusEnum;
import com.ebaiyihui.aggregation.payment.server.mybank.event.EventPublisher;
import com.ebaiyihui.aggregation.payment.server.mybank.event.Sharing;
import com.ebaiyihui.aggregation.payment.server.mybank.event.SharingNotifyEvent;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.parser.xml.XmlConverter;
import com.ebaiyihui.aggregation.payment.server.mybank.manage.CommonRequestHandler;
import com.ebaiyihui.aggregation.payment.server.mybank.request.notify.BkcloudfundsOrderShareNotifyRequest;
import com.ebaiyihui.aggregation.payment.server.service.mybank.notify.MybankNotifyService;
import com.ebaiyihui.aggregation.payment.server.utils.HttpsClientUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="bkcloudfundsOrderShareNotifyService")
public class BkcloudfundsOrderShareNotifyServiceImpl
implements MybankNotifyService {
    private static final Logger log = LoggerFactory.getLogger(BkcloudfundsOrderShareNotifyServiceImpl.class);
    @Autowired
    private CommonRequestHandler commonRequestHandler;
    @Resource
    private ThirdNotifyRecordMapper thirdNotifyRecordMapper;
    @Resource
    private SharingRecordMapper sharingRecordMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private EventPublisher eventPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String notifyHandle(String xmlContext, String function, String privateKey) throws Exception {
        log.info("mybank  sharing notify response:{}", (Object)xmlContext);
        BkcloudfundsOrderShareNotifyRequest orderShareNotifyRequest = (BkcloudfundsOrderShareNotifyRequest)XmlConverter.getInstance().toResponse(xmlContext, BkcloudfundsOrderShareNotifyRequest.class);
        BkcloudfundsOrderShareNotifyRequest.BkcloudfundsOrderShareNotify bkcloudfundsOrderShareNotify = orderShareNotifyRequest.getBkcloudfundsOrderShareNotify();
        RequestHead head = bkcloudfundsOrderShareNotify.getRequestHead();
        try {
            BkcloudfundsOrderShareNotifyModel bkcloudfundsOrderShareNotifyModel = bkcloudfundsOrderShareNotify.getBkcloudfundsOrderShareNotifyModel();
            log.info("mybank  sharing notify param:{}", (Object)JSONObject.toJSONString((Object)bkcloudfundsOrderShareNotifyModel));
            SharingRecord sharingRecord = this.sharingRecordMapper.selectOneByShareTradeNo(bkcloudfundsOrderShareNotifyModel.getOutTradeNo());
            String outTradeNo = sharingRecord.getOutTradeNo();
            boolean flag = this.saveNotify(head, bkcloudfundsOrderShareNotifyModel, outTradeNo);
            this.redisTemplate.opsForHash().delete((Object)outTradeNo, new Object[]{sharingRecord.getShareTradeNo()});
            this.notifyBusinessServer(bkcloudfundsOrderShareNotifyModel, sharingRecord.getSharingNotifyUrl());
            this.publisherEvent(outTradeNo);
            String string = this.commonRequestHandler.getSignResult(flag, head, privateKey);
            return string;
        }
        finally {
            return this.commonRequestHandler.getSignResult(true, head, privateKey);
        }
    }

    private void publisherEvent(String outTradeNo) {
        Sharing sharing = new Sharing();
        sharing.setOutTradeNo(outTradeNo);
        sharing.setStatus(Integer.valueOf(1));
        this.eventPublisher.publishSharingNotifyEvent(new SharingNotifyEvent((Object)sharing));
    }

    private boolean saveNotify(RequestHead head, BkcloudfundsOrderShareNotifyModel bkcloudfundsOrderShareNotifyModel, String outTradeNo) {
        String tradeNo = bkcloudfundsOrderShareNotifyModel.getRelateOrderNo();
        String shareTradeNo = bkcloudfundsOrderShareNotifyModel.getOutTradeNo();
        ThirdNotifyRecord thirdNotifyRecord = new ThirdNotifyRecord();
        thirdNotifyRecord.setOutTradeNo(outTradeNo);
        thirdNotifyRecord.setOutMarkId(shareTradeNo);
        thirdNotifyRecord.setThirdMarkId(tradeNo);
        thirdNotifyRecord.setMarkName(head.getFunction());
        thirdNotifyRecord.setType(ApplyChannelEnum.MYBANK.getApplyChannel());
        thirdNotifyRecord.setParam(JSONObject.toJSONString((Object)bkcloudfundsOrderShareNotifyModel));
        this.thirdNotifyRecordMapper.insert((Object)thirdNotifyRecord);
        SharingRecord update = new SharingRecord();
        update.setShareTradeNo(shareTradeNo);
        SharingRecord sharingRecord = new SharingRecord();
        if ("SUCCESS".equals(bkcloudfundsOrderShareNotifyModel.getStatus())) {
            sharingRecord.setShareStatus(ShareStatusEnum.FINISHED.getValue());
        } else {
            sharingRecord.setShareStatus(ShareStatusEnum.SHARING_ERROR.getValue());
            sharingRecord.setFailReason(bkcloudfundsOrderShareNotifyModel.getErrorDesc());
        }
        sharingRecord.setShareDate(bkcloudfundsOrderShareNotifyModel.getShareDate());
        sharingRecord.setExecution(Integer.valueOf(1));
        QueryWrapper queryWrapper = new QueryWrapper((Object)update);
        this.sharingRecordMapper.update((Object)sharingRecord, (Wrapper)queryWrapper);
        return true;
    }

    public void notifyBusinessServer(BkcloudfundsOrderShareNotifyModel model, String sharingNotifyUrl) {
        BusinessSharingResult businessSharingResult = new BusinessSharingResult();
        String shareTradeNo = model.getOutTradeNo();
        businessSharingResult.setOutSharingNo(shareTradeNo);
        businessSharingResult.setErrorCode(model.getErrorCode());
        businessSharingResult.setErrorDesc(model.getErrorDesc());
        businessSharingResult.setSharingDate(model.getShareDate());
        businessSharingResult.setStatus(model.getStatus());
        businessSharingResult.setTotalAmount(model.getTotalAmount());
        String param = JSONObject.toJSONString((Object)businessSharingResult);
        log.info("\u8c03\u7528\u5206\u8d26\u901a\u77e5\u4e1a\u52a1\u63a5\u53e3\u505a\u7ed3\u679c\u901a\u77e5,url={},\u8bf7\u6c42\u53c2\u6570{}", (Object)sharingNotifyUrl, (Object)param);
        JSONObject result = HttpsClientUtil.doPostForJson((String)sharingNotifyUrl, (String)param);
        log.info("\u5206\u8d26\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u8fd4\u56de\u7ed3\u679c\uff1aJSONObject{}", (Object)result);
    }
}

