/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.reconciliation;

import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconciliationRule {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationRule.class);
    private String transactionId;
    private BigDecimal totalFee;
    private String refundId;
    private BigDecimal refundFee;
    private String payType;
    private String applyCode;
    private BigDecimal payAmount;
    private BigDecimal shouldAmount;
    private String tradeState;

    public boolean equals(ReconciliationRule rr) {
        boolean result;
        String tradeState = rr.getTradeState();
        if ("SUCCESS".equals(tradeState)) {
            result = this.transactionId.equals(rr.getTransactionId()) && this.totalFee.abs().compareTo(rr.getTotalFee().abs()) == 0 && this.payType.equals(rr.getPayType()) && this.applyCode.equals(rr.getApplyCode()) && this.payAmount.abs().compareTo(rr.getPayAmount().abs()) == 0 && this.shouldAmount.abs().compareTo(rr.getShouldAmount().abs()) == 0;
        } else {
            String refundIdC = rr.getRefundId();
            if (refundIdC == null) {
                refundIdC = "0";
            }
            log.info("refundC:{},refundId:{}", (Object)refundIdC, (Object)this.refundId);
            result = this.transactionId.equals(rr.getTransactionId()) && this.refundId.equals(refundIdC) && this.refundFee.abs().compareTo(rr.getRefundFee().abs()) == 0 && this.payType.equals(rr.getPayType()) && this.applyCode.equals(rr.getApplyCode());
        }
        log.info("getReconciliationRule result:{}", (Object)result);
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.totalFee, this.refundId, this.refundFee, this.payType, this.applyCode, this.payAmount, this.shouldAmount);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public BigDecimal getTotalFee() {
        return this.totalFee;
    }

    public String getRefundId() {
        return this.refundId;
    }

    public BigDecimal getRefundFee() {
        return this.refundFee;
    }

    public String getPayType() {
        return this.payType;
    }

    public String getApplyCode() {
        return this.applyCode;
    }

    public BigDecimal getPayAmount() {
        return this.payAmount;
    }

    public BigDecimal getShouldAmount() {
        return this.shouldAmount;
    }

    public String getTradeState() {
        return this.tradeState;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setTotalFee(BigDecimal totalFee) {
        this.totalFee = totalFee;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    public void setRefundFee(BigDecimal refundFee) {
        this.refundFee = refundFee;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public void setShouldAmount(BigDecimal shouldAmount) {
        this.shouldAmount = shouldAmount;
    }

    public void setTradeState(String tradeState) {
        this.tradeState = tradeState;
    }

    public String toString() {
        return "ReconciliationRule(transactionId=" + this.getTransactionId() + ", totalFee=" + this.getTotalFee() + ", refundId=" + this.getRefundId() + ", refundFee=" + this.getRefundFee() + ", payType=" + this.getPayType() + ", applyCode=" + this.getApplyCode() + ", payAmount=" + this.getPayAmount() + ", shouldAmount=" + this.getShouldAmount() + ", tradeState=" + this.getTradeState() + ")";
    }
}

