/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.utils;

import java.math.BigDecimal;
import java.text.NumberFormat;

public class AmountUtil {
    public static final String CURRENCY_FEN_REGEX = "\\-?[0-9]+";

    public static String getPercent(int dividend, int divisor, int digit) {
        Float result = Float.valueOf((float)dividend / (float)divisor);
        if (result.isNaN()) {
            return "--";
        }
        NumberFormat nt = NumberFormat.getPercentInstance();
        nt.setMinimumFractionDigits(digit);
        return nt.format(result);
    }

    public static String add(String str1, String str2) {
        try {
            return new BigDecimal(str1).add(new BigDecimal(str2)).toPlainString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String multiply(String str1, String str2) {
        try {
            return new BigDecimal(str1).multiply(new BigDecimal(str2)).toPlainString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String subtract(String str1, String str2) {
        try {
            return new BigDecimal(str1).subtract(new BigDecimal(str2)).toPlainString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String divide(String str1, String str2) {
        try {
            return new BigDecimal(str1).divide(new BigDecimal(str2), 5).toPlainString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String FourUpSixInto(String str) {
        BigDecimal b1 = new BigDecimal(str);
        BigDecimal b2 = b1.setScale(2, 6);
        return b2.toString();
    }

    public static String changeF2Y(Long amount) {
        if (!amount.toString().matches(CURRENCY_FEN_REGEX)) {
            throw new IllegalArgumentException("\u91d1\u989d\u683c\u5f0f\u6709\u8bef");
        }
        boolean flag = false;
        String amString = amount.toString();
        if (amString.charAt(0) == '-') {
            flag = true;
            amString = amString.substring(1);
        }
        StringBuilder result = new StringBuilder();
        if (amString.length() == 1) {
            result.append("0.0").append(amString);
        } else if (amString.length() == 2) {
            result.append("0.").append(amString);
        } else {
            String intString = amString.substring(0, amString.length() - 2);
            for (int i = 1; i <= intString.length(); ++i) {
                if ((i - 1) % 3 == 0 && i != 1) {
                    result.append(",");
                }
                result.append(intString.substring(intString.length() - i, intString.length() - i + 1));
            }
            result.reverse().append(".").append(amString.substring(amString.length() - 2));
        }
        if (flag) {
            return "-" + result.toString();
        }
        return result.toString();
    }

    public static String changeF2Y(String amount) {
        if (!amount.matches(CURRENCY_FEN_REGEX)) {
            throw new IllegalArgumentException("\u91d1\u989d\u683c\u5f0f\u6709\u8bef");
        }
        return BigDecimal.valueOf(Long.parseLong(amount)).divide(new BigDecimal(100)).toString();
    }

    public static String changeY2F(Long amount) {
        return BigDecimal.valueOf(amount).multiply(new BigDecimal(100)).toString();
    }

    public static String changeY2F(String amount) {
        String currency = amount.replaceAll("[$\uffe5,]", "");
        int index = currency.indexOf(".");
        int length = currency.length();
        Long amLong = 0L;
        amLong = index == -1 ? Long.valueOf(currency + "00") : (length - index >= 3 ? Long.valueOf(currency.substring(0, index + 3).replace(".", "")) : (length - index == 2 ? Long.valueOf(currency.substring(0, index + 2).replace(".", "") + 0) : Long.valueOf(currency.substring(0, index + 1).replace(".", "") + "00")));
        return amLong.toString();
    }
}

