/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderH5VO;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestWxH5PayVo;
import com.ebaiyihui.aggregation.payment.server.Factory.PayService;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPayTrade;
import com.ebaiyihui.aggregation.payment.server.mapper.UserTransferInfoMapper;
import com.ebaiyihui.aggregation.payment.server.service.AggregationService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Api(tags={"\u4e8c\u7ef4\u7801\u805a\u5408\u652f\u4ed8"})
@RequestMapping(value={"/qr_code"})
public class AggregationController {
    private static final Logger log = LoggerFactory.getLogger(AggregationController.class);
    @Autowired
    private AggregationService aggregationService;
    @Autowired
    PayService payService;
    @Autowired
    HyPayTrade hyPayTrade;
    @Resource
    private UserTransferInfoMapper userTransferInfoMapper;

    @GetMapping(value={"/test_prepayment"})
    @ResponseBody
    public BaseResponse testPrepayment(@RequestParam(value="totalAmount") String totalAmount) {
        log.info("qingqiulujing********test_prepayment********");
        RequestCreateOrderVo requestCreateOrderVo = new RequestCreateOrderVo();
        requestCreateOrderVo.setTotalAmount(new BigDecimal(totalAmount));
        requestCreateOrderVo.setActuallyAmount(new BigDecimal(totalAmount));
        requestCreateOrderVo.setApplyCode("YPX");
        requestCreateOrderVo.setMchCode("YPX");
        requestCreateOrderVo.setServiceCode("pay-test");
        requestCreateOrderVo.setPayChannel("WECHAT");
        requestCreateOrderVo.setPayType("JSGZHAPI");
        requestCreateOrderVo.setSign("test");
        requestCreateOrderVo.setNonceStr("test");
        requestCreateOrderVo.setProductInfo("\u6d4b\u8bd5\u5546\u54c1");
        String outTradeNo = LocalDate.now().getYear() + "" + LocalDate.now().getMonthValue() + "" + LocalDate.now().getDayOfMonth() + "" + LocalDateTime.now().getHour() + "" + LocalDateTime.now().getMinute() + "" + LocalDateTime.now().getSecond() + "" + LocalDateTime.now().getNano() + "";
        requestCreateOrderVo.setOutTradeNo(outTradeNo + "");
        log.info("\u8bf7\u6c42\u6d4b\u8bd5\u805a\u5408\u652f\u4ed8\u53c2\u6570:" + requestCreateOrderVo);
        return this.aggregationService.prepayment(requestCreateOrderVo);
    }

    @PostMapping(value={"/prepayment"})
    @ApiOperation(value="\u9884\u652f\u4ed8")
    @ResponseBody
    public BaseResponse<String> prepayment(@Valid @RequestBody RequestCreateOrderVo requestCreateOrderVo) {
        return this.aggregationService.prepayment(requestCreateOrderVo);
    }

    @GetMapping(value={"/order_pay"})
    @ApiOperation(value="\u8ba2\u5355\u652f\u4ed8")
    public ModelAndView payWithOrder(ModelMap model, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="outTradeNo") String outTradeNo) throws IOException {
        String getCodeUrl = this.aggregationService.payWithOrder(model, request, response, outTradeNo);
        return new ModelAndView(getCodeUrl);
    }

    @GetMapping(value={"/get_openid"})
    @ApiOperation(value="\u8ba2\u5355\u652f\u4ed8")
    public String getOpenId(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.info("\u8fdb\u5165\u83b7\u53d6\u7528\u6237openID\u9875\u9762");
        String getOpenIdUrl = this.aggregationService.getOpenId(request, response);
        return "redirect:" + getOpenIdUrl;
    }

    @PostMapping(value={"/create_order_H5"})
    public String createOrderH5(HttpServletRequest request, HttpServletResponse httpResponse, @RequestParam Map<String, Object> params) throws Exception {
        String payChannel = (String)params.get("payChannel");
        String outTradeNo = (String)params.get("outTradeNo");
        RequestCreateOrderH5VO requestCreateOrderH5VO = new RequestCreateOrderH5VO();
        requestCreateOrderH5VO.setOutTradeNo(outTradeNo);
        requestCreateOrderH5VO.setPayChannel(payChannel);
        if (null != requestCreateOrderH5VO.getPayChannel()) {
            BaseResponse orderLauncher = this.aggregationService.createOrderH5(request, requestCreateOrderH5VO);
            String data = (String)orderLauncher.getData();
            httpResponse.reset();
            httpResponse.setContentType("text/html;charset=UTF-8");
            httpResponse.getWriter().write(data);
            httpResponse.getWriter().flush();
            return "qrpay.html";
        }
        return null;
    }

    @RequestMapping(value={"unifiedPay"})
    public String unifiedPay(@RequestParam(value="applyCode") String applyCode, @RequestParam(value="attach") String attach, HttpServletRequest request, HttpServletResponse response) {
        log.info("\u5e94\u7528id:{},\u9644\u52a0\uff1a{}", (Object)applyCode, (Object)attach);
        String useragent = request.getHeader("user-agent").toLowerCase();
        if (useragent.contains("micromessenger")) {
            log.info("\u5fae\u4fe1\u6d4f\u89c8\u5668\u5165\u53e3-------------------------");
            String getOpenIdUrl = this.aggregationService.getUnifiedPayOpenId(applyCode, attach, request, response);
            return getOpenIdUrl;
        }
        log.info("\u652f\u4ed8\u5b9d\u6d4f\u89c8\u5668\u5165\u53e3-------------------------");
        return "unifiedPay";
    }

    @PostMapping(value={"unifiedH5Pay"})
    @ResponseBody
    public BaseResponse<String> unifiedH5Pay(@RequestBody RequestWxH5PayVo requestWxH5PayVo, HttpServletRequest request, HttpServletResponse response) throws IOException {
        BaseResponse data = this.aggregationService.unifiedH5Pay(request, response, requestWxH5PayVo);
        return data;
    }

    @PostMapping(value={"unifiedHeePay"})
    @ResponseBody
    public BaseResponse<String> unifiedHeePay(@RequestBody RequestWxH5PayVo requestWxH5PayVo, HttpServletRequest request, HttpServletResponse response) throws IOException {
        BaseResponse data = this.aggregationService.unifiedHeePay(request, response, requestWxH5PayVo);
        return data;
    }

    @RequestMapping(value={"getAppAuthCode"})
    public String getAppAuthCode(HttpServletRequest request) {
        return this.aggregationService.getAppAuthCode(request);
    }

    @GetMapping(value={"getNameByApplyCode"})
    @ResponseBody
    public BaseResponse<String> getNameByApplyCode(@RequestParam(value="applyCode") String applyCode) {
        return this.aggregationService.getNameByApplyCode(applyCode);
    }

    @PostMapping(value={"/hee_Prepayment"})
    @ApiOperation(value="\u6c47\u4ed8\u5b9d")
    @ResponseBody
    public BaseResponse<String> heePrepayment(@Valid @RequestBody RequestCreateOrderVo requestCreateOrderVo) {
        return this.aggregationService.heePrepayment(requestCreateOrderVo);
    }

    @GetMapping(value={"/hee_pay"})
    public ModelAndView heePay(ModelMap model, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="outTradeNo") String outTradeNo) throws Exception {
        String qrUrl = this.aggregationService.payWithOrder(model, request, response, outTradeNo);
        return new ModelAndView(qrUrl);
    }

    @GetMapping(value={"/testHeePrepayment"})
    @ApiOperation(value="\u6c47\u4ed8\u5b9d\u6d4b\u8bd5")
    @ResponseBody
    public BaseResponse<String> testHeePrepayment(@RequestParam(value="totalAmount") String totalAmount) {
        log.info("qingqiulujing****testHeePrepayment******\u9032\u5165\u65b9\u6cd5***:");
        RequestCreateOrderVo requestCreateOrderVo = new RequestCreateOrderVo();
        requestCreateOrderVo.setTotalAmount(new BigDecimal(totalAmount));
        requestCreateOrderVo.setActuallyAmount(new BigDecimal(totalAmount));
        requestCreateOrderVo.setNonceStr("testHeePay");
        requestCreateOrderVo.setPayType("JSGZHAPI");
        requestCreateOrderVo.setServiceCode("test-service");
        requestCreateOrderVo.setApplyCode("\u6d6e\u5149\u4e4b\u4e18");
        requestCreateOrderVo.setMchCode("\u6d6e\u5149\u4e4b\u4e18");
        requestCreateOrderVo.setProductInfo("\u6c47\u4ed8\u5b9d\u5546\u54c1");
        String outTradeNo = LocalDate.now().getYear() + "" + LocalDate.now().getMonthValue() + "" + LocalDate.now().getDayOfMonth() + "" + LocalDateTime.now().getHour() + "" + LocalDateTime.now().getMinute() + "" + LocalDateTime.now().getSecond() + "" + LocalDateTime.now().getNano() + "";
        requestCreateOrderVo.setOutTradeNo(outTradeNo);
        log.info("\u652f\u4ed8\u53c2\u6570\u4e3a:{}", (Object)requestCreateOrderVo);
        return this.aggregationService.heePrepayment(requestCreateOrderVo);
    }

    @RequestMapping(value={"heePay"})
    public String heePay(@RequestParam(value="applyCode") String applyCode, @RequestParam(value="attach") String attach, HttpServletRequest request, HttpServletResponse response) {
        log.info("\u5e94\u7528Id:{},\u9644\u52a0:{}", (Object)applyCode, (Object)attach);
        String useragent = request.getHeader("user-agent").toLowerCase();
        if (useragent.contains("micromessenger")) {
            log.info("\u5fae\u4fe1\u652f\u4ed8----------------");
            String getOpenIdUrl = this.aggregationService.getHeePayOpenId(applyCode, attach, request, response);
            return getOpenIdUrl;
        }
        log.info("\u652f\u4ed8\u5b9d------------");
        return "heeUnifiedPay";
    }

    @PostMapping(value={"/createOrderHeePay"})
    public String createOrderHeePay(HttpServletRequest request, HttpServletResponse httpResponse, @RequestParam Map<String, Object> params) throws Exception {
        String payChannel = (String)params.get("payChannel");
        String outTradeNo = (String)params.get("outTradeNo");
        RequestCreateOrderH5VO requestCreateOrderH5VO = new RequestCreateOrderH5VO();
        requestCreateOrderH5VO.setOutTradeNo(outTradeNo);
        requestCreateOrderH5VO.setPayChannel(payChannel);
        if (null != requestCreateOrderH5VO.getPayChannel()) {
            BaseResponse orderLauncher = this.aggregationService.createOrderHeePay(request, requestCreateOrderH5VO);
            String data = (String)orderLauncher.getData();
            httpResponse.reset();
            httpResponse.setContentType("text/html;charset=UTF-8");
            httpResponse.getWriter().write(data);
            httpResponse.getWriter().flush();
            return "qrpay.html";
        }
        return null;
    }

    @GetMapping(value={"/transfer_save_openid"})
    public String saveTransferOpenId(@RequestParam(value="phone") String phone, @RequestParam(value="merchantNum") String merchantNum, @RequestParam(value="code", required=false) String code) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u7528\u6237openID\u9875\u9762");
        String getOpenIdUrl = this.aggregationService.getTransferOpenId(phone, merchantNum, code);
        boolean contains = getOpenIdUrl.contains("https");
        if (contains) {
            return "redirect:" + getOpenIdUrl;
        }
        return "authorizationSuccess.html";
    }

    @GetMapping(value={"/transfer_get_openid"})
    @ResponseBody
    public BaseResponse<String> getTransferOpenId(@RequestParam(value="phone") String phone, @RequestParam(value="merchantNum") String merchantNum) {
        String openId = this.userTransferInfoMapper.selectOpenIdByPhone(phone, merchantNum);
        return BaseResponse.success((Object)openId);
    }
}

