/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.payparam.AlipayNotifyParam;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.aggregation.payment.common.vo.UnionPayVo;
import com.ebaiyihui.aggregation.payment.server.config.WxPayConfiguration;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.enums.WechatTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.RabbitInfo;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.RabbitProduct;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.NotifyService;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PayCallbackService;
import com.ebaiyihui.aggregation.payment.server.service.PayMchService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.unionpay.UnionPayClient;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.AcpService;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.LogUtil;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtil;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import com.ebaiyihui.aggregation.payment.server.utils.StringUtil;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.service.WxPayService;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NotifyServiceImpl
implements NotifyService {
    private static final Logger log = LoggerFactory.getLogger(NotifyServiceImpl.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String SUCCESS_MSG = "OK";
    private static final String TRADE_STATUS = "TRADE_SUCCESS";
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    public static final String RESULT_SUCCESS = "SUCCESS";
    public static final String REFUND = "refund";
    public static final String PAY = "pay";
    @Autowired
    private PayCallbackService payCallbackService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RabbitProduct rabbitProduct;
    @Autowired
    private WxPayConfiguration wxPayConfiguration;
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PayMchService payMchService;
    @Autowired
    private PayApplyService payApplyService;

    public void notify(String type, String notifyRestVo) {
        String notifyUrl;
        log.info("\u83b7\u53d6\u56de\u8c03\u5730\u5740\uff0c\u51c6\u5907\u56de\u8c03");
        if ("refund".equals(type)) {
            ResponseRefundNotifyRestVo responseRefundNotifyRestVo = (ResponseRefundNotifyRestVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)notifyRestVo), ResponseRefundNotifyRestVo.class);
            PayBill payBill = this.payBillService.getByOutRefundNo(responseRefundNotifyRestVo.getOutRefundNo());
            if (null == payBill || null == payBill.getRefundNotifyUrl()) {
                log.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f,\u653e\u5f03\u4e1a\u52a1\u56de\u8c03!");
                return;
            }
            notifyUrl = payBill.getRefundNotifyUrl();
        } else {
            ResponseNotifyRestVo responseNotifyRestVo = (ResponseNotifyRestVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)notifyRestVo), ResponseNotifyRestVo.class);
            PayBill payBill = this.payBillService.getByDealTradeNo(responseNotifyRestVo.getDealTradeNo());
            if (null == payBill || null == payBill.getPayNotifyUrl()) {
                log.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f,\u653e\u5f03\u4e1a\u52a1\u56de\u8c03!");
                return;
            }
            notifyUrl = payBill.getPayNotifyUrl();
        }
        RabbitInfo rabbitInfo = new RabbitInfo();
        if (StringUtil.isEmpty((String)notifyUrl)) {
            log.info("====\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u5730\u5740\u4e3a\u7a7a\uff0c\u672c\u6b21\u64cd\u4f5c\u65e0\u56de\u8c03====");
            return;
        }
        log.info("\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u6570\u636e\u4e22\u7ed9rabbitmq\u6267\u884c");
        rabbitInfo.setUrl(notifyUrl);
        rabbitInfo.setType(type);
        rabbitInfo.setNotifyRestVo(notifyRestVo);
        this.rabbitProduct.pushA(rabbitInfo);
    }

    public String weChatPayNotify(HttpServletRequest request) {
        log.info("=====\u8fdb\u5165\u4e86\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03=====");
        try {
            String xmlResult = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
            WxPayOrderNotifyResult payResult = WxPayOrderNotifyResult.fromXML((String)xmlResult);
            log.info("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)payResult.toString());
            String dealTradeNo = payResult.getOutTradeNo();
            PayBill payBill = this.payBillService.getByDealTradeNo(dealTradeNo);
            String tradeType = payBill.getTradeType();
            if (payBill.getTradeType().equals(WechatTradeTypeEnum.NATIVE.getDisplay())) {
                tradeType = WechatTradeTypeEnum.JSPAI.getDisplay();
            }
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)this.mchChanService.getWxPayByMchCodeAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), tradeType)), WxPayParam.class);
            WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
            wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            wxPayService.getConfig().setTradeType(payBill.getTradeType());
            WxPayOrderNotifyResult wxPayOrderNotifyResult = wxPayService.parseOrderNotifyResult(xmlResult);
            log.info("\u3010\u5fae\u4fe1\u3011\u8c03\u7528SDK\u9a8c\u7b7e\u7ed3\u679c\uff1a{}", (Object)wxPayOrderNotifyResult.toString());
            String orderViewId = wxPayOrderNotifyResult.getOutTradeNo();
            log.info("\u3010\u5fae\u4fe1\u3011\u8ba2\u5355\u7684view_id\u662f{}", (Object)orderViewId);
            PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
            payBill.setTradeNo(wxPayOrderNotifyResult.getTransactionId());
            payBill.setStatus(OrderStatusEnum.PAID.getValue());
            payBill.setPayTime(DateUtils.stringToDate((String)"yyyyMMddHHmmss", (String)wxPayOrderNotifyResult.getTimeEnd()));
            log.info("\u5fae\u4fe1\u652f\u4ed8\u65f6\u95f4:{},\u7cfb\u7edf\u683c\u5f0f\u5316\u540e\u65f6\u95f4:{}", (Object)wxPayOrderNotifyResult.getTimeEnd(), (Object)payBill.getPayTime());
            log.info("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
            log.info("-------------\u3010\u5fae\u4fe1\u3011\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
            ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
            responseNotifyRestVo.setTradeNo(wxPayOrderNotifyResult.getTransactionId());
            responseNotifyRestVo.setReturnCode(wxPayOrderNotifyResult.getReturnCode());
            responseNotifyRestVo.setReturnMsg(wxPayOrderNotifyResult.getReturnMsg());
            responseNotifyRestVo.setResultCode(wxPayOrderNotifyResult.getResultCode());
            responseNotifyRestVo.setErrCode(wxPayOrderNotifyResult.getErrCode());
            responseNotifyRestVo.setErrCodeDes(wxPayOrderNotifyResult.getErrCodeDes());
            responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
            responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
            responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
            responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
            responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
            if (StringUtils.isNotBlank((CharSequence)payBill.getAttach())) {
                responseNotifyRestVo.setAttach(payBill.getAttach());
            }
            if (StringUtils.isNotBlank((CharSequence)payBill.getRemake())) {
                responseNotifyRestVo.setRemake(payBill.getRemake());
            }
            responseNotifyRestVo.setMchCode(payBill.getMchCode());
            responseNotifyRestVo.setMchId(wxPayOrderNotifyResult.getMchId());
            responseNotifyRestVo.setMchName(payMch.getName());
            String payTime = DateUtils.strToDateLong((String)wxPayOrderNotifyResult.getTimeEnd());
            responseNotifyRestVo.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)payTime));
            responseNotifyRestVo.setNotifyResultStr(JSON.toJSONString((Object)wxPayOrderNotifyResult));
            PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
            responseNotifyRestVo.setApplyId(payApply.getApplyId());
            Map signMap = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
            responseNotifyRestVo.setSign(sign);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
            log.info("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseNotifyRestVo.toString());
            this.notify("pay", JSON.toJSONString((Object)responseNotifyRestVo));
            String rediskey = payBill.getOutTradeNo() + "_" + payBill.getTradeType();
            this.redisTemplateService.del(rediskey);
            return WxPayNotifyResponse.success((String)"OK");
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            return WxPayNotifyResponse.fail((String)e.getMessage());
        }
    }

    public String weChatRefundNotify(HttpServletRequest request) {
        log.info("=====\u8fdb\u5165\u4e86\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03=====");
        try {
            String xmlResult = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
            log.info("\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u7ed3\u679c\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)xmlResult);
            WxPayRefundNotifyResult result = (WxPayRefundNotifyResult)BaseWxPayResult.fromXML((String)xmlResult, WxPayRefundNotifyResult.class);
            WxPayParam wxPayParam = this.mchChanService.getByMerchantsId(result.getMchId());
            WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
            wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            WxPayRefundNotifyResult refundResult = wxPayService.parseRefundNotifyResult(xmlResult);
            log.info("\u3010\u5fae\u4fe1\u3011\u8c03\u7528SDK\u9a8c\u7b7e\u7ed3\u679c\uff1a{}", (Object)refundResult.toString());
            String orderId = refundResult.getReqInfo().getOutTradeNo();
            log.info("\u8ba2\u5355\u53f7\uff1a{}", (Object)orderId);
            String outRefundNo = refundResult.getReqInfo().getOutRefundNo();
            log.info("\u9000\u6b3e\u53f7\uff1a{}", (Object)outRefundNo);
            PayBill payBill = this.payBillService.getByOutRefundNo(outRefundNo);
            if (null == payBill) {
                log.info("\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u56de\u8c03\uff0c\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25{}", (Object)payBill.toString());
                return WxPayNotifyResponse.fail((String)"\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25");
            }
            if (payBill.getStatus().equals(OrderStatusEnum.PAID.getValue())) {
                payBill.setRemake("\u6807\u8bb0:\u53c2\u6570\u6821\u9a8c\u5931\u8d25,\u9000\u6b3e\u6210\u529f\u8ba2\u5355!");
            }
            payBill.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
            payBill.setRefundTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)refundResult.getReqInfo().getSuccessTime()));
            payBill.setRefundNo(refundResult.getReqInfo().getRefundId());
            payBill.setOutRefundNo(refundResult.getReqInfo().getOutRefundNo());
            PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
            log.info("\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByRefundBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND, payBill.getOutRefundNo());
            log.info("-------------\u6784\u5efaResponseRefundNotifyRestVo\uff0c\u51c6\u5907\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u9000\u6b3e\u6d41\u7a0b-----------");
            ResponseRefundNotifyRestVo responseRefundNotifyRestVo = new ResponseRefundNotifyRestVo();
            responseRefundNotifyRestVo.setMchCode(payBill.getMchCode());
            responseRefundNotifyRestVo.setMchId(refundResult.getMchId());
            responseRefundNotifyRestVo.setMchName(payMch.getName());
            responseRefundNotifyRestVo.setReturnCode(refundResult.getReturnCode());
            responseRefundNotifyRestVo.setReturnMsg(refundResult.getReturnMsg());
            responseRefundNotifyRestVo.setErrCode(refundResult.getErrCode());
            responseRefundNotifyRestVo.setErrCodeDes(refundResult.getErrCodeDes());
            responseRefundNotifyRestVo.setPayChannel(payBill.getTradeChannel());
            responseRefundNotifyRestVo.setServiceCode(payBill.getServiceCode());
            responseRefundNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
            responseRefundNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
            responseRefundNotifyRestVo.setRefundNo(refundResult.getReqInfo().getRefundId());
            responseRefundNotifyRestVo.setTotalAmount(payBill.getDealAmount());
            responseRefundNotifyRestVo.setRefundMoney(BigDecimal.valueOf(Long.valueOf(refundResult.getReqInfo().getSettlementRefundFee().toString())).divide(new BigDecimal(100)));
            responseRefundNotifyRestVo.setRefundTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)refundResult.getReqInfo().getSuccessTime()));
            if (null != payBill.getServiceCode() && !"".equals(payBill.getServiceCode().trim())) {
                responseRefundNotifyRestVo.setAttach(payBill.getServiceCode());
            }
            if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                responseRefundNotifyRestVo.setRemake(payBill.getRemake());
            }
            responseRefundNotifyRestVo.setNotifyResultStr(JSON.toJSONString((Object)refundResult));
            PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
            responseRefundNotifyRestVo.setApplyId(payApply.getApplyId());
            responseRefundNotifyRestVo.setOutRefundNo(payBill.getOutRefundNo());
            Map signMap = SignUtil.getKeyAndValue((Object)responseRefundNotifyRestVo);
            String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
            responseRefundNotifyRestVo.setSign(sign);
            this.paymentRecordsService.saveByRefundBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK, payBill.getOutRefundNo());
            log.info("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseRefundNotifyRestVo.toString());
            this.notify("refund", JSON.toJSONString((Object)responseRefundNotifyRestVo));
            return WxPayNotifyResponse.success((String)"OK");
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            return WxPayNotifyResponse.fail((String)e.getMessage());
        }
    }

    public String aliPayNotify(HttpServletRequest request) {
        log.info("=====\u3010\u652f\u4ed8\u5b9d\u3011\u8fdb\u5165\u4e86\u652f\u4ed8\u5b9d\u56de\u8c03=====");
        log.info("===\u652f\u4ed8\u5b9d\u56de\u8c03\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)request.getParameterMap()));
        try {
            Map notifyparams = NotifyServiceImpl.convertRequestParamsToMap((HttpServletRequest)request);
            PayBill payBill = this.payBillService.getByOutTradeNo((String)notifyparams.get("out_trade_no"));
            log.info("===\u6839\u636e\u56de\u8c03\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f:{}", (Object)payBill);
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)this.mchChanService.getWxPayByMchCodeAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType())), WxPayParam.class);
            boolean signVerified = AlipaySignature.rsaCheckV1((Map)notifyparams, (String)wxPayParam.getMchPublicKey(), (String)"UTF-8", (String)"RSA2");
            if (!signVerified) {
                log.error("=======\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u5b9d\u9a8c\u7b7e\u5931\u8d25=======");
                return "failure";
            }
            BigDecimal bigDecimal = new BigDecimal((String)notifyparams.get("total_amount")).setScale(2, 1);
            BigDecimal orderAmount = payBill.getOrderAmount();
            int compare = bigDecimal.compareTo(orderAmount);
            log.info("\u4ed8\u6b3e\u91d1\u989d\u6bd4\u8f83\u7ed3\u679c:{}", (Object)compare);
            boolean refundFee = notifyparams.containsKey("refund_fee");
            String outTradeNo = (String)notifyparams.get("out_trade_no");
            log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u8ba2\u5355\u53f7\u662f{}", (Object)outTradeNo);
            if (compare == 0) {
                if (!refundFee) {
                    log.info("-------\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03----------");
                    payBill.setTradeNo((String)notifyparams.get("trade_no"));
                    payBill.setStatus(OrderStatusEnum.PAID.getValue());
                    payBill.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)((String)notifyparams.get("gmt_payment"))));
                    log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
                    this.payBillService.update(payBill);
                    this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
                    log.info("-------------\u3010\u652f\u4ed8\u5b9d\u3011\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
                    ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                    responseNotifyRestVo.setTradeNo((String)notifyparams.get("trade_no"));
                    responseNotifyRestVo.setReturnCode((String)notifyparams.get("code"));
                    responseNotifyRestVo.setReturnMsg((String)notifyparams.get("msg"));
                    responseNotifyRestVo.setResultCode("SUCCESS");
                    responseNotifyRestVo.setErrCode("");
                    responseNotifyRestVo.setErrCodeDes("error");
                    responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
                    responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
                    responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
                    responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
                    responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
                    if (StringUtils.isNotBlank((CharSequence)payBill.getAttach())) {
                        responseNotifyRestVo.setAttach(payBill.getAttach());
                    }
                    if (StringUtils.isNotBlank((CharSequence)payBill.getRemake())) {
                        responseNotifyRestVo.setRemake(payBill.getRemake());
                    }
                    responseNotifyRestVo.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)((String)notifyparams.get("gmt_payment"))));
                    PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
                    responseNotifyRestVo.setApplyId(payApply.getApplyId());
                    responseNotifyRestVo.setMchCode(payBill.getMchCode());
                    Map signMap = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
                    String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
                    responseNotifyRestVo.setSign(sign);
                    this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
                    log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseNotifyRestVo.toString());
                    this.notify("pay", JSON.toJSONString((Object)responseNotifyRestVo));
                    String redisKey = payBill.getOutTradeNo() + "_" + payBill.getTradeType();
                    this.redisTemplateService.del(redisKey);
                } else {
                    log.info("---------\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03--------------");
                    AlipayNotifyParam alipayNotifyParam = (AlipayNotifyParam)JSON.parseObject((String)JSON.toJSONString((Object)notifyparams), AlipayNotifyParam.class);
                    PayBill payBillRefund = this.payBillService.getByOutRefundNo((String)notifyparams.get("out_biz_no"));
                    payBillRefund.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
                    Date notify_time = DateUtil.getTextDate((String)((String)notifyparams.get("notify_time")), (String)"yyyy-MM-dd HH:mm:ss");
                    payBillRefund.setRefundTime(notify_time);
                    payBillRefund.setRefundNo((String)notifyparams.get("notify_id"));
                    payBillRefund.setOutRefundNo((String)notifyparams.get("out_biz_no"));
                    log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u4fee\u6539\u8ba2\u5355\u72b6\u6001{}", (Object)payBillRefund.toString());
                    this.payBillService.update(payBillRefund);
                    log.info("-------------\u3010\u652f\u4ed8\u5b9d\u3011\u6dfb\u52a0\u652f\u4ed8\u8bb0\u5f55\uff1a\u5df2\u9000\u6b3e-------------");
                    this.paymentRecordsService.saveByRefundBill(payBillRefund.getDealTradeNo(), payBillRefund.getServiceCode(), RecordsEnum.REFUND, (String)notifyparams.get("out_biz_no"));
                    log.info("-------------\u3010\u652f\u4ed8\u5b9d\u3011\u51c6\u5907\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u9000\u6b3e\u6d41\u7a0b-----------");
                    ResponseRefundNotifyRestVo responseRefundNotifyRestVo = new ResponseRefundNotifyRestVo();
                    responseRefundNotifyRestVo.setReturnCode((String)notifyparams.get("notify_type"));
                    responseRefundNotifyRestVo.setReturnMsg((String)notifyparams.get("trade_status"));
                    responseRefundNotifyRestVo.setErrCode("");
                    responseRefundNotifyRestVo.setErrCodeDes("");
                    responseRefundNotifyRestVo.setPayChannel(payBillRefund.getTradeChannel());
                    responseRefundNotifyRestVo.setServiceCode(payBillRefund.getServiceCode());
                    responseRefundNotifyRestVo.setOutTradeNo(payBillRefund.getOutTradeNo());
                    responseRefundNotifyRestVo.setDealTradeNo(payBillRefund.getDealTradeNo());
                    responseRefundNotifyRestVo.setRefundNo(payBillRefund.getOutRefundNo());
                    responseRefundNotifyRestVo.setTotalAmount(payBillRefund.getDealAmount());
                    responseRefundNotifyRestVo.setRefundMoney(alipayNotifyParam.getRefundFee());
                    if (null != payBillRefund.getServiceCode() && !"".equals(payBillRefund.getServiceCode().trim())) {
                        responseRefundNotifyRestVo.setAttach(payBillRefund.getServiceCode());
                    }
                    if (null != payBillRefund.getRemake() && !"".equals(payBillRefund.getRemake().trim())) {
                        responseRefundNotifyRestVo.setRemake(payBillRefund.getRemake());
                    }
                    responseRefundNotifyRestVo.setRefundTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)alipayNotifyParam.getGmtRefund().toString()));
                    PayApply payApply = this.payApplyService.getByApplyCode(payBillRefund.getMchCode());
                    responseRefundNotifyRestVo.setApplyId(payApply.getApplyId());
                    responseRefundNotifyRestVo.setMchCode(payBillRefund.getMchCode());
                    responseRefundNotifyRestVo.setOutRefundNo(payBillRefund.getOutRefundNo());
                    Map signMap = SignUtil.getKeyAndValue((Object)responseRefundNotifyRestVo);
                    String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
                    responseRefundNotifyRestVo.setSign(sign);
                    this.paymentRecordsService.saveByBill(payBillRefund.getDealTradeNo(), payBillRefund.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK);
                    log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u6570\u636e{}", (Object)responseRefundNotifyRestVo.toString());
                    this.notify("refund", JSON.toJSONString((Object)responseRefundNotifyRestVo));
                }
                return "success";
            }
            return "failure";
        }
        catch (AlipayApiException e) {
            log.error("\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u56de\u8c03\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            return "failure";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "failure";
        }
    }

    public String aliRefundNotify(HttpServletRequest request) {
        log.info("=====\u3010\u652f\u4ed8\u5b9d\u3011\u8fdb\u5165\u4e86\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03=====");
        Map notifyparams = NotifyServiceImpl.convertRequestParamsToMap((HttpServletRequest)request);
        log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)notifyparams));
        try {
            PayBill payBill = this.payBillService.getByOutRefundNo((String)notifyparams.get("out_biz_no"));
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)this.mchChanService.getWxPayByMchCodeAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType())), WxPayParam.class);
            boolean signVerified = AlipaySignature.rsaCheckV1((Map)notifyparams, (String)wxPayParam.getMchPublicKey(), (String)"UTF-8", (String)"RSA2");
            if (!signVerified) {
                log.info("=====\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03\u53c2\u6570\u9a8c\u7b7e\u5931\u8d25=====");
                return "failure";
            }
            AlipayNotifyParam alipayNotifyParam = (AlipayNotifyParam)JSON.parseObject((String)JSON.toJSONString((Object)notifyparams), AlipayNotifyParam.class);
            String orderId = alipayNotifyParam.getOutTradeNo();
            log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u8ba2\u5355\u53f7\uff1a{}", (Object)orderId);
            payBill.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
            payBill.setRefundTime(alipayNotifyParam.getGmtRefund());
            payBill.setRefundNo(alipayNotifyParam.getOutBizNo());
            log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u4fee\u6539\u8ba2\u5355\u72b6\u6001{}", (Object)payBill.toString());
            this.payBillService.update(payBill);
            log.info("-------------\u3010\u652f\u4ed8\u5b9d\u3011\u6dfb\u52a0\u652f\u4ed8\u8bb0\u5f55\uff1a\u5df2\u9000\u6b3e-------------");
            this.paymentRecordsService.saveByRefundBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND, payBill.getOutRefundNo());
            log.info("-------------\u3010\u652f\u4ed8\u5b9d\u3011\u51c6\u5907\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u9000\u6b3e\u6d41\u7a0b-----------");
            ResponseRefundNotifyRestVo responseRefundNotifyRestVo = new ResponseRefundNotifyRestVo();
            responseRefundNotifyRestVo.setReturnCode(alipayNotifyParam.getTradeStatus());
            responseRefundNotifyRestVo.setReturnMsg(alipayNotifyParam.getTradeStatus());
            responseRefundNotifyRestVo.setErrCode("");
            responseRefundNotifyRestVo.setErrCodeDes("");
            responseRefundNotifyRestVo.setPayChannel(payBill.getTradeChannel());
            responseRefundNotifyRestVo.setServiceCode(payBill.getServiceCode());
            responseRefundNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
            responseRefundNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
            responseRefundNotifyRestVo.setRefundNo(alipayNotifyParam.getOutBizNo());
            if (null != payBill.getServiceCode() && !"".equals(payBill.getServiceCode().trim())) {
                responseRefundNotifyRestVo.setAttach(payBill.getServiceCode());
            }
            if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                responseRefundNotifyRestVo.setRemake(payBill.getRemake());
            }
            responseRefundNotifyRestVo.setTotalAmount(payBill.getDealAmount());
            responseRefundNotifyRestVo.setRefundMoney(alipayNotifyParam.getRefundFee());
            responseRefundNotifyRestVo.setRefundTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)alipayNotifyParam.getGmtRefund().toString()));
            PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
            responseRefundNotifyRestVo.setApplyId(payApply.getApplyId());
            responseRefundNotifyRestVo.setMchCode(payBill.getMchCode());
            Map signMap = SignUtil.getKeyAndValue((Object)responseRefundNotifyRestVo);
            String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
            responseRefundNotifyRestVo.setSign(sign);
            responseRefundNotifyRestVo.setOutRefundNo(payBill.getOutRefundNo());
            this.paymentRecordsService.saveByRefundBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK, payBill.getOutRefundNo());
            log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u6570\u636e{}", (Object)responseRefundNotifyRestVo.toString());
            this.notify("refund", JSON.toJSONString((Object)responseRefundNotifyRestVo));
            return "success";
        }
        catch (Exception e) {
            log.error("\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03\u7ed3\u679c\u5f02\u5e38:\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            return "failure";
        }
    }

    public ResponseEntity<Object> unionPayBackNotify(HttpServletRequest req) {
        PayBill payBill;
        LogUtil.writeLog((String)"BackRcvResponse\u63a5\u6536\u540e\u53f0\u901a\u77e5\u5f00\u59cb");
        String encoding = req.getParameter("encoding");
        Map reqParam = NotifyServiceImpl.getAllRequestParam((HttpServletRequest)req);
        HashMap<String, String> valideData = null;
        if (null != reqParam && !reqParam.isEmpty()) {
            Iterator it = reqParam.entrySet().iterator();
            valideData = new HashMap<String, String>(reqParam.size());
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                valideData.put(key, value);
            }
        }
        if (null == (payBill = this.payBillService.getByDealTradeNo((String)valideData.get("orderId")))) {
            payBill = this.payBillService.getByTradeNo((String)valideData.get("origQryId"));
        }
        log.info("\u9000\u6b3e\u539f\u59cb\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
        if (null == payBill) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        log.info("\u5546\u6237\u6e20\u9053\u914d\u7f6e\u53c2\u6570{}", (Object)mchChan.toString());
        if (null == mchChan) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        UnionPayVo payParam = (UnionPayVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), UnionPayVo.class);
        UnionPayClient.setConfig((UnionPayVo)payParam);
        if (!AcpService.validate(valideData, (String)encoding)) {
            LogUtil.writeLog((String)"\u9a8c\u8bc1\u7b7e\u540d\u7ed3\u679c[\u5931\u8d25].");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        LogUtil.writeLog((String)"\u9a8c\u8bc1\u7b7e\u540d\u7ed3\u679c[\u6210\u529f].");
        String orderId = (String)valideData.get("orderId");
        if ("01".equals(valideData.get("txnType"))) {
            String orderViewId = (String)valideData.get("orderId");
            log.info("\u8ba2\u5355\u7684view_id\u662f{}", (Object)orderViewId);
            PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
            payBill.setTradeNo((String)valideData.get("queryId"));
            payBill.setStatus(OrderStatusEnum.PAID.getValue());
            payBill.setPayTime(DateUtils.stringToDate((String)"yyyyMMddHHmmss", (String)((String)valideData.get("txnTime"))));
            log.info("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
            log.info("-------------\u3010\u94f6\u8054\u3011\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
            ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
            responseNotifyRestVo.setTradeNo((String)valideData.get("queryId"));
            responseNotifyRestVo.setReturnCode((String)valideData.get("respCode"));
            responseNotifyRestVo.setReturnMsg((String)valideData.get("respMsg"));
            responseNotifyRestVo.setResultCode("SUCCESS");
            responseNotifyRestVo.setErrCode("");
            responseNotifyRestVo.setErrCodeDes("");
            responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
            responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
            responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
            responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
            responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
            responseNotifyRestVo.setMchCode(payBill.getMchCode());
            responseNotifyRestVo.setMchId((String)valideData.get("merId"));
            responseNotifyRestVo.setMchName(payMch.getName());
            if (null != payBill.getAttach() && !"".equals(payBill.getAttach().trim())) {
                responseNotifyRestVo.setAttach(payBill.getAttach());
            }
            if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                responseNotifyRestVo.setRemake(payBill.getRemake());
            }
            responseNotifyRestVo.setPayTime(payBill.getPayTime());
            PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
            responseNotifyRestVo.setApplyId(payApply.getApplyId());
            Map signMap = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
            responseNotifyRestVo.setSign(sign);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
            log.info("\u3010\u94f6\u8054\u3011\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseNotifyRestVo.toString());
        } else if ("04".equals(valideData.get("txnType"))) {
            log.info("\u8ba2\u5355\u53f7\uff1a{}", (Object)orderId);
            if (null == payBill) {
                log.info("\u3010\u94f6\u8054\u3011\u9000\u6b3e\u56de\u8c03\uff0c\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25{}", (Object)payBill.toString());
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            payBill.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
            payBill.setRefundTime(DateUtils.stringToDate((String)"yyyyMMddHHmmss", (String)((String)valideData.get("txnTime"))));
            payBill.setRefundNo((String)valideData.get("queryId"));
            payBill.setOutRefundNo(orderId);
            PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
            log.info("\u3010\u94f6\u8054\u3011\u9000\u6b3e\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND);
            log.info("-------------\u6784\u5efaResponseRefundNotifyRestVo\uff0c\u51c6\u5907\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u9000\u6b3e\u6d41\u7a0b-----------");
            ResponseRefundNotifyRestVo responseRefundNotifyRestVo = new ResponseRefundNotifyRestVo();
            responseRefundNotifyRestVo.setMchCode(payBill.getMchCode());
            responseRefundNotifyRestVo.setMchId((String)valideData.get("merId"));
            responseRefundNotifyRestVo.setMchName(payMch.getName());
            responseRefundNotifyRestVo.setReturnCode((String)valideData.get("respCode"));
            responseRefundNotifyRestVo.setReturnMsg((String)valideData.get("respMsg"));
            responseRefundNotifyRestVo.setErrCode("");
            responseRefundNotifyRestVo.setErrCodeDes("");
            responseRefundNotifyRestVo.setPayChannel(payBill.getTradeChannel());
            responseRefundNotifyRestVo.setServiceCode(payBill.getServiceCode());
            responseRefundNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
            responseRefundNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
            responseRefundNotifyRestVo.setRefundNo((String)valideData.get("queryId"));
            responseRefundNotifyRestVo.setTotalAmount(payBill.getDealAmount());
            if (null != payBill.getAttach() && !"".equals(payBill.getAttach().trim())) {
                responseRefundNotifyRestVo.setAttach(payBill.getAttach());
            }
            if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                responseRefundNotifyRestVo.setRemake(payBill.getRemake());
            }
            responseRefundNotifyRestVo.setRefundMoney(BigDecimal.valueOf(Long.valueOf((String)valideData.get("txnAmt"))).divide(new BigDecimal(100)));
            responseRefundNotifyRestVo.setRefundTime(payBill.getRefundTime());
            PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
            responseRefundNotifyRestVo.setApplyId(payApply.getApplyId());
            Map signMap = SignUtil.getKeyAndValue((Object)responseRefundNotifyRestVo);
            String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
            responseRefundNotifyRestVo.setSign(sign);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK);
            log.info("\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseRefundNotifyRestVo.toString());
            this.notify("refund", JSON.toJSONString((Object)responseRefundNotifyRestVo));
        }
        LogUtil.writeLog((String)"BackRcvResponse\u63a5\u6536\u540e\u53f0\u901a\u77e5\u7ed3\u675f");
        return new ResponseEntity(HttpStatus.OK);
    }

    private static Map<String, String> convertRequestParamsToMap(HttpServletRequest request) {
        HashMap<String, String> retMap = new HashMap<String, String>(16);
        Set entrySet = request.getParameterMap().entrySet();
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            int valLen = values.length;
            if (valLen == 1) {
                retMap.put(name, values[0]);
                continue;
            }
            if (valLen > 1) {
                StringBuilder sb = new StringBuilder();
                for (String val : values) {
                    sb.append(",").append(val);
                }
                retMap.put(name, sb.toString().substring(1));
                continue;
            }
            retMap.put(name, "");
        }
        return retMap;
    }

    public static Map<String, String> getAllRequestParam(HttpServletRequest request) {
        HashMap<String, String> res = new HashMap<String, String>();
        Enumeration temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String)temp.nextElement();
                String value = request.getParameter(en);
                res.put(en, value);
                if (res.get(en) != null && !"".equals(res.get(en))) continue;
                res.remove(en);
            }
        }
        return res;
    }
}

