/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.vo.datastatistics.PayDataStatisticsReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.datastatistics.PayDataStatisticsResp;
import com.ebaiyihui.aggregation.payment.common.vo.datastatistics.PaySataStatistics;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.service.BaseService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillDataStatisticsService;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PayBillDataStatisticsServiceImpl
extends BaseService
implements PayBillDataStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(PayBillDataStatisticsServiceImpl.class);

    public void dataStatistics(LocalDate localDate) {
        long startTime = System.currentTimeMillis();
        log.info("\u6267\u884c\u5f00\u59cb:" + startTime);
        String wechatTradeChannel = "WECHAT";
        String aliTradeChannel = "ALIPAY";
        String unknownTradeChannel = "UNKNOWN";
        int articleDealingWithNumberOf = 500;
        QueryWrapper queryPayApplyWrapper = new QueryWrapper((Object)new PayApply());
        List payApplies = this.payApplyMapper.selectList((Wrapper)queryPayApplyWrapper);
        payApplies.stream().forEach(payApply -> {
            String applyCode = payApply.getApplyCode();
            PaySataStatistics paySataStatistics = new PaySataStatistics();
            paySataStatistics.setApplyCode(applyCode);
            paySataStatistics.setStatisticsDate(new Date());
            paySataStatistics.setDataTime(localDate.toString());
            int num = 0;
            int[] paySuccess = new int[]{0};
            int[] refundSuccess = new int[]{0};
            while (true) {
                PayBill queryPayBill = new PayBill();
                queryPayBill.setMchCode(applyCode);
                QueryWrapper queryPayBillWrapper = new QueryWrapper((Object)queryPayBill);
                ((QueryWrapper)((QueryWrapper)queryPayBillWrapper.like((Object)"pay_time", (Object)localDate.toString())).or()).like((Object)"refund_time", (Object)localDate.toString());
                IPage payBillPage = this.payBillMapper.selectPage((IPage)new Page((long)num, (long)articleDealingWithNumberOf), (Wrapper)queryPayBillWrapper);
                paySataStatistics.setPayCount((int)payBillPage.getTotal());
                if (CollectionUtils.isEmpty((Collection)payBillPage.getRecords())) break;
                ++num;
                payBillPage.getRecords().forEach(payBill -> {
                    if (payBill.getStatus().equals(OrderStatusEnum.PAID.getValue())) {
                        paySuccess[0] = paySuccess[0] + 1;
                        paySataStatistics.setPayPrices(new BigDecimal(StringUtils.isBlank((CharSequence)paySataStatistics.getPayPrices()) ? "0" : paySataStatistics.getPayPrices()).add(payBill.getDealAmount()).toString());
                        if (wechatTradeChannel.equals(payBill.getTradeChannel())) {
                            paySataStatistics.setWechatPayCount(paySataStatistics.getWechatPayCount() + 1);
                            paySataStatistics.setWechatPayPrice(paySataStatistics.getWechatPayPrice() + Double.parseDouble(payBill.getDealAmount().toString()));
                        } else if (aliTradeChannel.equals(payBill.getTradeChannel())) {
                            paySataStatistics.setAliPayCount(paySataStatistics.getAliPayCount() + 1);
                            paySataStatistics.setAliPayPrice(paySataStatistics.getAliPayPrice() + Double.parseDouble(payBill.getDealAmount().toString()));
                        } else if (unknownTradeChannel.equals(payBill.getTradeChannel())) {
                            paySataStatistics.setAggregationPayCount(paySataStatistics.getAggregationPayCount() + 1);
                            paySataStatistics.setAggregationPayPrice(paySataStatistics.getAggregationPayPrice() + Double.parseDouble(payBill.getDealAmount().toString()));
                        }
                    } else if (payBill.getStatus().equals(OrderStatusEnum.HAVE_A_REFUND.getValue())) {
                        refundSuccess[0] = refundSuccess[0] + 1;
                        paySataStatistics.setRefundPrices(new BigDecimal(StringUtils.isBlank((CharSequence)paySataStatistics.getRefundPrices()) ? "0" : paySataStatistics.getRefundPrices()).add(Objects.isNull(payBill.getRefundAmount()) ? new BigDecimal("0") : payBill.getRefundAmount()).toString());
                        if (wechatTradeChannel.equals(payBill.getTradeChannel())) {
                            if (Objects.nonNull(payBill.getRefundAmount())) {
                                paySataStatistics.setWechatRefundPrice(paySataStatistics.getWechatRefundPrice() + Double.parseDouble(payBill.getRefundAmount().toString()));
                            }
                            paySataStatistics.setWechatRefundCount(paySataStatistics.getWechatRefundCount() + 1);
                        } else if (aliTradeChannel.equals(payBill.getTradeChannel())) {
                            paySataStatistics.setAliRefundCount(paySataStatistics.getAliRefundCount() + 1);
                            if (Objects.nonNull(payBill.getRefundAmount())) {
                                paySataStatistics.setAliRefundPrice(paySataStatistics.getAliRefundPrice() + Double.parseDouble(payBill.getRefundAmount().toString()));
                            }
                        } else if (unknownTradeChannel.equals(payBill.getTradeChannel())) {
                            paySataStatistics.setAggregationRefundCount(paySataStatistics.getAggregationRefundCount() + 1);
                            if (Objects.nonNull(payBill.getRefundAmount())) {
                                paySataStatistics.setAggregationRefundPrice(paySataStatistics.getAggregationRefundPrice() + Double.parseDouble(payBill.getRefundAmount().toString()));
                            }
                        }
                    }
                });
            }
            if (Objects.nonNull(paySataStatistics)) {
                int orders = paySuccess[0] + refundSuccess[0];
                log.info("\u652f\u4ed8\u6210\u529f\u4e0e\u9000\u6b3e\u6210\u529f\u603b\u6570\u91cf\u4e3a:" + orders);
                if (orders > 0) {
                    String conditions = ".00";
                    DecimalFormat df = new DecimalFormat("#.00");
                    String wechatPercentage = df.format((double)(paySataStatistics.getWechatPayCount() + paySataStatistics.getWechatRefundCount()) / (double)orders * 100.0);
                    String aliPercentage = df.format((double)(paySataStatistics.getAliPayCount() + paySataStatistics.getAliRefundCount()) / (double)orders * 100.0);
                    String ylPercentage = df.format((double)(paySataStatistics.getYlPayCount() + paySataStatistics.getYlRefundCount()) / (double)orders * 100.0);
                    String aggregationPercentage = df.format((double)(paySataStatistics.getAggregationPayCount() + paySataStatistics.getAggregationRefundCount()) / (double)orders * 100.0);
                    if (!conditions.equals(wechatPercentage)) {
                        paySataStatistics.setWechatPercentage(wechatPercentage);
                    }
                    if (!conditions.equals(aliPercentage)) {
                        paySataStatistics.setAliPercentage(aliPercentage);
                    }
                    if (!conditions.equals(ylPercentage)) {
                        paySataStatistics.setYlPercentage(ylPercentage);
                    }
                    if (!conditions.equals(aggregationPercentage)) {
                        paySataStatistics.setAggregationPercentage(aggregationPercentage);
                    }
                }
                this.paySataStatisticsMapper.insert((Object)paySataStatistics);
            }
        });
        long endTime = System.currentTimeMillis();
        System.out.println("\u672c\u6b21\u6267\u884c\u65f6\u95f4:" + (endTime - startTime));
    }

    public PayDataStatisticsResp queryDataStatistics(PayDataStatisticsReqVO payDataStatisticsReqVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"apply_code", (Object)payDataStatisticsReqVO.getApplyCode());
        queryWrapper.between((Object)"data_time", (Object)payDataStatisticsReqVO.getStartTime().toString(), (Object)payDataStatisticsReqVO.getEndTime().toString());
        List paySataStatistics = this.paySataStatisticsMapper.selectList((Wrapper)queryWrapper);
        PayDataStatisticsResp payDataStatisticsResp = new PayDataStatisticsResp();
        payDataStatisticsResp.setResult(paySataStatistics);
        log.info("\u67e5\u8be2\u7ed3\u679c:" + paySataStatistics);
        AtomicReference<Integer> wechatPayCount = new AtomicReference<Integer>(0);
        AtomicReference<Integer> wechatRefundCount = new AtomicReference<Integer>(0);
        AtomicReference<Double> wechatPayPrice = new AtomicReference<Double>(0.0);
        AtomicReference<Double> wechatRefundPrice = new AtomicReference<Double>(0.0);
        AtomicReference<Integer> aliPayCount = new AtomicReference<Integer>(0);
        AtomicReference<Integer> aliRefundCount = new AtomicReference<Integer>(0);
        AtomicReference<Double> aliPayPrice = new AtomicReference<Double>(0.0);
        AtomicReference<Double> aliRefundPrice = new AtomicReference<Double>(0.0);
        AtomicReference<Integer> ylPayCount = new AtomicReference<Integer>(0);
        AtomicReference<Integer> ylRefundCount = new AtomicReference<Integer>(0);
        AtomicReference<Integer> aggregationPayCount = new AtomicReference<Integer>(0);
        AtomicReference<Integer> aggregationRefundCount = new AtomicReference<Integer>(0);
        AtomicReference<Double> aggregationPayPrice = new AtomicReference<Double>(0.0);
        AtomicReference<Double> aggregationRefundPrice = new AtomicReference<Double>(0.0);
        paySataStatistics.forEach(data -> {
            wechatPayCount.set((Integer)wechatPayCount.get() + data.getWechatPayCount());
            wechatRefundCount.set((Integer)wechatRefundCount.get() + data.getWechatRefundCount());
            wechatPayPrice.set((Double)wechatPayPrice.get() + data.getWechatPayPrice());
            wechatRefundPrice.set((Double)wechatRefundPrice.get() + data.getWechatRefundPrice());
            aliPayCount.set((Integer)aliPayCount.get() + data.getAliPayCount());
            aliRefundCount.set((Integer)aliRefundCount.get() + data.getAliRefundCount());
            aliPayPrice.set((Double)aliPayPrice.get() + data.getAliPayPrice());
            aliRefundPrice.set((Double)aliPayPrice.get() + data.getAliRefundPrice());
            ylPayCount.set((Integer)ylPayCount.get() + data.getYlPayCount());
            ylRefundCount.set((Integer)ylRefundCount.get() + data.getYlRefundCount());
            aggregationPayCount.set((Integer)aggregationPayCount.get() + data.getAggregationPayCount());
            aggregationRefundCount.set((Integer)aggregationRefundCount.get() + data.getAggregationRefundCount());
            aggregationPayPrice.set((Double)aggregationPayPrice.get() + data.getAggregationPayPrice());
            aggregationRefundPrice.set((Double)aggregationRefundPrice.get() + data.getAggregationRefundPrice());
        });
        int orders = wechatPayCount.get() + wechatRefundCount.get() + aliPayCount.get() + aliRefundCount.get() + ylPayCount.get() + ylRefundCount.get() + aggregationPayCount.get() + aggregationRefundCount.get();
        DecimalFormat df = new DecimalFormat("#0.00");
        String conditions = ".00";
        if (orders >= 0) {
            String wechatPercentage = df.format((double)(wechatPayCount.get() + wechatRefundCount.get()) / (double)orders * 100.0);
            String aliPercentage = df.format((double)(aliPayCount.get() + aliRefundCount.get()) / (double)orders * 100.0);
            String ylPercentage = df.format((double)(ylPayCount.get() + ylRefundCount.get()) / (double)orders * 100.0);
            String aggregationPercentage = df.format((double)(aggregationPayCount.get() + aggregationRefundCount.get()) / (double)orders * 100.0);
            payDataStatisticsResp.setWechatPercentage(!wechatPercentage.equals(conditions) ? wechatPercentage : "0");
            payDataStatisticsResp.setYlPercentage(!ylPercentage.equals(conditions) ? ylPercentage : "0");
            payDataStatisticsResp.setAliPercentage(!aliPercentage.equals(conditions) ? aliPercentage : "0");
            payDataStatisticsResp.setAggregationPercentage(!aggregationPercentage.equals(conditions) ? aggregationPercentage : "0");
        }
        payDataStatisticsResp.setWechatSumPayNum(wechatPayCount.get().toString());
        payDataStatisticsResp.setAliSumPayNum(aliPayCount.get().toString());
        payDataStatisticsResp.setYlSumPayNum(ylPayCount.get().toString());
        payDataStatisticsResp.setAggregationSumNum(aggregationPayCount.get().toString());
        String wechatSumPayPrices = df.format(wechatPayPrice.get());
        String aliSumPayPrices = df.format(aliPayPrice.get());
        String aggregationSumPayPrices = df.format(aggregationPayPrice.get());
        payDataStatisticsResp.setWechatSumPayPrices(!wechatSumPayPrices.equals(conditions) ? wechatSumPayPrices : "0");
        payDataStatisticsResp.setAliSumPayPrices(!aliSumPayPrices.equals(conditions) ? aliSumPayPrices : "0");
        payDataStatisticsResp.setAggregationSumPayPrices(!aggregationSumPayPrices.equals(conditions) ? aggregationSumPayPrices : "0");
        String wechatSumRefundPrices = df.format(wechatRefundPrice.get());
        String aliSumRefundPrices = df.format(aliRefundPrice.get());
        String aggregationSumRefundPrices = df.format(aggregationRefundPrice.get());
        payDataStatisticsResp.setWechatSumRefundPrices(!wechatSumRefundPrices.equals(conditions) ? wechatSumRefundPrices : "0");
        payDataStatisticsResp.setAliSumRefundPrices(!aliSumRefundPrices.equals(conditions) ? aliSumRefundPrices : "0");
        payDataStatisticsResp.setAggregationSumRefundPrices(!aggregationSumRefundPrices.equals(conditions) ? aggregationSumRefundPrices : "0");
        payDataStatisticsResp.setWechatSumRefundNum(wechatRefundCount.get().toString());
        payDataStatisticsResp.setAliSumRefundNum(aliRefundCount.get().toString());
        payDataStatisticsResp.setAggregationSumRefundNum(aggregationRefundCount.get().toString());
        return payDataStatisticsResp;
    }
}

