/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestDownloadVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.service.impl.WechatPayServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/trade"})
@Api(tags={"\u652f\u4ed8\u63a5\u53e3"})
public class TradeController {
    @Autowired
    WechatPayServiceImpl wechatPayService;

    @PostMapping(value={"/create-order"})
    public BaseResponse<String> createOrder(HttpServletRequest request, @Valid @RequestBody RequestCreateOrderVo requestCreateOrderVo) {
        if (requestCreateOrderVo.getPayChannel().equals(PayChanEnum.WECHAT.getDisplay())) {
            return this.wechatPayService.createOrder(request, requestCreateOrderVo);
        }
        return new BaseResponse();
    }

    @PostMapping(value={"/refund"})
    public BaseResponse<String> refund(@Valid @RequestBody RequestRefundOrderVo requestRefundOrderVo) {
        if (requestRefundOrderVo.getPayChannel().equals(PayChanEnum.WECHAT.getDisplay())) {
            return this.wechatPayService.refundOrder(requestRefundOrderVo);
        }
        return new BaseResponse();
    }

    @PostMapping(value={"/download"})
    public BaseResponse downloadBill(@RequestBody RequestDownloadVo requestDownloadVo) {
        if (PayChanEnum.WECHAT.getDisplay().equals(requestDownloadVo.getPayChannel())) {
            return this.wechatPayService.downLoadBill(requestDownloadVo);
        }
        return new BaseResponse();
    }
}

