/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller.notify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.NotifyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.service.WxPayService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notify"})
@Api(tags={"\u5f02\u6b65\u901a\u77e5\u63a5\u53e3"})
public class NotifyController {
    private static final Logger log = LoggerFactory.getLogger(NotifyController.class);
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private NotifyService notifyService;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;

    @ApiOperation(value="\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03")
    @RequestMapping(value={"/wechat"}, method={RequestMethod.GET, RequestMethod.POST})
    public String weChatNotify(HttpServletRequest request, HttpServletResponse response) {
        log.info("=====\u8fdb\u5165\u4e86\u652f\u4ed8\u56de\u8c03=====");
        try {
            String xmlResult = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
            WxPayOrderNotifyResult payResult = WxPayOrderNotifyResult.fromXML((String)xmlResult);
            String dealTradeNo = payResult.getOutTradeNo();
            PayBill payBill = this.payBillService.getByDealTradeNo(dealTradeNo);
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)this.mchChanService.getWxPayByMchCodeAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType())), WxPayParam.class);
            this.wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            this.wxPayService.getConfig().setTradeType(payBill.getTradeType());
            WxPayOrderNotifyResult result = this.wxPayService.parseOrderNotifyResult(xmlResult);
            String orderViewId = result.getOutTradeNo();
            log.info("\u5fae\u4fe1\u652f\u4ed8\u4fe1\u606f\uff1a{}", (Object)result);
            log.info("\u8ba2\u5355\u7684view_id\u662f{}", (Object)orderViewId);
            log.info("\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)payBill.toString());
            payBill.setTradeNo(result.getTransactionId());
            payBill.setStatus(OrderStatusEnum.PAID.getValue());
            payBill.setPayTime(DateUtils.stringToDate((String)"yyyyMMddHHmmss", (String)result.getTimeEnd()));
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
            try {
                log.info("-------------\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
                ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                responseNotifyRestVo.setMchId(result.getMchId());
                responseNotifyRestVo.setTradeNo(result.getTransactionId());
                responseNotifyRestVo.setReturnCode(result.getReturnCode());
                responseNotifyRestVo.setReturnMsg(result.getReturnMsg());
                responseNotifyRestVo.setResultCode(result.getResultCode());
                responseNotifyRestVo.setErrCode(result.getErrCode());
                responseNotifyRestVo.setErrCodeDes(result.getErrCodeDes());
                responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
                responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
                responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
                responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
                responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
                responseNotifyRestVo.setPayTime(DateUtils.stringToDate((String)"yyyyMMddHHmmss", (String)result.getTimeEnd()));
                this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
                this.notifyService.notify("pay", responseNotifyRestVo);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            this.redisTemplateService.del(payBill.getServiceCode() + "_" + payBill.getOutTradeNo());
            return WxPayNotifyResponse.success((String)"\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{}", (Object)e.getMessage());
            return WxPayNotifyResponse.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03")
    @RequestMapping(value={"/wechatRefund"}, method={RequestMethod.GET, RequestMethod.POST})
    public String weChatRefundNotify(HttpServletRequest request) {
        log.info("=====\u8fdb\u5165\u4e86\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03=====");
        try {
            String xmlResult = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
            log.info("\u9000\u6b3e\u7ed3\u679c-------------{}", (Object)xmlResult);
            WxPayRefundNotifyResult result = (WxPayRefundNotifyResult)BaseWxPayResult.fromXML((String)xmlResult, WxPayRefundNotifyResult.class);
            WxPayParam wxPayParam = this.mchChanService.getByMerchantsId(result.getMchId());
            this.wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            WxPayRefundNotifyResult refundResult = this.wxPayService.parseRefundNotifyResult(xmlResult);
            log.info("\u9000\u6b3e\u7ed3\u679c\uff1a{}", (Object)refundResult.getReqInfo().toString());
            String dealTradeNo = refundResult.getReqInfo().getOutTradeNo();
            log.info("\u8ba2\u5355\u53f7\uff1a{}", (Object)dealTradeNo);
            PayBill payBill = this.payBillService.getByDealTradeNo(dealTradeNo);
            payBill.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
            payBill.setRefundTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)refundResult.getReqInfo().getSuccessTime()));
            payBill.setRefundNo(refundResult.getReqInfo().getRefundId());
            payBill.setOutRefundNo(refundResult.getReqInfo().getOutRefundNo());
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND);
            try {
                log.info("-------------\u51c6\u5907\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u9000\u6b3e\u6d41\u7a0b-----------");
                ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                responseNotifyRestVo.setMchId(result.getMchId());
                responseNotifyRestVo.setTradeNo(refundResult.getReqInfo().getTransactionId());
                responseNotifyRestVo.setReturnCode(refundResult.getReturnCode());
                responseNotifyRestVo.setReturnMsg(refundResult.getReturnMsg());
                responseNotifyRestVo.setResultCode(refundResult.getResultCode());
                responseNotifyRestVo.setErrCode(refundResult.getErrCode());
                responseNotifyRestVo.setErrCodeDes(refundResult.getErrCodeDes());
                responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
                responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
                responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
                responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
                responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
                responseNotifyRestVo.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)refundResult.getReqInfo().getSuccessTime()));
                this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK);
                this.notifyService.notify("refund", responseNotifyRestVo);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            return WxPayNotifyResponse.success((String)"OK");
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{}", (Object)e.getMessage());
            return WxPayNotifyResponse.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03")
    @RequestMapping(value={"/alipay"})
    public String alipayNotify(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }
}

