/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.interceptor;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class SystemLogInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(SystemLogInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HttpSession session = request.getSession();
        session.setAttribute("startTime", (Object)System.currentTimeMillis());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod myHandlerMethod = (HandlerMethod)handler;
            Object bean = myHandlerMethod.getBean();
            Method method = myHandlerMethod.getMethod();
            HttpSession session = request.getSession();
            String uri = request.getRequestURI();
            StringBuilder stringBuilder = new StringBuilder();
            Map parameterMap = request.getParameterMap();
            parameterMap.forEach((k, v) -> {
                stringBuilder.append(k + "=");
                for (String str : v) {
                    stringBuilder.append(str + ",");
                }
            });
            String ipaddress = request.getHeader("x-forwarded-for") == null ? request.getRemoteAddr() : request.getHeader("x-forwarded-for");
            long startTime = (Long)session.getAttribute("startTime");
            long endTime = System.currentTimeMillis();
            log.info("\u8bf7\u6c42\u53c2\u6570:{};\u64cd\u4f5c\u65b9\u6cd5:{};\u521b\u5efa\u65f6\u95f4:{};\u8bf7\u6c42IP:{};\u8bf7\u6c42\u8def\u5f84:{};\u8bf7\u6c42\u65f6\u957f:{}", new Object[]{stringBuilder.toString(), bean.getClass().getSimpleName() + "." + method.getName(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(startTime)), ipaddress, uri, new Long(endTime - startTime) + "ms"});
            session.removeAttribute("startTime");
        }
    }
}

