/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.rabbitmq;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    public static final String QUEUE_A = "byh-aggregation-payment-queueA";
    public static final String QUEUE_B = "byh-aggregation-payment-queueB";
    public static final String EXCHANGE_A = "byh-aggregation-payment-exchangeA";
    public static final String EXCHANGE_B = "byh-aggregation-payment-exchangeB";
    public static final String RONGKEY = "notifyKey";
    public static final String DECLARE_KEY = "x-dead-letter-exchange";

    @Bean
    public Queue queueA() {
        return new Queue(QUEUE_A);
    }

    @Bean
    public Queue queueB() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(DECLARE_KEY, EXCHANGE_A);
        return new Queue(QUEUE_B, false, false, false, param);
    }

    @Bean
    public DirectExchange exchangeA() {
        return new DirectExchange(EXCHANGE_A);
    }

    @Bean
    public DirectExchange exchangeB() {
        return new DirectExchange(EXCHANGE_B);
    }

    @Bean
    public Binding bindingA(Queue queueA, DirectExchange exchangeA) {
        return BindingBuilder.bind((Queue)queueA).to(exchangeA).with(RONGKEY);
    }

    @Bean
    public Binding bindingB(Queue queueB, DirectExchange exchangeB) {
        return BindingBuilder.bind((Queue)queueB).to(exchangeB).with(RONGKEY);
    }
}

