/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayChan;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.RequestGetAppIdVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.RequestMchParamVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.RequestSaveMchParamVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.ResponseMchParamPageVo;
import com.ebaiyihui.aggregation.payment.server.mapper.MchChanMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayChanMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MchChanServiceImpl
implements MchChanService {
    private static final Logger log = LoggerFactory.getLogger(MchChanServiceImpl.class);
    @Autowired
    private MchChanMapper mchChanMapper;
    @Autowired
    private PayChanMapper payChanMapper;
    @Autowired
    private PayMchMapper payMchMapper;

    public void save(RequestSaveMchParamVo requestSaveMchParamVo) {
        MchChan mchChan = new MchChan();
        BeanUtils.copyProperties((Object)requestSaveMchParamVo, (Object)mchChan);
        mchChan.setStatus(Integer.valueOf(1));
        String param = JSON.toJSONString((Object)requestSaveMchParamVo.getWxPayParam());
        mchChan.setParam(param);
        this.mchChanMapper.insert((Object)mchChan);
    }

    public void update(ResponseMchParamPageVo responseMchParamPageVo) {
        MchChan mchChan = new MchChan();
        BeanUtils.copyProperties((Object)responseMchParamPageVo, (Object)mchChan);
        String param = JSON.toJSONString((Object)responseMchParamPageVo.getWxPayParam());
        mchChan.setParam(param);
        this.mchChanMapper.updateById((Object)mchChan);
    }

    public ResponseMchParamPageVo getById(Long id) {
        ResponseMchParamPageVo responseMchParamPageVo = new ResponseMchParamPageVo();
        MchChan mchChan = (MchChan)this.mchChanMapper.selectById((Serializable)id);
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        BeanUtils.copyProperties((Object)mchChan, (Object)responseMchParamPageVo);
        responseMchParamPageVo.setWxPayParam(wxPayParam);
        return responseMchParamPageVo;
    }

    public int delete(Long id) {
        return this.mchChanMapper.deleteById((Serializable)id);
    }

    public IPage<ResponseMchParamPageVo> getPage(RequestMchParamVo requestMchParamVo) {
        MchChan wrapperMchChan = new MchChan();
        QueryWrapper wrapper = new QueryWrapper();
        if (null != requestMchParamVo.getChanId()) {
            wrapperMchChan.setChanId(requestMchParamVo.getChanId());
        }
        if (null != requestMchParamVo.getMchId()) {
            wrapperMchChan.setMchId(requestMchParamVo.getMchId());
        }
        wrapper.setEntity((Object)wrapperMchChan);
        IPage mchChanIPage = this.mchChanMapper.selectPage((IPage)new Page((long)requestMchParamVo.getPageNum(), (long)requestMchParamVo.getPageSize()), (Wrapper)wrapper);
        List mchChans = mchChanIPage.getRecords();
        ArrayList<ResponseMchParamPageVo> responseMchParamPageVoList = new ArrayList<ResponseMchParamPageVo>();
        for (MchChan mchChan : mchChans) {
            ResponseMchParamPageVo responseMchParamPageVo = new ResponseMchParamPageVo();
            BeanUtils.copyProperties((Object)mchChan, (Object)responseMchParamPageVo);
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
            responseMchParamPageVo.setWxPayParam(wxPayParam);
            responseMchParamPageVoList.add(responseMchParamPageVo);
        }
        mchChanIPage.setRecords(responseMchParamPageVoList);
        return mchChanIPage;
    }

    public WxPayParam getWxPay(MchChan mchChan) {
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        return wxPayParam;
    }

    public String getWxPayByMchCodeAndChanCodeAndType(String mchCode, String chanCode, String type) {
        MchChan mchChan = this.getMchChanByMchCodeAndChanCodeAndType(mchCode, chanCode, type);
        return mchChan.getParam();
    }

    public MchChan getMchChanByMchCodeAndChanCodeAndType(String mchCode, String chanCode, String type) {
        PayMch tempPayMch = this.getPayMchCode(mchCode);
        PayChan tempPayChan = this.getPayChanCode(chanCode);
        MchChan wrappermchChan = new MchChan();
        wrappermchChan.setChanId(tempPayChan.getId());
        wrappermchChan.setType(type);
        wrappermchChan.setStatus(null);
        wrappermchChan.setMchId(tempPayMch.getId());
        QueryWrapper wrapper = new QueryWrapper((Object)wrappermchChan);
        MchChan mchChan = (MchChan)this.mchChanMapper.selectOne((Wrapper)wrapper);
        return mchChan;
    }

    private PayChan getPayChanCode(String chanCode) {
        PayChan WrapperpayChan = new PayChan();
        WrapperpayChan.setCode(chanCode);
        WrapperpayChan.setStatus(Integer.valueOf(1));
        QueryWrapper PayChanWrapper = new QueryWrapper((Object)WrapperpayChan);
        PayChanWrapper.last("limit 1");
        PayChan payChan = (PayChan)this.payChanMapper.selectOne((Wrapper)PayChanWrapper);
        return payChan;
    }

    private PayMch getPayMchCode(String mchCode) {
        PayMch WrapperPayMch = new PayMch();
        WrapperPayMch.setCode(mchCode);
        WrapperPayMch.setStatus(Integer.valueOf(1));
        QueryWrapper PayMchWrapper = new QueryWrapper((Object)WrapperPayMch);
        PayMchWrapper.last("limit 1");
        PayMch payMch = (PayMch)this.payMchMapper.selectOne((Wrapper)PayMchWrapper);
        return payMch;
    }

    public WxPayParam getByMerchantsId(String merchantsId) {
        MchChan wrapperChan = new MchChan();
        wrapperChan.setMerchantsMark(merchantsId);
        QueryWrapper wrapper = new QueryWrapper((Object)wrapperChan);
        wrapper.last("limit 1");
        MchChan mchChan = (MchChan)this.mchChanMapper.selectOne((Wrapper)wrapper);
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        return wxPayParam;
    }

    public WxPayParam getMchChanByMchIdAndChanId(String mchCode, String chanCode) {
        PayMch tempPayMch = this.getPayMchCode(mchCode);
        PayChan tempPayChan = this.getPayChanCode(chanCode);
        MchChan WrappermchChan = new MchChan();
        WrappermchChan.setMchId(tempPayMch.getId());
        WrappermchChan.setChanId(tempPayChan.getId());
        QueryWrapper Wrapper2 = new QueryWrapper((Object)WrappermchChan);
        Wrapper2.last("limit 1");
        MchChan mchChan = (MchChan)this.mchChanMapper.selectOne((Wrapper)Wrapper2);
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        return wxPayParam;
    }

    public BaseResponse<List<String>> getAppIdList(RequestGetAppIdVo requestGetAppIdVo) {
        PayMch tempPayMch = this.getPayMchCode(requestGetAppIdVo.getMchCode());
        PayChan tempPayChan = this.getPayChanCode(requestGetAppIdVo.getPayChannel());
        MchChan WrappermchChan = new MchChan();
        WrappermchChan.setMchId(tempPayMch.getId());
        WrappermchChan.setChanId(tempPayChan.getId());
        QueryWrapper Wrapper2 = new QueryWrapper((Object)WrappermchChan);
        List mchChans = this.mchChanMapper.selectList((Wrapper)Wrapper2);
        ArrayList<String> appIds = new ArrayList<String>();
        for (MchChan mchChan : mchChans) {
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
            appIds.add(wxPayParam.getAppId());
        }
        return BaseResponse.success(appIds);
    }
}

