/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.ebaiyihui.aggregation.payment.common.model.PayCallback;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.RabbitInfo;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.RabbitProduct;
import com.ebaiyihui.aggregation.payment.server.service.NotifyService;
import com.ebaiyihui.aggregation.payment.server.service.PayCallbackService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotifyServiceImpl
implements NotifyService {
    private static final Logger log = LoggerFactory.getLogger(NotifyServiceImpl.class);
    @Autowired
    private PayCallbackService payCallbackService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RabbitProduct rabbitProduct;

    public void notify(String type, ResponseNotifyRestVo responseNotifyRestVo) {
        PayCallback payCallback = this.payCallbackService.getByServiceCode(responseNotifyRestVo.getServiceCode());
        String notifyUrl = "refund".equals(type) ? payCallback.getRefundNotifyUrl() : payCallback.getPayNotifyUrl();
        RabbitInfo rabbitInfo = new RabbitInfo();
        rabbitInfo.setType(type);
        rabbitInfo.setResponseNotifyRestVo(responseNotifyRestVo);
        rabbitInfo.setUrl(notifyUrl);
        this.rabbitProduct.pushA(rabbitInfo);
    }
}

