/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PayCallback;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.paybillvo.RequesstPayBillPageVo;
import com.ebaiyihui.aggregation.payment.common.vo.paybillvo.ResponsePayBillDetailVo;
import com.ebaiyihui.aggregation.payment.server.mapper.PayBillMapper;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PayCallbackService;
import com.ebaiyihui.aggregation.payment.server.service.PayMchService;
import com.ebaiyihui.aggregation.payment.server.utils.StringUtil;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayBillServiceImpl
implements PayBillService {
    private static final Logger log = LoggerFactory.getLogger(PayBillServiceImpl.class);
    @Autowired
    private PayBillMapper payBillMapper;
    @Autowired
    private PayMchService payMchService;
    @Autowired
    private PayCallbackService payCallbackService;

    public void save(PayBill payBill) {
        this.payBillMapper.insert((Object)payBill);
    }

    public void update(PayBill payBill) {
        this.payBillMapper.updateById((Object)payBill);
    }

    public ResponsePayBillDetailVo getById(Long id) {
        PayBill payBill = (PayBill)this.payBillMapper.selectById((Serializable)id);
        ResponsePayBillDetailVo responsePayBillDetailVo = new ResponsePayBillDetailVo();
        BeanUtils.copyProperties((Object)payBill, (Object)responsePayBillDetailVo);
        PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
        PayCallback payCallback = this.payCallbackService.getByServiceCode(payBill.getServiceCode());
        responsePayBillDetailVo.setMchName(payMch.getName());
        responsePayBillDetailVo.setServiceName(payCallback.getServiceName());
        return responsePayBillDetailVo;
    }

    public int delete(Long id) {
        PayBill payBill = new PayBill();
        payBill.setStatus(Integer.valueOf(-1));
        payBill.setId(id);
        return this.payBillMapper.updateById((Object)payBill);
    }

    public IPage<PayBill> getPage(RequesstPayBillPageVo requesstPayBillPageVo) {
        PayBill payBill = new PayBill();
        QueryWrapper wrapper = new QueryWrapper();
        if (null != requesstPayBillPageVo.getStatus()) {
            payBill.setStatus(requesstPayBillPageVo.getStatus());
        }
        if (StringUtil.isNotEmpty((String)requesstPayBillPageVo.getMchCode())) {
            payBill.setMchCode(requesstPayBillPageVo.getMchCode());
        }
        if (StringUtil.isNotEmpty((String)requesstPayBillPageVo.getPaychannel())) {
            payBill.setTradeChannel(requesstPayBillPageVo.getPaychannel());
        }
        wrapper.setEntity((Object)payBill);
        if (StringUtil.isNotEmpty((String)requesstPayBillPageVo.getOrderNo())) {
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.like((Object)"out_trade_no", (Object)requesstPayBillPageVo.getOrderNo())).or()).like((Object)"deal_trade_no", (Object)requesstPayBillPageVo.getOrderNo())).or()).like((Object)"trade_no", (Object)requesstPayBillPageVo.getOrderNo())).or()).like((Object)"service_code", (Object)requesstPayBillPageVo.getOrderNo());
        }
        return this.payBillMapper.selectPage((IPage)new Page((long)requesstPayBillPageVo.getPageNum(), (long)requesstPayBillPageVo.getPageSize()), (Wrapper)wrapper);
    }

    public PayBill getByDealTradeNo(String dealTradeNo) {
        PayBill wrapperpayBill = new PayBill();
        wrapperpayBill.setDealTradeNo(dealTradeNo);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)wrapperpayBill);
        return (PayBill)this.payBillMapper.selectOne((Wrapper)wrapper);
    }

    public PayBill getByCreateOrder(RequestCreateOrderVo createOrderVo) {
        PayBill payBill = new PayBill();
        payBill.setOutTradeNo(createOrderVo.getOutTradeNo());
        payBill.setDealAmount(createOrderVo.getTotalAmount());
        payBill.setOrderAmount(createOrderVo.getTotalAmount());
        payBill.setMchCode(createOrderVo.getMchCode());
        payBill.setTradeChannel(createOrderVo.getPayChannel());
        payBill.setGoodsInfo(createOrderVo.getProductInfo());
        payBill.setTradeType(createOrderVo.getPayType());
        payBill.setStatus(Integer.valueOf(1));
        payBill.setServiceCode(createOrderVo.getServiceCode());
        return payBill;
    }

    public PayBill getByOutTradeNoAndStatus(String outTradeNo, Integer status) {
        PayBill WrapperpayBill = new PayBill();
        WrapperpayBill.setOutTradeNo(outTradeNo);
        WrapperpayBill.setStatus(status);
        QueryWrapper Wrapper2 = new QueryWrapper((Object)WrapperpayBill);
        Wrapper2.last("limit 1");
        return (PayBill)this.payBillMapper.selectOne((Wrapper)Wrapper2);
    }
}

