/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ebaiyihui.aggregation.payment.common.model.PayCallback;
import com.ebaiyihui.aggregation.payment.common.vo.paycallbackvo.PayCallBackVo;
import com.ebaiyihui.aggregation.payment.common.vo.paycallbackvo.RequestCallBackVo;
import com.ebaiyihui.aggregation.payment.common.vo.paycallbackvo.RequestPagePayCallBackVo;
import com.ebaiyihui.aggregation.payment.server.mapper.PayCallbackMapper;
import com.ebaiyihui.aggregation.payment.server.service.PayCallbackService;
import com.ebaiyihui.aggregation.payment.server.utils.StringUtil;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayCallbackServiceImpl
implements PayCallbackService {
    private static final Logger log = LoggerFactory.getLogger(PayCallbackServiceImpl.class);
    @Autowired
    private PayCallbackMapper payCallbackMapper;

    public void save(RequestCallBackVo payCallbackVo) {
        PayCallback payCallback = new PayCallback();
        BeanUtils.copyProperties((Object)payCallbackVo, (Object)payCallback);
        this.payCallbackMapper.insert((Object)payCallback);
    }

    public void update(PayCallback payCallback) {
        this.payCallbackMapper.updateById((Object)payCallback);
    }

    public PayCallback getById(Long id) {
        return (PayCallback)this.payCallbackMapper.selectById((Serializable)id);
    }

    public int delete(Long id) {
        return this.payCallbackMapper.deleteById((Serializable)id);
    }

    public IPage<PayCallback> getPage(RequestPagePayCallBackVo requestPagePayCallBackVo) {
        PayCallback wrapperPayCallBack = new PayCallback();
        PayCallBackVo payCallBackVo = requestPagePayCallBackVo.getPayCallBackVo();
        if (payCallBackVo.getStatus() == 1 || payCallBackVo.getStatus() == -1) {
            wrapperPayCallBack.setStatus(Integer.valueOf(payCallBackVo.getStatus()));
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)wrapperPayCallBack);
        if (StringUtil.isNotEmpty((String)payCallBackVo.getMchName())) {
            wrapper.like((Object)"mch_name", (Object)payCallBackVo.getMchName());
        }
        if (StringUtil.isNotEmpty((String)payCallBackVo.getServiceCode())) {
            wrapper.like((Object)"service_code", (Object)payCallBackVo.getServiceCode());
        }
        if (StringUtil.isNotEmpty((String)payCallBackVo.getServiceName())) {
            wrapper.like((Object)"service_name", (Object)payCallBackVo.getServiceName());
        }
        return this.payCallbackMapper.selectPage((IPage)new Page((long)requestPagePayCallBackVo.getPageNum(), (long)requestPagePayCallBackVo.getPageSize()), (Wrapper)wrapper);
    }

    public PayCallback getByServiceCode(String serviceCode) {
        PayCallback WrapperpayCallback = new PayCallback();
        WrapperpayCallback.setServiceCode(serviceCode);
        QueryWrapper Wrapper2 = new QueryWrapper((Object)WrapperpayCallback);
        return (PayCallback)this.payCallbackMapper.selectOne((Wrapper)Wrapper2);
    }

    public Boolean checkServiceCode(Long id, String serviceCode) {
        PayCallback payCallback = this.getByServiceCode(serviceCode);
        if (id == null) {
            if (payCallback == null) {
                return true;
            }
            return false;
        }
        if (payCallback == null || payCallback.getId().equals(id)) {
            return true;
        }
        return false;
    }
}

