/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.druid.util.DruidWebUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCloseOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestDownloadVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseCloseOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.enums.WechatTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.service.TradeService;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDownloadBillRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxPayBillResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WechatPayServiceImpl
implements TradeService {
    private static final Logger log = LoggerFactory.getLogger(WechatPayServiceImpl.class);
    private static final String RETURN_CODE = "SUCCESS";
    private static final String BILL_TYPE = "ALL";
    @Value(value="${wx.pay.refundNotifyUrl}")
    private String refundNotifyUrl;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RedisTemplateService redisTemplateService;

    public BaseResponse<String> createOrder(HttpServletRequest request, RequestCreateOrderVo createOrderVo) {
        log.info("\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570:{}", (Object)createOrderVo);
        String redisKey = createOrderVo.getServiceCode() + "_" + createOrderVo.getOutTradeNo();
        boolean res = this.redisTemplateService.get(redisKey);
        if (res) {
            Long time = this.redisTemplateService.getTime(redisKey);
            return BaseResponse.error((String)("\u91cd\u590d\u652f\u4ed8\u9501\u5b9a\u4e2d\uff0c\u91cd\u8bd5\u9700" + time + "\u79d2"));
        }
        this.redisTemplateService.set(redisKey);
        PayBill pb = this.payBillService.getByOutTradeNoAndStatus(createOrderVo.getOutTradeNo(), OrderStatusEnum.PAID.getValue());
        if (null != pb) {
            return BaseResponse.error((String)"\u5df2\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
        }
        String orderViewId = UniqueKeyGenerator.generateViewId();
        PayBill payBill = this.payBillService.getByCreateOrder(createOrderVo);
        log.info("\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)payBill);
        payBill.setDealTradeNo(orderViewId);
        this.payBillService.save(payBill);
        this.paymentRecordsService.saveByBill(orderViewId, createOrderVo.getServiceCode(), RecordsEnum.DID_NOT_PAY);
        try {
            MchChan mchChan = this.mchChanService.getMchChanByMchCodeAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
            WxPayUnifiedOrderRequest orderRequest = new WxPayUnifiedOrderRequest();
            orderRequest.setBody(createOrderVo.getProductInfo());
            orderRequest.setOutTradeNo(orderViewId);
            orderRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)createOrderVo.getTotalAmount().toString()));
            orderRequest.setOpenid(createOrderVo.getUserSign());
            orderRequest.setAppid(wxPayParam.getAppId());
            orderRequest.setSpbillCreateIp(DruidWebUtils.getRemoteAddr((HttpServletRequest)request));
            orderRequest.setAttach(createOrderVo.getServiceCode());
            this.wxPayService.getConfig().setMchId(mchChan.getMerchantsMark());
            this.wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            this.wxPayService.getConfig().setTradeType(createOrderVo.getPayType());
            if (createOrderVo.getPayType().equals(WechatTradeTypeEnum.JSPAI.getDisplay())) {
                WxPayMpOrderResult wxPayMpOrderResult = (WxPayMpOrderResult)this.wxPayService.createOrder(orderRequest);
                String sign = wxPayMpOrderResult.getPaySign();
                log.info("\u7b7e\u540d\u662f:{}", (Object)sign);
                return BaseResponse.success((Object)JSON.toJSONString((Object)wxPayMpOrderResult));
            }
            if (createOrderVo.getPayType().equals(WechatTradeTypeEnum.APP.getDisplay())) {
                WxPayAppOrderResult wxPayMpOrderResult = (WxPayAppOrderResult)this.wxPayService.createOrder(orderRequest);
                String sign = wxPayMpOrderResult.getSign();
                log.info("\u7b7e\u540d\u662f:{}", (Object)sign);
                return BaseResponse.success((Object)JSON.toJSONString((Object)wxPayMpOrderResult));
            }
            return BaseResponse.error((String)"\u652f\u4ed8\u6e20\u9053\u672a\u77e5");
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u9884\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{}", (Object)orderViewId, (Object)e.getMessage());
            e.printStackTrace();
            return BaseResponse.error((String)"\u9884\u652f\u4ed8\u5931\u8d25");
        }
    }

    public PayBill queryOrder(String outTradeNo, String dealTradeNo) {
        return null;
    }

    public BaseResponse<String> refundOrder(RequestRefundOrderVo requestRefundOrderVo) {
        try {
            String refundNo = UniqueKeyGenerator.generateViewId();
            PayBill payBill = this.payBillService.getByDealTradeNo(requestRefundOrderVo.getDealTradeNo());
            WxPayRefundRequest wxPayRefundRequest = new WxPayRefundRequest();
            wxPayRefundRequest.setOutTradeNo(requestRefundOrderVo.getDealTradeNo());
            wxPayRefundRequest.setOutRefundNo(refundNo);
            wxPayRefundRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)requestRefundOrderVo.getTotalAmount().toString()));
            wxPayRefundRequest.setRefundFee(BaseWxPayRequest.yuanToFen((String)requestRefundOrderVo.getRefundAmount().toString()));
            wxPayRefundRequest.setNotifyUrl(this.refundNotifyUrl);
            MchChan mchChan = this.mchChanService.getMchChanByMchCodeAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
            this.wxPayService.getConfig().setSslContext(null);
            this.wxPayService.getConfig().setAppId(wxPayParam.getAppId());
            this.wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
            this.wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            this.wxPayService.getConfig().setKeyPath(wxPayParam.getKeyPath());
            this.wxPayService.getConfig().setTradeType(payBill.getTradeType());
            log.info(this.wxPayService.getConfig().toString());
            WxPayRefundResult wxPayRefundResult = this.wxPayService.refund(wxPayRefundRequest);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND);
            if (wxPayRefundResult.getReturnCode().equals(RETURN_CODE)) {
                PayBill refundBill = payBill;
                refundBill.setOutRefundNo(refundNo);
                refundBill.setStatus(OrderStatusEnum.REFUNDING.getValue());
                refundBill.setRefundAmount(requestRefundOrderVo.getRefundAmount());
                this.payBillService.update(refundBill);
                return BaseResponse.success((Object)"\u7533\u8bf7\u9000\u6b3e\u6210\u529f");
            }
            log.info("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25:", (Object)wxPayRefundResult.getErrCodeDes());
            return BaseResponse.error((String)"\u7533\u8bf7\u9000\u6b3e\u5931\u8d25");
        }
        catch (WxPayException e) {
            log.error("\u5fae\u4fe1\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff1a", (Object)e.getCustomErrorMsg());
            e.printStackTrace();
            return BaseResponse.error((String)"\u7533\u8bf7\u9000\u6b3e\u5931\u8d25");
        }
    }

    public ResponseQueryRefundOrderVo queryRefundOrder(RequestQueryRefundOrderVo requestQueryRefundOrderVo) {
        return null;
    }

    public ResponseCloseOrderVo closeOrder(RequestCloseOrderVo requestCloseOrderVo) {
        return null;
    }

    public BaseResponse downLoadBill(RequestDownloadVo requestDownloadVo) {
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId(requestDownloadVo.getMchCode(), requestDownloadVo.getPayChannel());
        this.wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        this.wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        this.wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        WxPayDownloadBillRequest request = new WxPayDownloadBillRequest();
        request.setBillDate(requestDownloadVo.getBillDate());
        request.setBillType(BILL_TYPE);
        WxPayBillResult wxPayBillResult = null;
        try {
            wxPayBillResult = this.wxPayService.downloadBill(request);
        }
        catch (WxPayException e) {
            log.error("\u4e0b\u8f7d\u5fae\u4fe1\u4ed8\u8d26\u5355\u5931\u8d25", (Object)e.getErrCodeDes());
            e.printStackTrace();
        }
        return BaseResponse.success((Object)wxPayBillResult);
    }
}

