/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.utils.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import com.ebaiyihui.aggregation.payment.server.config.OssConfig;
import com.ebaiyihui.aggregation.payment.server.utils.UUIDUtil;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.aggregation.payment.server.utils.oss.OssClientFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class OssManageUtil {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static SimpleDateFormat code_time = new SimpleDateFormat("yyyy/MM/dd");
    public static final String JPG_IMAGE = "jpg";
    public static final String PNG_IMAGE = "png";
    public static final String GIF_IMAGE = "gif";
    public static final String JPEG_IMAGE = "jpeg";
    private static List<String> images = null;
    private static List<String> videos = null;

    private static String contentType(String FilenameExtension) {
        if (FilenameExtension.equals("zip") || FilenameExtension.equals("ZIP")) {
            return "application/zip";
        }
        if (FilenameExtension.equals("rar") || FilenameExtension.equals("RAR")) {
            return "application/rar";
        }
        if (FilenameExtension.equals("dcm") || FilenameExtension.equals("DCM")) {
            return "x-lml/x-evm";
        }
        if (FilenameExtension.equals("BMP") || FilenameExtension.equals("bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equals("GIF") || FilenameExtension.equals("gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equals("JPEG") || FilenameExtension.equals("jpeg") || FilenameExtension.equals("JPG") || FilenameExtension.equals("jpg") || FilenameExtension.equals("PNG") || FilenameExtension.equals("png")) {
            return "image/jpeg";
        }
        if (FilenameExtension.equals("HTML") || FilenameExtension.equals("html")) {
            return "text/html";
        }
        if (FilenameExtension.equals("TXT") || FilenameExtension.equals("txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equals("VSD") || FilenameExtension.equals("vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equals("PPTX") || FilenameExtension.equals("pptx") || FilenameExtension.equals("PPT") || FilenameExtension.equals("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equals("DOCX") || FilenameExtension.equals("docx") || FilenameExtension.equals("DOC") || FilenameExtension.equals("doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equals("XLS") || FilenameExtension.equals("xls") || FilenameExtension.equals("XLSX") || FilenameExtension.equals("xlsx")) {
            return "application/vnd.ms-excel";
        }
        if (FilenameExtension.equals("PPT") || FilenameExtension.equals("ppt") || FilenameExtension.equals("PPTX") || FilenameExtension.equals("pptx")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equals("XML") || FilenameExtension.equals("xml")) {
            return "text/xml";
        }
        if (FilenameExtension.equals("mp3") || FilenameExtension.equals("MP3")) {
            return "audio/x-mpeg";
        }
        if (FilenameExtension.equals("amr") || FilenameExtension.equals("AMR")) {
            return "audio/amr";
        }
        return "text/html";
    }

    public static String GetMediaFileExtensionByMimeType(String mimeType) {
        if (mimeType.equals("audio/amr")) {
            return ".amr";
        }
        if (mimeType.equals("audio/x-mpeg")) {
            return ".mp3";
        }
        if (mimeType.equals("image/jpg")) {
            return ".jpg";
        }
        if (mimeType.equals("image/jpeg")) {
            return ".jpeg";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> uploadFile(String fileDir, MultipartFile multipartFile) {
        OSSClient ossClient = OssClientFactory.createOSSClient();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ByteArrayInputStream in = null;
        try {
            InputStream inputStream = multipartFile.getInputStream();
            boolean fileDirExit = ossClient.doesObjectExist(OssConfig.BUCKETNAME, fileDir);
            if (!fileDirExit) {
                ObjectMetadata objectMetadata = new ObjectMetadata();
                byte[] buffer = new byte[]{};
                in = new ByteArrayInputStream(buffer);
                objectMetadata.setContentLength(0L);
                ossClient.putObject(OssConfig.BUCKETNAME, fileDir, (InputStream)in, objectMetadata);
            }
            String prefix = multipartFile.getOriginalFilename().substring(multipartFile.getOriginalFilename().lastIndexOf(".") + 1);
            String fileUuid = UUIDUtil.getUUID();
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType("image/jpeg");
            meta.setCacheControl("max-age=8640000");
            meta.setContentLength(multipartFile.getSize());
            long currentTime = System.currentTimeMillis();
            ossClient.putObject(OssConfig.BUCKETNAME, fileDir + "/" + currentTime + "_" + fileUuid + "." + prefix, inputStream, meta);
            String returl = OssConfig.ACCESS_URL + "/" + fileDir + "/" + currentTime + "_" + fileUuid + "." + prefix;
            map.put("urlpath", returl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ossClient.shutdown();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> uploadInpustream(String fileDir, InputStream inputStream, String prefix) {
        File file;
        ByteArrayInputStream in;
        HashMap<String, Object> map;
        OSSClient ossClient;
        block13: {
            ossClient = OssClientFactory.createOSSClient();
            map = new HashMap<String, Object>();
            in = null;
            file = null;
            try {
                String path = "/tmp/";
                String fileName = UniqueKeyGenerator.generateViewId();
                String imageName = fileName + "doctor_." + prefix;
                file = new File(path + imageName);
                OssManageUtil.inputstreamtofile((InputStream)inputStream, (File)file);
                boolean fileDirExit = ossClient.doesObjectExist(OssConfig.BUCKETNAME, fileDir);
                if (!fileDirExit) {
                    ObjectMetadata objectMetadata = new ObjectMetadata();
                    byte[] buffer = new byte[]{};
                    in = new ByteArrayInputStream(buffer);
                    objectMetadata.setContentLength(0L);
                    ossClient.putObject(OssConfig.BUCKETNAME, fileDir, (InputStream)in, objectMetadata);
                }
                String fileUuid = UUIDUtil.getUUID();
                ObjectMetadata meta = new ObjectMetadata();
                meta.setContentType("image/jpeg");
                meta.setCacheControl("max-age=8640000");
                meta.setContentLength(file.length());
                long currentTime = System.currentTimeMillis();
                ossClient.putObject(OssConfig.BUCKETNAME, fileDir + "/" + currentTime + "_" + fileUuid + "." + prefix, inputStream, meta);
                String returl = OssConfig.ACCESS_URL + "/" + fileDir + "/" + currentTime + "_" + fileUuid + "." + prefix;
                map.put("urlpath", returl);
                if (in == null) break block13;
            }
            catch (Exception e) {
                e.printStackTrace();
                return map;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ossClient.shutdown();
        }
        FileUtils.deleteQuietly((File)file);
        return map;
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ossClient.shutdown();
            }
            FileUtils.deleteQuietly(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadPartETag(String fileDir, CommonsMultipartFile commonsMultipartFile) {
        CompleteMultipartUploadResult completeMultipartUploadResult = null;
        String location = "";
        OSSClient ossClient = OssClientFactory.createOSSClient();
        InputStream in = null;
        String prefix = commonsMultipartFile.getOriginalFilename().substring(commonsMultipartFile.getOriginalFilename().lastIndexOf(".") + 1);
        long currentTime = System.currentTimeMillis();
        String fileUuid = UUIDUtil.getUUID();
        String fileName = fileDir + "/" + currentTime + "_" + fileUuid + "." + prefix;
        try {
            in = commonsMultipartFile.getInputStream();
            completeMultipartUploadResult = OssManageUtil.patchUpload((OSSClient)ossClient, (String)fileDir, (String)fileName, (MultipartFile)commonsMultipartFile, (InputStream)in);
            location = completeMultipartUploadResult.getLocation();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ossClient.shutdown();
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> uploadArchive(String fileDir, MultipartFile multipartFile) {
        HashMap<String, Object> ret_map = new HashMap<String, Object>();
        OSSClient ossClient = OssClientFactory.createOSSClient();
        InputStream in = null;
        String fileName = UniqueKeyGenerator.generateViewId() + "_" + multipartFile.getOriginalFilename();
        try {
            ObjectMetadata objectMeta = new ObjectMetadata();
            objectMeta.setContentLength(multipartFile.getSize());
            fileName = URLDecoder.decode(fileName, "UTF-8");
            ret_map.put("filename", fileName);
            String prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
            String content_type = OssManageUtil.contentType((String)prefix);
            objectMeta.setContentType(content_type);
            CompleteMultipartUploadResult completeMultipartUploadResult = OssManageUtil.patchUpload((OSSClient)ossClient, (String)fileDir, (String)fileName, (MultipartFile)multipartFile, (InputStream)in);
            ret_map.put("urlpath", completeMultipartUploadResult.getLocation());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ossClient.shutdown();
        }
        return ret_map;
    }

    public static ByteArrayInputStream parseStream(OutputStream out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos = (ByteArrayOutputStream)out;
        ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
        return swapStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inputstreamtofile(InputStream ins, File file) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (ins != null) {
                    ins.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] bufferByte(Long size) {
        byte[] bytes = null;
        bytes = size.compareTo(new Long(0x40000000L)) >= 0 && size.compareTo(new Long(0x80000000L)) < 0 ? new byte[1024000] : (size.compareTo(new Long(524288000L)) >= 0 && size.compareTo(new Long(0x40000000L)) < 0 ? new byte[102400] : (size.compareTo(new Long(0x6400000L)) >= 0 && size.compareTo(new Long(524288000L)) < 0 ? new byte[10240] : new byte[2048]));
        return bytes;
    }

    public static CompleteMultipartUploadResult patchUpload(OSSClient ossClient, String fileDir, String fileName, MultipartFile commonsMultipartFile, InputStream in) {
        CompleteMultipartUploadResult completeMultipartUploadResult = null;
        try {
            boolean fileDirExit = ossClient.doesObjectExist(OssConfig.BUCKETNAME, fileDir);
            if (!fileDirExit) {
                ObjectMetadata objectMetadata = new ObjectMetadata();
                byte[] buffer = new byte[]{};
                in = new ByteArrayInputStream(buffer);
                objectMetadata.setContentLength(0L);
                ossClient.putObject(OssConfig.BUCKETNAME, fileDir, in, objectMetadata);
            }
            InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(OssConfig.BUCKETNAME, fileName);
            InitiateMultipartUploadResult result = ossClient.initiateMultipartUpload(initiateMultipartUploadRequest);
            String uploadId = result.getUploadId();
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            long partSize = 0x200000L;
            long fileLength = commonsMultipartFile.getSize();
            int partCount = (int)(fileLength / 0x200000L);
            if (fileLength % 0x200000L != 0L) {
                ++partCount;
            }
            for (int i = 0; i < partCount; ++i) {
                long startPos = (long)i * 0x200000L;
                long curPartSize = i + 1 == partCount ? fileLength - startPos : 0x200000L;
                InputStream instream = commonsMultipartFile.getInputStream();
                instream.skip(startPos);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(OssConfig.BUCKETNAME);
                uploadPartRequest.setKey(fileName);
                uploadPartRequest.setUploadId(uploadId);
                uploadPartRequest.setInputStream(instream);
                uploadPartRequest.setPartSize(curPartSize);
                uploadPartRequest.setPartNumber(i + 1);
                UploadPartResult uploadPartResult = ossClient.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResult.getPartETag());
            }
            Collections.sort(partETags, new /* Unavailable Anonymous Inner Class!! */);
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(OssConfig.BUCKETNAME, fileName, uploadId, partETags);
            completeMultipartUploadResult = ossClient.completeMultipartUpload(completeMultipartUploadRequest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return completeMultipartUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadImageToOSS(String fileDir, MultipartFile multipartFile, InputStream inputStream) {
        OSSClient ossClient = OssClientFactory.createOSSClient();
        Long currentTime = System.currentTimeMillis();
        ByteArrayInputStream in = null;
        String returl = "";
        boolean fileDirExit = ossClient.doesObjectExist(OssConfig.BUCKETNAME, fileDir);
        if (!fileDirExit) {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            byte[] buffer = new byte[]{};
            in = new ByteArrayInputStream(buffer);
            objectMetadata.setContentLength(0L);
            ossClient.putObject(OssConfig.BUCKETNAME, fileDir, (InputStream)in, objectMetadata);
        }
        String prefix = multipartFile.getOriginalFilename().substring(multipartFile.getOriginalFilename().lastIndexOf(".") + 1);
        try {
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            Date date = new Date();
            SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmm-");
            String imageTime = yyyyMMddHHmmss.format(date);
            ossClient.putObject(new PutObjectRequest(OssConfig.BUCKETNAME, fileDir + "/" + currentTime + "_" + uuid + "." + prefix, inputStream));
            returl = OssConfig.ACCESS_URL + "/" + fileDir + "/" + currentTime + "_" + uuid + "." + prefix;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        finally {
            ossClient.shutdown();
        }
        return returl;
    }

    static {
        images = new ArrayList();
        images.add("jpg");
        images.add("png");
        images.add("gif");
        images.add("JPG");
        images.add("PNG");
        images.add("GIF");
        videos = new ArrayList();
        videos.add("mp4");
        videos.add("mov");
        videos.add("avi");
        videos.add("wmv");
    }
}

