/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.aspect;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    public static final String REQUEST_HEADER = "x-forwarded-for";
    private static List<String> SIGN_URLS = Lists.newArrayList((Object[])new String[]{"create-order", "refund", "entPay", "transferBillQuery"});
    @Autowired
    private PayApplyService payApplyService;

    @Pointcut(value="execution(public * com.ebaiyihui.aggregation.payment.server.controller.ErrorBillController.*(..))")
    public void logAspect() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Around(value="logAspect()")
    public Object deAround(ProceedingJoinPoint pjp) throws Throwable {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String ipaddress = request.getHeader("x-forwarded-for") == null ? request.getRemoteAddr() : request.getHeader("x-forwarded-for");
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String queryString = request.getQueryString();
        Object[] args = pjp.getArgs();
        String params = "";
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof ServletRequest || args[i] instanceof ServletResponse || args[i] instanceof MultipartFile) continue;
                if ("POST".equals(method)) {
                    Object object = args[i];
                    Map map = LogAspect.getKeyAndValue((Object)object);
                    params = JSON.toJSONString((Object)map);
                    if (!LogAspect.checkUrl((String)url)) continue;
                    log.info("\u8bf7\u6c42\u5165\u53c2:{}", (Object)map);
                    String applyCode = (String)map.get("mchCode");
                    PayApply payApply = this.payApplyService.getByApplyCode(applyCode);
                    log.info("\u8bf7\u6c42\u5e94\u7528\u4fe1\u606f:{}", (Object)payApply);
                    if (null == payApply) {
                        log.info("\u652f\u4ed8\u53c2\u6570\u9519\u8bef\uff1a{}", map.get("applyCode"));
                        return BaseResponse.error((String)"\u5e94\u7528\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u540e\u8bf7\u6c42");
                    }
                    if (null == payApply.getIpList()) {
                        log.info("\u5e94\u7528{}ip\u767d\u540d\u5355\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8bbe\u7f6e\u540e\u91cd\u8bd5", map.get("mchCode"));
                        return BaseResponse.error((String)"ip\u767d\u540d\u5355\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8bbe\u7f6e\u540e\u91cd\u8bd5");
                    }
                    if ("*".equals(payApply.getIpList())) {
                        log.info("\u5e94\u7528{}ip\u767d\u540d\u5355\u5168\u5f00", map.get("mchCode"));
                    } else {
                        ArrayList ipList = Lists.newArrayList((Object[])payApply.getIpList().split(","));
                        if (!ipList.contains(ipaddress)) {
                            log.info("{}\u672a\u5728ip\u767d\u540d\u5355\u5185", (Object)ipaddress);
                            return BaseResponse.error((String)(ipaddress + "\u65e0\u6743\u9650\u8bbf\u95ee\u63a5\u53e3"));
                        }
                        log.info("\u767d\u540d\u5355\u5185ip");
                    }
                    boolean checkSign = SignUtil.checkSign((Map)map, (String)payApply.getApplyKey());
                    if (checkSign) continue;
                    log.info("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25!");
                    return BaseResponse.success((Object)"\u7b7e\u540d\u9519\u8bef\u8bf7\u68c0\u67e5\u652f\u4ed8\u53c2\u6570");
                }
                if (!"GET".equals(method)) continue;
                params = queryString;
            }
        }
        log.info("\u8bf7\u6c42\u5730\u5740:{},\u8bf7\u6c42ip:{}", (Object)url, (Object)ipaddress);
        log.info("\u8bf7\u6c42\u7c7b\u578b:{},\u8bf7\u6c42\u53c2\u6570:{}", (Object)method, (Object)params);
        return pjp.proceed();
    }

    public static Map<String, String> getKeyAndValue(Object obj) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        Class<?> userCla = obj.getClass();
        Field[] fs = userCla.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            Field f = fs[i];
            f.setAccessible(true);
            try {
                Object val = f.get(obj);
                if (null == f.get(obj) || "".equals(f.get(obj).toString().trim())) continue;
                map.put(f.getName(), val.toString());
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static boolean checkUrl(String url) {
        String a1 = url.substring(url.lastIndexOf("/") + 1);
        return SIGN_URLS.contains(a1);
    }
}

