/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.config;

import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.ProfitSharingService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.ProfitSharingServiceImpl;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS, value="prototype")
public class WxPayConfiguration {
    @Value(value="${wx.pay.payNotifyUrl}")
    private String payNotifyUrl;

    public WxPayService wxService(WxPayParam wxPayParam) {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(wxPayParam.getAppId());
        payConfig.setMchId(wxPayParam.getMchAccount());
        payConfig.setMchKey(wxPayParam.getMchPublicKey());
        payConfig.setKeyPath(wxPayParam.getKeyPath());
        if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
            payConfig.setSubMchId(wxPayParam.getSubMchId());
        } else {
            payConfig.setSubMchId(null);
        }
        payConfig.setNotifyUrl(StringUtils.trimToNull((String)this.payNotifyUrl));
        payConfig.setSignType(StringUtils.trimToNull((String)"MD5"));
        payConfig.setPayBaseUrl("https://api.mch.weixin.qq.com");
        payConfig.setUseSandboxEnv(false);
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        return wxPayService;
    }

    public ProfitSharingService profitSharingService(WxPayParam wxPayParam) {
        ProfitSharingServiceImpl profitSharingService = new ProfitSharingServiceImpl(this.wxService(wxPayParam));
        return profitSharingService;
    }
}

