/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.mybank.business;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.AdditionRecord;
import com.ebaiyihui.aggregation.payment.common.model.PayIsvThird;
import com.ebaiyihui.aggregation.payment.common.model.PayMchThird;
import com.ebaiyihui.aggregation.payment.common.model.SharingRecord;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.enums.ThirdMchEnum;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.ProfitSharingReqVO;
import com.ebaiyihui.aggregation.payment.server.mapper.AdditionRecordMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.MchChanMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayIsvThirdMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchThirdMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.SharingRecordMapper;
import com.ebaiyihui.aggregation.payment.server.mybank.DefaultMybankClient;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankClient;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankRequest;
import com.ebaiyihui.aggregation.payment.server.mybank.bo.FundDetailBO;
import com.ebaiyihui.aggregation.payment.server.mybank.bo.MyBankSharingBO;
import com.ebaiyihui.aggregation.payment.server.mybank.bo.SharingProcessBO;
import com.ebaiyihui.aggregation.payment.server.mybank.config.MybankConfig;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.RequestBody;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.RespInfo;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.ordershare.BkcloudfundsOrderShareRequestModel;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.ordershare.BkcloudfundsOrderShareResponseModel;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.ordershare.refund.BkcloudfundsRefundShareApplyRequestModel;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.ordershare.refund.BkcloudfundsRefundShareApplyResponseModel;
import com.ebaiyihui.aggregation.payment.server.mybank.enums.PurposeEnum;
import com.ebaiyihui.aggregation.payment.server.mybank.enums.ShareStatusEnum;
import com.ebaiyihui.aggregation.payment.server.mybank.request.ordershare.BkcloudfundsOrderShareRequest;
import com.ebaiyihui.aggregation.payment.server.mybank.request.ordershare.refund.BkcloudfundsRefundShareApplyRequest;
import com.ebaiyihui.aggregation.payment.server.mybank.response.ordershare.BkcloudfundsOrderShareResponse;
import com.ebaiyihui.aggregation.payment.server.mybank.response.ordershare.refund.BkcloudfundsRefundShareApplyResponse;
import com.ebaiyihui.aggregation.payment.server.profitSharing.IProfitSharing;
import com.ebaiyihui.aggregation.payment.server.profitSharing.ProfitSharingVO;
import com.ebaiyihui.aggregation.payment.server.utils.Base64Util;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="MybankProfitSharing")
public class MybankProfitSharing
implements IProfitSharing {
    private static final Logger log = LoggerFactory.getLogger(MybankProfitSharing.class);
    @Resource
    private PayMchThirdMapper payMchThirdMapper;
    @Resource
    private SharingRecordMapper sharingRecordMapper;
    @Resource
    private AdditionRecordMapper additionRecordMapper;
    @Resource
    private PayIsvThirdMapper payIsvThirdMapper;
    @Resource
    private MchChanMapper mchChanMapper;
    @Resource
    private RedisTemplate redisTemplate;
    private final String REFUND_REASON = "\u7528\u6237\u9000\u8d27";

    public BaseResponse profitSharing(ProfitSharingReqVO profitSharingReqVO, String applyCode) {
        HashMap<String, String> result = new HashMap<String, String>();
        String sharingNotifyUrl = profitSharingReqVO.getSharingNotifyUrl();
        String payNum = this.mchChanMapper.selectNum(applyCode);
        List myBankSharingBOList = this.getSharing(profitSharingReqVO);
        String outTradeNo = profitSharingReqVO.getOutTradeNo();
        this.saveSharingRecord(myBankSharingBOList, sharingNotifyUrl);
        for (MyBankSharingBO myBankSharingBO : myBankSharingBOList) {
            SharingProcessBO sharingProcessBO = new SharingProcessBO();
            sharingProcessBO.setOutTradeNo(outTradeNo);
            sharingProcessBO.setPayNum(payNum);
            sharingProcessBO.setMyBankSharingBO(myBankSharingBO);
            boolean b = this.chooseSyncRequest(sharingProcessBO);
            String shareTradeNo = myBankSharingBO.getShareTradeNo();
            if (b) {
                result.put(shareTradeNo, "PROCESSING");
                continue;
            }
            result.put(shareTradeNo, "FAIL");
        }
        return BaseResponse.success(result);
    }

    private boolean chooseSyncRequest(SharingProcessBO sharingProcessBO) {
        boolean flag = true;
        String outTradeNo = sharingProcessBO.getOutTradeNo();
        String shareTradeNo = sharingProcessBO.getMyBankSharingBO().getShareTradeNo();
        String value = JSONObject.toJSONString((Object)sharingProcessBO);
        log.info("sharing mybank sharingProcessBO:{}", (Object)value);
        Boolean hasKey = this.redisTemplate.hasKey((Object)outTradeNo);
        this.redisTemplate.opsForHash().put((Object)outTradeNo, (Object)shareTradeNo, (Object)value);
        if (hasKey.booleanValue()) {
            log.info("have sharing record processing,outTradeNo:{},shareTradeNo:{}", (Object)outTradeNo, (Object)shareTradeNo);
        } else {
            try {
                flag = this.sendRequestForSharing(sharingProcessBO.getPayNum(), sharingProcessBO.getMyBankSharingBO());
            }
            catch (Exception e) {
                log.error("request mybank sharing error,e=", (Throwable)e);
                this.redisTemplate.opsForHash().delete((Object)outTradeNo, new Object[]{shareTradeNo});
                flag = false;
            }
        }
        return flag;
    }

    public boolean sendRequestForSharing(String payNum, MyBankSharingBO myBankSharingBO) throws Exception {
        boolean flag = true;
        BkcloudfundsOrderShareRequest orderShareRequest = this.getBkcloudfundsOrderShareRequest(myBankSharingBO, payNum);
        log.info("mybank sharing req param:{}", (Object)JSONObject.toJSONString((Object)orderShareRequest));
        BkcloudfundsOrderShareResponse orderShareResponse = (BkcloudfundsOrderShareResponse)myBankSharingBO.getMybankClient().execute((MybankRequest)orderShareRequest);
        BkcloudfundsOrderShareResponseModel orderShareResponseModel = orderShareResponse.getBkcloudfundsOrderShare().getBkcloudfundsOrderShareResponseModel();
        String requestContent = orderShareResponse.getRequestContent();
        log.info("mybank sharing req content:{}", (Object)requestContent);
        String xmlContent = orderShareResponse.getXmlContent();
        log.info("mybank sharing res content:{}", (Object)xmlContent);
        RespInfo respInfo = orderShareResponseModel.getRespInfo();
        if (!"S".equals(respInfo.getResultStatus())) {
            flag = false;
        }
        this.updateSharingRecord(myBankSharingBO.getOutTradeNo(), orderShareResponseModel, flag);
        return flag;
    }

    @NotNull
    private List<MyBankSharingBO> getSharing(ProfitSharingReqVO profitSharingReqVO) {
        List profitSharingVOList = profitSharingReqVO.getProfitSharingVOList();
        List thirdMchCodeList = profitSharingVOList.stream().map(ProfitSharingVO::getMchCode).collect(Collectors.toList());
        List payMchThirds = this.payMchThirdMapper.selectListByCodes(thirdMchCodeList);
        PayIsvThird payIsvThird = this.payIsvThirdMapper.selectOneById(((PayMchThird)payMchThirds.get(0)).getIsvId());
        DefaultMybankClient mybankClient = new DefaultMybankClient(MybankConfig.serverUrl, payIsvThird.getPrivateKey(), payIsvThird.getPublicKey());
        AdditionRecord additionRecord = this.additionRecordMapper.selectOneByOutTradeNoOrTradeNo(profitSharingReqVO.getOutTradeNo());
        String tradeNo = additionRecord.getTradeNo();
        return this.getSharingCollect(profitSharingVOList, payMchThirds, payIsvThird, (MybankClient)mybankClient, tradeNo, profitSharingReqVO.getOutTradeNo());
    }

    @NotNull
    private List<MyBankSharingBO> getSharingCollect(List<ProfitSharingVO> profitSharingVOList, List<PayMchThird> payMchThirds, PayIsvThird payIsvThird, MybankClient mybankClient, String tradeNo, String outTradeNo) {
        return profitSharingVOList.stream().flatMap(x -> payMchThirds.stream().filter(y -> x.getMchCode().equals(y.getMchNum())).map(y -> new MyBankSharingBO(x.getMchCode(), x.getAmount(), x.getPurpose(), outTradeNo, tradeNo, x.getOutSharingNo(), "", y, mybankClient, payIsvThird))).collect(Collectors.toList());
    }

    public BaseResponse refundShare(RequestRefundOrderVo requestRefundOrderVo, String applyCode) {
        try {
            String payNum = this.mchChanMapper.selectNum(applyCode);
            List myBankSharingBOList = this.getRefundSharing(requestRefundOrderVo);
            for (MyBankSharingBO myBankSharingBO : myBankSharingBOList) {
                BkcloudfundsRefundShareApplyRequest refundShareApplyRequest = this.getBkcloudfundsRefundShareApplyRequest(myBankSharingBO, payNum);
                log.info("mybank sharing refund req param:{}", (Object)JSONObject.toJSONString((Object)refundShareApplyRequest));
                BkcloudfundsRefundShareApplyResponse refundShareApplyResponse = (BkcloudfundsRefundShareApplyResponse)myBankSharingBO.getMybankClient().execute((MybankRequest)refundShareApplyRequest);
                BkcloudfundsRefundShareApplyResponseModel refundShareApplyResponseModel = refundShareApplyResponse.getBkcloudfundsRefundShareApply().getBkcloudfundsRefundShareApplyResponseModel();
                String requestContent = refundShareApplyResponse.getRequestContent();
                log.info("mybank sharing refund req content:{}", (Object)requestContent);
                String xmlContent = refundShareApplyResponse.getXmlContent();
                log.info("mybank sharing refund res content:{}", (Object)xmlContent);
                this.saveRefundRecord(myBankSharingBO, refundShareApplyResponseModel);
            }
        }
        catch (Exception e) {
            log.error("mybank sharing refund error,e=", (Throwable)e);
            return BaseResponse.error((String)"mybank sharing refund error !");
        }
        return BaseResponse.success();
    }

    private void saveRefundRecord(MyBankSharingBO myBankSharingBO, BkcloudfundsRefundShareApplyResponseModel refundShareApplyResponseModel) {
        RespInfo respInfo = refundShareApplyResponseModel.getRespInfo();
        SharingRecord sharingRecord = new SharingRecord();
        if ("S".equals(respInfo.getResultStatus())) {
            sharingRecord.setShareStatus(ShareStatusEnum.REFUND_FINISHED.getValue());
        } else {
            sharingRecord.setShareStatus(ShareStatusEnum.REFUND_ERROR.getValue());
        }
        sharingRecord.setRefundOutTradeNo(myBankSharingBO.getRefundTradeNo());
        SharingRecord update = new SharingRecord();
        update.setShareTradeNo(myBankSharingBO.getShareTradeNo());
        QueryWrapper queryWrapper = new QueryWrapper((Object)update);
        this.sharingRecordMapper.update((Object)sharingRecord, (Wrapper)queryWrapper);
    }

    @NotNull
    private List<MyBankSharingBO> getRefundSharing(RequestRefundOrderVo requestRefundOrderVo) {
        String outTradeNo = requestRefundOrderVo.getOutTradeNo();
        List sharingRecords = this.sharingRecordMapper.selectListByOutTradeNo(outTradeNo);
        List thirdMchCodeList = sharingRecords.stream().map(SharingRecord::getMchCode).collect(Collectors.toList());
        List payMchThirds = this.payMchThirdMapper.selectListByCodes(thirdMchCodeList);
        PayIsvThird payIsvThird = this.payIsvThirdMapper.selectOneById(((PayMchThird)payMchThirds.get(0)).getIsvId());
        DefaultMybankClient mybankClient = new DefaultMybankClient(MybankConfig.serverUrl, payIsvThird.getPrivateKey(), payIsvThird.getPublicKey());
        return this.getRefundCollect(sharingRecords, payMchThirds, payIsvThird, (MybankClient)mybankClient);
    }

    @NotNull
    private List<MyBankSharingBO> getRefundCollect(List<SharingRecord> sharingRecords, List<PayMchThird> payMchThirds, PayIsvThird payIsvThird, MybankClient mybankClient) {
        return sharingRecords.stream().flatMap(x -> payMchThirds.stream().filter(y -> x.getMchCode().equals(y.getMchNum())).map(y -> new MyBankSharingBO(x.getMchCode(), x.getAmount(), PurposeEnum.ADVANCE_FUND.toString(), x.getOutTradeNo(), x.getTradeNo(), x.getShareTradeNo(), UUID.randomUUID().toString().replace("-", ""), y, mybankClient, payIsvThird))).collect(Collectors.toList());
    }

    @NotNull
    private BkcloudfundsRefundShareApplyRequest getBkcloudfundsRefundShareApplyRequest(MyBankSharingBO myBankSharingBO, String payNum) {
        PayIsvThird payIsvThird = myBankSharingBO.getPayIsvThird();
        PayMchThird payMchThird = myBankSharingBO.getPayMchThird();
        String amount = myBankSharingBO.getAmount().multiply(new BigDecimal("100")).intValue() + "";
        BkcloudfundsRefundShareApplyRequest refundShareApplyRequest = new BkcloudfundsRefundShareApplyRequest(payIsvThird.getAppId());
        BkcloudfundsRefundShareApplyRequestModel refundShareApplyRequestModel = new BkcloudfundsRefundShareApplyRequestModel();
        refundShareApplyRequestModel.setIsvOrgId(payIsvThird.getIsvOrgId());
        String mchNum = payMchThird.getMchNum();
        refundShareApplyRequestModel.setMerchantId(payNum);
        refundShareApplyRequestModel.setRelateOrderNo(myBankSharingBO.getTradeNo());
        refundShareApplyRequestModel.setOutTradeNo(myBankSharingBO.getRefundTradeNo());
        refundShareApplyRequestModel.setTotalAmount(amount);
        refundShareApplyRequestModel.setCurrency("CNY");
        refundShareApplyRequestModel.setPayeeFundDetails("");
        refundShareApplyRequestModel.setReason("\u7528\u6237\u9000\u8d27");
        if (!mchNum.equals(payNum)) {
            FundDetailBO fundDetailBO = new FundDetailBO();
            this.getFundDetailBO(payIsvThird, myBankSharingBO, payMchThird, amount, fundDetailBO);
            refundShareApplyRequestModel.setPayerFundDetails(this.getFundDetails(fundDetailBO));
        }
        refundShareApplyRequest.setRequestBody((RequestBody)refundShareApplyRequestModel);
        return refundShareApplyRequest;
    }

    private void getFundDetailBO(PayIsvThird payIsvThird, MyBankSharingBO myBankSharingBO, PayMchThird payMchThird, String amount, FundDetailBO fundDetailBO) {
        String participantId = payMchThird.getMchNum();
        String participantType = ThirdMchEnum.MERCHANT.toString();
        String thirdMchType = ThirdMchEnum.PLATFORM.toString();
        if (thirdMchType.equals(payMchThird.getThirdType())) {
            participantId = payIsvThird.getIsvOrgId();
            participantType = thirdMchType;
        }
        fundDetailBO.setAmount(amount);
        fundDetailBO.setCurrency("CNY");
        fundDetailBO.setParticipantId(participantId);
        fundDetailBO.setParticipantType(participantType);
        fundDetailBO.setPurpose(myBankSharingBO.getPurpose());
    }

    private void updateSharingRecord(String outTradeNo, BkcloudfundsOrderShareResponseModel orderShareResponseModel, boolean flag) {
        SharingRecord sharingRecord = new SharingRecord();
        String shareTradeNo = orderShareResponseModel.getOutTradeNo();
        sharingRecord.setShareTradeNo(shareTradeNo);
        RespInfo respInfo = orderShareResponseModel.getRespInfo();
        if (flag) {
            sharingRecord.setShareStatus(ShareStatusEnum.SHARING.getValue());
            sharingRecord.setThirdShareTradeNo(orderShareResponseModel.getShareOrderNo());
        } else {
            sharingRecord.setShareStatus(ShareStatusEnum.SHARING_ERROR.getValue());
            sharingRecord.setFailReason(respInfo.getResultMsg());
            sharingRecord.setExecution(Integer.valueOf(1));
            this.redisTemplate.opsForHash().delete((Object)outTradeNo, new Object[]{shareTradeNo});
        }
        SharingRecord updateSharingRecord = new SharingRecord();
        updateSharingRecord.setShareTradeNo(sharingRecord.getShareTradeNo());
        QueryWrapper queryWrapper = new QueryWrapper((Object)updateSharingRecord);
        this.sharingRecordMapper.update((Object)sharingRecord, (Wrapper)queryWrapper);
    }

    @NotNull
    private BkcloudfundsOrderShareRequest getBkcloudfundsOrderShareRequest(MyBankSharingBO myBankSharingBO, String payNum) {
        PayIsvThird payIsvThird = myBankSharingBO.getPayIsvThird();
        PayMchThird payMchThird = myBankSharingBO.getPayMchThird();
        String amount = myBankSharingBO.getAmount().multiply(new BigDecimal("100")).intValue() + "";
        BkcloudfundsOrderShareRequest orderShareRequest = new BkcloudfundsOrderShareRequest(payIsvThird.getAppId());
        BkcloudfundsOrderShareRequestModel orderShareRequestModel = new BkcloudfundsOrderShareRequestModel();
        orderShareRequestModel.setIsvOrgId(payIsvThird.getIsvOrgId());
        String mchNum = payMchThird.getMchNum();
        orderShareRequestModel.setMerchantId(payNum);
        orderShareRequestModel.setRelateOrderNo(myBankSharingBO.getTradeNo());
        orderShareRequestModel.setOutTradeNo(myBankSharingBO.getShareTradeNo());
        orderShareRequestModel.setTotalAmount(amount);
        orderShareRequestModel.setCurrency("CNY");
        if (!mchNum.equals(payNum)) {
            FundDetailBO fundDetailBO = new FundDetailBO();
            this.getFundDetailBO(payIsvThird, myBankSharingBO, payMchThird, amount, fundDetailBO);
            orderShareRequestModel.setPayeeFundDetails(this.getFundDetails(fundDetailBO));
        }
        orderShareRequest.setRequestBody((RequestBody)orderShareRequestModel);
        return orderShareRequest;
    }

    private String getFundDetails(FundDetailBO fundDetailBO) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fundDetailBO)));
        return Base64Util.encode((String)jsonArray.toString());
    }

    private void saveSharingRecord(List<MyBankSharingBO> myBankSharingBOList, String sharingNotifyUrl) {
        ArrayList<SharingRecord> sharingRecordList = new ArrayList<SharingRecord>();
        for (MyBankSharingBO myBankSharingBO : myBankSharingBOList) {
            SharingRecord sharingRecord = new SharingRecord();
            sharingRecord.setOutTradeNo(myBankSharingBO.getOutTradeNo());
            sharingRecord.setTradeNo(myBankSharingBO.getTradeNo());
            sharingRecord.setShareTradeNo(myBankSharingBO.getShareTradeNo());
            sharingRecord.setAmount(myBankSharingBO.getAmount());
            sharingRecord.setMchCode(myBankSharingBO.getMchCode());
            sharingRecord.setShareType(PayChanEnum.MYBANK.getDisplay());
            sharingRecord.setShareStatus(ShareStatusEnum.SHARE_READY.getValue());
            sharingRecord.setShareDate(DateUtils.getNow());
            sharingRecord.setSharingNotifyUrl(sharingNotifyUrl);
            sharingRecord.setExecution(Integer.valueOf(0));
            sharingRecordList.add(sharingRecord);
        }
        this.sharingRecordMapper.insertList(sharingRecordList);
    }
}

