/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.BaseAliSmsReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.constant.RetryCountConstant;
import com.ebaiyihui.aggregation.payment.server.enums.ContrastEnum;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.OrderRabbitInfo;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.RabbitInfo;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.RabbitProduct;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.SynchroNotifyRabbit;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.NotifyService;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PayMchService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.service.impl.AlipayServiceImpl;
import com.ebaiyihui.aggregation.payment.server.service.impl.ICBCPayServiceImpl;
import com.ebaiyihui.aggregation.payment.server.service.impl.UnionPayServiceImpl;
import com.ebaiyihui.aggregation.payment.server.service.impl.WechatPayServiceImpl;
import com.ebaiyihui.aggregation.payment.server.service.mybank.AddOrderService;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.HttpsClientUtil;
import com.ebaiyihui.aggregation.payment.server.utils.PushInfoUtil;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.icbc.api.response.CardbusinessAggregatepayB2cOnlineRefundqryResponseV1;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
public class RabbitConsumer {
    private static final Logger log = LoggerFactory.getLogger(RabbitConsumer.class);
    public static final String SUCCESS = "SUCCESS";
    public static final String REFUND = "refund";
    public static final String PAY = "pay";
    public static final String NOTPAY = "NOTPAY";
    public static final String USERPAYING = "USERPAYING";
    public static final String PAID_SUCCESS = "SUCCESS";
    public static final String F2F_PAID_ERROR = "PAYERROR";
    public static final String PAID_TRADE_SUCCESS = "TRADE_SUCCESS";
    public static final String WAIT_BUYER_PAY = "WAIT_BUYER_PAY";
    RecordsEnum success;
    RecordsEnum fail;
    String dealTradeNo;
    String serviceCode;
    String outRefundNo;
    @Autowired
    private RabbitProduct rabbitProduct;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private WechatPayServiceImpl wechatPayService;
    @Autowired
    private AlipayServiceImpl alipayService;
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private NotifyService notifyService;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private PushInfoUtil pushInfoUtil;
    @Autowired
    private UnionPayServiceImpl unionPayService;
    @Autowired
    private PayApplyService payApplyService;
    @Resource
    private AddOrderService addOrderService;
    @Resource
    private ICBCPayServiceImpl icbcPayService;
    @Autowired
    protected PayMchService payMchService;

    @RabbitListener(queues={"byh-aggregation-payment-queueA-new"})
    public void listen(@Payload RabbitInfo rabbitInfo, @Headers Map<String, Object> headers, Channel channel, Message message) throws IOException {
        this.notifyServiceOrder(rabbitInfo, headers, channel, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyServiceOrder(@Payload RabbitInfo rabbitInfo, @Headers Map<String, Object> headers, Channel channel, Message message) throws IOException {
        String originalExpiration = "0";
        try {
            BaseResponse baseResponse;
            log.info("rabbit\u5373\u65f6\u961f\u5217\u76d1\u542c\u5230\u6d88\u606f{}", (Object)JSONObject.toJSONString((Object)rabbitInfo));
            List xDeath = (List)headers.get("x-death");
            if (xDeath != null && !xDeath.isEmpty()) {
                Map entrys = (Map)xDeath.get(0);
                originalExpiration = entrys.get("original-expiration").toString();
                log.info("\u4e1a\u52a1\u56de\u8c03\u5f02\u5e38\u91cd\u8bd5\u65f6\u95f4\u4e3a:{}", (Object)originalExpiration);
            }
            String notifyRestVo = rabbitInfo.getNotifyRestVo();
            String type = rabbitInfo.getType();
            if (REFUND.equals(type)) {
                ResponseRefundNotifyRestVo responseRefundNotifyRestVo = (ResponseRefundNotifyRestVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)notifyRestVo), ResponseRefundNotifyRestVo.class);
                this.dealTradeNo = responseRefundNotifyRestVo.getDealTradeNo();
                this.serviceCode = responseRefundNotifyRestVo.getServiceCode();
                this.success = RecordsEnum.REFUND_CALLBACK_SUCCESS;
                this.fail = RecordsEnum.REFUND_CALLBACK_FAIL;
                this.outRefundNo = responseRefundNotifyRestVo.getOutRefundNo();
            } else {
                ResponseNotifyRestVo responseNotifyRestVo = (ResponseNotifyRestVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)notifyRestVo), ResponseNotifyRestVo.class);
                this.dealTradeNo = responseNotifyRestVo.getDealTradeNo();
                this.serviceCode = responseNotifyRestVo.getServiceCode();
                this.success = RecordsEnum.CALLBACK_SUCCESS;
                this.fail = RecordsEnum.CALLBACK_FAIL;
                this.outRefundNo = null;
                this.addOrderService.saveAddOrder(responseNotifyRestVo.getOutTradeNo());
            }
            log.info("\u5f00\u59cb\u8c03\u7528\u4e1a\u52a1\u63a5\u53e3\u505a\u7ed3\u679c\u901a\u77e5,url={},\u8bf7\u6c42\u53c2\u6570{}", (Object)rabbitInfo.getUrl(), (Object)notifyRestVo);
            JSONObject result = HttpsClientUtil.doPostForJson((String)rabbitInfo.getUrl(), (String)notifyRestVo);
            log.info("\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u8fd4\u56de\u7ed3\u679c\uff1aJSONObject{}", (Object)result);
            if (null != result && null != (baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)result, BaseResponse.class)).getData() && "SUCCESS".equals(baseResponse.getData().toString().toUpperCase())) {
                log.info("\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u6210\u529f\uff1a\u5e73\u53f0\u8ba2\u5355\u53f7{},\u4e1a\u52a1\u7f16\u7801{}", (Object)this.dealTradeNo, (Object)this.serviceCode);
                this.paymentRecordsService.saveByRefundBill(this.dealTradeNo, this.serviceCode, this.success, this.outRefundNo);
                return;
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u8fd4\u56de\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f", (Object)e.getMessage(), (Object)e);
        }
        finally {
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
        }
        this.retryNotify(headers, rabbitInfo, originalExpiration);
    }

    public void retryNotify(Map<String, Object> headers, RabbitInfo rabbitInfo, String originalExpiration) {
        try {
            if (originalExpiration.equals(RetryCountConstant.ZERO_TIMES.toString())) {
                log.info("------------\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u7b2c\u4e00\u6b21\u91cd\u8bd5-----------");
                this.rabbitProduct.pushB(rabbitInfo, RetryCountConstant.ONE_TIMES.intValue());
            }
            if (originalExpiration.equals(RetryCountConstant.ONE_TIMES.toString())) {
                log.info("------------\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u7b2c\u4e8c\u6b21\u91cd\u8bd5-----------");
                this.rabbitProduct.pushC(rabbitInfo, RetryCountConstant.TWO_TIMES.intValue());
            }
            if (originalExpiration.equals(RetryCountConstant.TWO_TIMES.toString())) {
                log.info("------------\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u7b2c\u4e09\u6b21\u91cd\u8bd5-----------");
                this.rabbitProduct.pushD(rabbitInfo, RetryCountConstant.THREE_TIMES.intValue());
            }
            if (originalExpiration.equals(RetryCountConstant.THREE_TIMES.toString())) {
                log.info("------------\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u7b2c\u56db\u6b21\u91cd\u8bd5-----------");
                this.rabbitProduct.pushE(rabbitInfo, RetryCountConstant.FOUR_TIMES.intValue());
            }
            if (originalExpiration.equals(RetryCountConstant.FOUR_TIMES.toString())) {
                log.info("------------\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u7b2c\u4e94\u6b21\u91cd\u8bd5-----------");
                this.rabbitProduct.pushF(rabbitInfo, RetryCountConstant.FIVE_TIMES.intValue());
            }
            if (originalExpiration.equals(RetryCountConstant.FIVE_TIMES.toString())) {
                log.info("------------\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u7b2c\u516d\u6b21\u91cd\u8bd5-----------");
                this.rabbitProduct.pushG(rabbitInfo, RetryCountConstant.SIX_TIMES.intValue());
            }
            if (originalExpiration.equals(RetryCountConstant.SIX_TIMES.toString())) {
                log.info("------------\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u7b2c\u4e03\u6b21\u91cd\u8bd5-----------");
                this.rabbitProduct.pushH(rabbitInfo, RetryCountConstant.SEVEN_TIMES.intValue());
            }
            if (originalExpiration.equals(RetryCountConstant.SEVEN_TIMES.toString())) {
                log.info("------------\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u7b2c\u516b\u6b21\u91cd\u8bd5-----------");
                this.rabbitProduct.pushJ(rabbitInfo, RetryCountConstant.EIGHT_TIMES.intValue());
            }
            if (originalExpiration.equals(RetryCountConstant.EIGHT_TIMES.toString())) {
                log.info("------------\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u5931\u8d25\u8bb0\u5f55-----------");
                this.paymentRecordsService.saveByBill(this.dealTradeNo, this.serviceCode, this.fail);
                log.info("----------------\u4e1a\u52a1\u670d\u52a1\u56de\u8c03 \u91cd\u8bd5\u7ed3\u675f--------------------");
            }
        }
        catch (Exception e) {
            log.error("\u91cd\u8bd5\u673a\u5236\u8fd4\u56de\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(queues={"byh-aggregation-payment-orderOverTime-new"})
    public void listenOrderOverTime(@Payload OrderRabbitInfo rabbitInfo, Channel channel, Message message) throws IOException {
        block35: {
            try {
                log.info("Fetch OrderRabbitInfo from rabbit mq\uff1a " + rabbitInfo);
                String redisKey = rabbitInfo.getRedisKey();
                boolean res = this.redisTemplateService.hasKey(redisKey);
                if (!res) {
                    return;
                }
                ResponseQueryOrderVo queryOrderVo = null;
                String outTradeNo = rabbitInfo.getOutTradeNo();
                PayBill payBill = this.payBillService.getByOutTradeNo(outTradeNo);
                if (null == payBill) {
                    log.info("payBill\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u4e3b\u52a8\u91ca\u653e\u9501{}\uff0coutTradeNo:{}", (Object)redisKey, (Object)outTradeNo);
                    this.redisTemplateService.del(redisKey);
                    return;
                }
                String tradeChannl = rabbitInfo.getTradeChannl();
                if (tradeChannl.equals(PayChanEnum.WECHAT.getDisplay())) {
                    queryOrderVo = this.wechatPayService.queryOrder(payBill);
                    if (!"SUCCESS".equals(queryOrderVo.getReturnCode())) {
                        log.info("\u3010rabbitMq\u3011 wechat\u67e5\u8be2\u8ba2\u5355\u5931\u8d25\uff0c\u4e3b\u52a8\u91ca\u653eredis\u9501{}\uff0c\u539f\u56e0{}", (Object)redisKey, (Object)queryOrderVo.getReturnMsg());
                        this.redisTemplateService.del(redisKey);
                        return;
                    }
                    if (!"SUCCESS".equals(queryOrderVo.getResultCode())) {
                        log.info("\u3010rabbitMq\u3011 wechat\u67e5\u8be2\u8ba2\u5355\u6210\u529f\uff0c\u4e3b\u52a8\u91ca\u653eredis\u9501{}\uff0c\u539f\u56e0{}", (Object)redisKey, (Object)queryOrderVo.getResultMsg());
                        this.redisTemplateService.del(redisKey);
                        return;
                    }
                    String status = this.getTradeState(queryOrderVo.getTradeState());
                    log.info("\u3010rabbitMq\u3011 wechat\u8ba2\u5355\u72b6\u6001\u4e3a:{}", (Object)queryOrderVo.getTradeState());
                    if (status.equals(OrderStatusEnum.UNPAY.getValue())) {
                        log.info("\u3010rabbitMq\u3011 wechat\u8ba2\u5355\u72b6\u6001\u4e3a\u5f85\u652f\u4ed8\uff0c\u4e3b\u52a8\u91ca\u653eredis\u9501\u540c\u65f6\u5173\u95ed\u8ba2\u5355{}\uff0c\u72b6\u6001{}", (Object)redisKey, (Object)queryOrderVo.getTradeState());
                        this.wechatPayService.closeOrder(payBill);
                        this.redisTemplateService.del(redisKey);
                        return;
                    }
                    if (status.equals(OrderStatusEnum.PAID.getValue())) {
                        this.paidProcessed(payBill, queryOrderVo);
                        log.info("======\u3010rabbitMq\u3011 wechat\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u652f\u4ed8\uff0c\u5904\u7406\u76f8\u5173\u4e1a\u52a1\u5b8c\u6bd5\uff0c\u4e3b\u52a8\u91ca\u653e\u9501 ====={}", (Object)redisKey);
                        this.redisTemplateService.del(redisKey);
                        return;
                    }
                    log.info("=====\u3010rabbitMq\u3011wechat\u4e3b\u52a8\u91ca\u653eredis\u9501{} \u539f\u56e0 =====  \u8ba2\u5355\u72b6\u6001{}", (Object)redisKey, (Object)queryOrderVo.getTradeState());
                    this.redisTemplateService.del(redisKey);
                    return;
                }
                if (tradeChannl.equals(PayChanEnum.ALIPAY.getDisplay())) {
                    queryOrderVo = this.alipayService.queryOrder(payBill);
                    if (!"SUCCESS".equals(queryOrderVo.getReturnCode())) {
                        log.info("\u3010rabbitMq\u3011 alipay\u67e5\u8be2\u8ba2\u5355\u5931\u8d25\uff0c\u4e3b\u52a8\u91ca\u653eredis\u9501{}\uff0c\u539f\u56e0{}", (Object)redisKey, (Object)queryOrderVo.getReturnMsg());
                        this.redisTemplateService.del(redisKey);
                        return;
                    }
                    String status = this.getTradeState(queryOrderVo.getTradeState());
                    log.info("\u3010rabbitMq\u3011 alipay\u8ba2\u5355\u72b6\u6001\u4e3a:{}", (Object)queryOrderVo.getTradeState());
                    if (status.equals(OrderStatusEnum.UNPAY.getValue())) {
                        log.info("\u3010rabbitMq\u3011 alipay\u8ba2\u5355\u72b6\u6001\u4e3a\u5f85\u652f\u4ed8\uff0c\u4e3b\u52a8\u91ca\u653eredis\u9501\u540c\u65f6\u5173\u95ed\u8ba2\u5355\uff0credisKey{},\u72b6\u6001{}", (Object)redisKey, (Object)queryOrderVo.getTradeState());
                        this.alipayService.closeOrder(payBill);
                        this.redisTemplateService.del(redisKey);
                        return;
                    }
                    if (status.equals(OrderStatusEnum.PAID.getValue())) {
                        this.paidProcessed(payBill, queryOrderVo);
                        log.info("======\u3010rabbitMq\u3011 alipay\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u652f\u4ed8\uff0c\u5904\u7406\u76f8\u5173\u4e1a\u52a1\u5b8c\u6bd5\uff0c\u4e3b\u52a8\u91ca\u653e\u9501 ====={}", (Object)redisKey);
                        this.redisTemplateService.del(redisKey);
                        return;
                    }
                    log.info("=====\u3010rabbitMq\u3011alipay\u4e3b\u52a8\u91ca\u653eredis\u9501 \u539f\u56e0\u672a\u77e5 ====={}", (Object)redisKey);
                    this.redisTemplateService.del(redisKey);
                    return;
                }
                if (!tradeChannl.equals(PayChanEnum.UNIONPAY.getDisplay())) break block35;
                try {
                    queryOrderVo = this.unionPayService.queryOrder(payBill);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!"SUCCESS".equals(queryOrderVo.getReturnCode())) {
                    log.info("\u3010rabbitMq\u3011 \u94f6\u8054\u67e5\u8be2\u8ba2\u5355\u5931\u8d25\uff0c\u4e3b\u52a8\u91ca\u653eredis\u9501{}\uff0c\u539f\u56e0{}", (Object)redisKey, (Object)queryOrderVo.getReturnMsg());
                    this.redisTemplateService.del(redisKey);
                    return;
                }
                String status = this.getTradeState(queryOrderVo.getTradeState());
                log.info("\u3010rabbitMq\u3011 \u94f6\u8054\u8ba2\u5355\u72b6\u6001\u4e3a:{}", (Object)queryOrderVo.getTradeState());
                if (status.equals(OrderStatusEnum.UNPAY.getValue())) {
                    log.info("\u3010rabbitMq\u3011 \u94f6\u8054\u8ba2\u5355\u72b6\u6001\u4e3a\u5f85\u652f\u4ed8\uff0c\u4e3b\u52a8\u91ca\u653eredis\u9501\u540c\u65f6\u5173\u95ed\u8ba2\u5355\uff0credisKey{},\u72b6\u6001{}", (Object)redisKey, (Object)queryOrderVo.getTradeState());
                    this.alipayService.closeOrder(payBill);
                    this.redisTemplateService.del(redisKey);
                    return;
                }
                if (status.equals(OrderStatusEnum.PAID.getValue())) {
                    this.paidProcessed(payBill, queryOrderVo);
                    log.info("======\u3010rabbitMq\u3011 \u94f6\u8054\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u652f\u4ed8\uff0c\u5904\u7406\u76f8\u5173\u4e1a\u52a1\u5b8c\u6bd5\uff0c\u4e3b\u52a8\u91ca\u653e\u9501 ====={}", (Object)redisKey);
                    this.redisTemplateService.del(redisKey);
                    return;
                }
                log.info("=====\u3010rabbitMq\u3011\u94f6\u8054\u4e3b\u52a8\u91ca\u653eredis\u9501 \u539f\u56e0\u672a\u77e5 ====={}", (Object)redisKey);
                this.redisTemplateService.del(redisKey);
                return;
            }
            catch (Exception e) {
                log.error("\u91ca\u653eredis\u9501\u8fd4\u56de\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f", (Object)e.getMessage(), (Object)e);
            }
            finally {
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            }
        }
    }

    @RabbitListener(queues={"byh-aggregation-payment-queue-synchro-notify-new"})
    public void listenOrderOverTime(Channel channel, Message message) throws Exception {
        try {
            boolean diff;
            int dateDiff;
            byte[] body = message.getBody();
            String data = new String(body, "UTF-8");
            SynchroNotifyRabbit synchroNotifyRabbit = (SynchroNotifyRabbit)JSONObject.parseObject((String)data, SynchroNotifyRabbit.class);
            String dealTradeNo = synchroNotifyRabbit.getDealTradeNo();
            String outTradeNo = synchroNotifyRabbit.getOutTradeNo();
            String redisKey = synchroNotifyRabbit.getRedisKey();
            ResponseQueryOrderVo queryOrderVo = new ResponseQueryOrderVo();
            PayBill payBill = this.payBillService.getByDealTradeNo(dealTradeNo);
            if (null == payBill) {
                log.info("payBill\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u4e3b\u52a8\u91ca\u653e\u9501{}\uff0coutTradeNo:{},dealTradeNo:{},payBill:{},", new Object[]{redisKey, outTradeNo, dealTradeNo, JSONObject.toJSONString((Object)payBill)});
                log.info("====\u3010rabbitMq\u3011\u6e05\u9664\u8ba2\u5355redis\u7f13\u5b58,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                this.redisTemplateService.del(redisKey);
                this.paidFailProcessed(payBill);
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                return;
            }
            if (synchroNotifyRabbit.getTradeChannl().equals(PayChanEnum.WECHAT.getDisplay())) {
                boolean diff2;
                queryOrderVo = this.wechatPayService.queryOrder(payBill);
                boolean returnFlag = ContrastEnum.CONTRAST_SUCCESS.getValue().equals(queryOrderVo.getReturnCode());
                boolean tradeStateFlag = ContrastEnum.CONTRAST_SUCCESS.getValue().equals(queryOrderVo.getTradeState());
                boolean resultFlag = ContrastEnum.CONTRAST_SUCCESS.getValue().equals(queryOrderVo.getResultCode());
                boolean payErrorFlag = F2F_PAID_ERROR.equals(queryOrderVo.getTradeState());
                if (!returnFlag) {
                    log.info("====\u3010rabbitMq\u3011---------\u4ed8\u6b3e\u7801\u4e0b\u5355\u5931\u8d25-------,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                    this.redisTemplateService.del(redisKey);
                    log.info("====\u3010rabbitMq\u3011\u6e05\u9664\u8ba2\u5355redis\u7f13\u5b58,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                    log.info("====\u3010rabbitMq\u3011\u5fae\u4fe1\u4e0b\u5355\u5931\u8d25,\u8ba2\u5355\u53f7:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)outTradeNo, (Object)queryOrderVo.getReturnMsg());
                    this.paidFailProcessed(payBill);
                    channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                    return;
                }
                int dateDiff2 = DateUtils.currentDateDiff((Date)synchroNotifyRabbit.getTradeStartTime());
                boolean bl = diff2 = dateDiff2 > 60;
                if (payErrorFlag) {
                    log.info("\u652f\u4ed8\u4e2d\u53d6\u6d88\u652f\u4ed8,\u91cd\u65b0\u626b\u7801");
                    log.info("====\u3010rabbitMq\u3011\u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8,\u5173\u95ed\u8ba2\u5355,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                    this.wechatPayService.reverseOrderVo(payBill);
                    log.info("====\u3010rabbitMq\u3011\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u6210\u529f,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                    this.redisTemplateService.del(redisKey);
                    log.info("====\u3010rabbitMq\u3011\u6e05\u9664\u8ba2\u5355redis\u7f13\u5b58,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                    channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                    return;
                }
                if (!tradeStateFlag && diff2) {
                    log.info("====\u3010rabbitMq\u3011-------\u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8\u8d85\u65f6\u5173\u95ed\u8ba2\u5355,\u5173\u95ed\u8ba2\u5355,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                    log.info("====\u3010rabbitMq\u3011\u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8,\u5173\u95ed\u8ba2\u5355,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                    this.wechatPayService.reverseOrderVo(payBill);
                    log.info("====\u3010rabbitMq\u3011\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u6210\u529f,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                    this.redisTemplateService.del(redisKey);
                    log.info("====\u3010rabbitMq\u3011\u6e05\u9664\u8ba2\u5355redis\u7f13\u5b58,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                    this.paidFailProcessed(payBill);
                    channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                    return;
                }
                if (!resultFlag || !tradeStateFlag) {
                    Thread.sleep(500L);
                    log.info("====\u3010rabbitMq\u3011\u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8,\u8ba2\u5355\u672a\u652f\u4ed8,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                    this.rabbitProduct.synchroNotifyOrderPush(synchroNotifyRabbit);
                    channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                    return;
                }
                log.info("====\u3010rabbitMq\u3011\u5fae\u4fe1\u652f\u4ed8\u6210\u529f,\u56de\u8c03\u4e1a\u52a1,\u8ba2\u5355\u53f7:{},\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c:{}", (Object)outTradeNo, (Object)JSONObject.toJSONString((Object)synchroNotifyRabbit.getWxPayMicropayResult()));
                queryOrderVo = this.wechatPayService.queryOrder(payBill);
                this.paidProcessed(payBill, queryOrderVo);
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            }
            if (synchroNotifyRabbit.getTradeChannl().equals(PayChanEnum.ALIPAY.getDisplay())) {
                ResponseQueryOrderVo responseQueryOrderVo = this.alipayService.queryOrder(payBill);
                dateDiff = DateUtils.currentDateDiff((Date)synchroNotifyRabbit.getTradeStartTime());
                boolean bl = diff = dateDiff > 60;
                if (!"SUCCESS".equals(responseQueryOrderVo.getReturnCode())) {
                    if (diff) {
                        log.info("====\u3010rabbitMq\u3011\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25,\u56de\u8c03\u4e1a\u52a1,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                        this.paidFailProcessed(payBill);
                    } else {
                        Thread.sleep(500L);
                        log.info("====\u3010rabbitMq\u3011\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8,\u8ba2\u5355\u672a\u652f\u4ed8,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                        this.rabbitProduct.synchroNotifyOrderPush(synchroNotifyRabbit);
                    }
                    channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                    return;
                }
                log.info("====\u3010rabbitMq\u3011\u652f\u4ed8\u5b9d\u652f\u4ed8\u6210\u529f,\u56de\u8c03\u4e1a\u52a1,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                queryOrderVo.setReturnCode(responseQueryOrderVo.getReturnCode());
                queryOrderVo.setReturnMsg(responseQueryOrderVo.getReturnMsg());
                queryOrderVo.setResultCode(responseQueryOrderVo.getResultCode());
                queryOrderVo.setResultMsg(responseQueryOrderVo.getResultMsg());
                queryOrderVo.setTradeNo(responseQueryOrderVo.getTradeNo());
                queryOrderVo.setOutTradeNo(responseQueryOrderVo.getOutTradeNo());
                queryOrderVo.setOpenid(responseQueryOrderVo.getOpenid());
                queryOrderVo.setTradeState(responseQueryOrderVo.getTradeState());
                queryOrderVo.setDealTradeNo(responseQueryOrderVo.getDealTradeNo());
                queryOrderVo.setPayTime(responseQueryOrderVo.getPayTime());
                this.paidProcessed(payBill, queryOrderVo);
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            }
            if (synchroNotifyRabbit.getTradeChannl().equals(PayChanEnum.ICBC.getDisplay())) {
                CardbusinessAggregatepayB2cOnlineRefundqryResponseV1 icbcRefundOrder = this.icbcPayService.getIcbcRefundOrder(payBill);
                dateDiff = DateUtils.currentDateDiff((Date)synchroNotifyRabbit.getTradeStartTime());
                diff = dateDiff > 60;
                String pay_status = icbcRefundOrder.getPay_status();
                if (!"0".equals(pay_status)) {
                    if (diff || "1".equals(pay_status)) {
                        log.info("====\u3010rabbitMq\u3011ICBC\u9000\u6b3e\u72b6\u6001\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                        this.paidFailProcessed(payBill);
                    } else {
                        Thread.sleep(1500L);
                        log.info("====\u3010rabbitMq\u3011ICBC\u9000\u6b3e\u72b6\u6001\u5f85\u5b9a,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                        this.rabbitProduct.synchroNotifyOrderPush(synchroNotifyRabbit);
                    }
                    channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                    return;
                }
                log.info("====\u3010rabbitMq\u3011ICBC\u9000\u6b3e\u72b6\u6001\u6210\u529f,\u56de\u8c03\u4e1a\u52a1,\u8ba2\u5355\u53f7:{}", (Object)outTradeNo);
                this.icbcRefundProcessed(icbcRefundOrder, payBill);
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            }
        }
        catch (Exception e) {
            log.error("\u3010rabbitMq\u3011\u4ed8\u6b3e\u7801\u652f\u4ed8\u56de\u8c03\u9519\u8bef=", (Throwable)e);
            try {
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            }
            catch (IOException e1) {
                log.error("mq ack error=", (Throwable)e1);
            }
        }
    }

    private void notifyErrorPush(String notifyRestVo) {
        String format = "yyyy-MM-dd HH:mm:ss";
        String templateCode = "pay_der_authcode";
        String appCode = "BYCS";
        String signCode = "BYH_BY";
        String[] phones = new String[]{"15510002724", "15829771190", "15091774473"};
        Map map = (Map)JSONObject.parseObject((String)notifyRestVo, HashMap.class);
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)notifyRestVo));
        String dealTradeNo = (String)map.get("dealTradeNo");
        PayBill payBill = this.payBillService.getByDealTradeNo(dealTradeNo);
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        String mchName = mchChan.getMchName();
        log.info("\u4e1a\u52a1\u56de\u8c03\u5931\u8d25,\u77ed\u4fe1\u901a\u77e5\u76f8\u5173\u4eba\u5458\u5904\u7406! \u5546\u6237\u540d\u79f0:{},\u8ba2\u5355\u7f16\u53f7:{}", (Object)mchName, (Object)payBill.getOutTradeNo());
        HashMap<String, String> pushMap = new HashMap<String, String>();
        pushMap.put("mchName", mchName);
        pushMap.put("outTradeNo", payBill.getOutTradeNo());
        pushMap.put("endTime", DateUtils.newData((String)format));
        for (String phone : phones) {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO(templateCode, phone, pushMap);
            BaseResponse response = this.pushInfoUtil.aliSmsPush(appCode, baseAliSmsReqVO, signCode);
            log.info("\u77ed\u4fe1\u63a8\u9001\u8fd4\u56de\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)response));
        }
    }

    public void paidFailProcessed(PayBill payBill) {
        payBill.setStatus(OrderStatusEnum.PAYFAIL.getValue());
        this.payBillService.update(payBill);
        this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.CANCEL);
        log.info("\u3010rabbitMq\u3011\u8ba2\u5355\u652f\u4ed8\u5931\u8d25,\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
        log.info("-------------\u3010rabbitMq\u3011\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
        this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.CALLBACK_FAIL);
    }

    private void paidProcessed(PayBill payBill, ResponseQueryOrderVo queryOrderVo) {
        payBill.setTradeNo(queryOrderVo.getTradeNo());
        payBill.setStatus(OrderStatusEnum.PAID.getValue());
        payBill.setPayTime(queryOrderVo.getPayTime());
        log.info("\u3010rabbitMq\u3011\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
        this.payBillService.update(payBill);
        this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
        log.info("-------------\u3010rabbitMq\u3011\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
        ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
        responseNotifyRestVo.setTradeNo(queryOrderVo.getTradeNo());
        responseNotifyRestVo.setReturnCode(queryOrderVo.getReturnCode());
        responseNotifyRestVo.setReturnMsg(queryOrderVo.getReturnMsg());
        responseNotifyRestVo.setResultCode(queryOrderVo.getResultCode());
        responseNotifyRestVo.setErrCode(null);
        responseNotifyRestVo.setErrCodeDes(queryOrderVo.getResultMsg());
        responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
        responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
        responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
        responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
        responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
        responseNotifyRestVo.setPayTime(queryOrderVo.getPayTime());
        responseNotifyRestVo.setMchCode(payBill.getMchCode());
        PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
        responseNotifyRestVo.setApplyId(payApply.getApplyId());
        Map signMap = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
        String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
        responseNotifyRestVo.setSign(sign);
        this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
        log.info("\u3010rabbitMq\u3011\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseNotifyRestVo.toString());
        this.notifyService.notify(PAY, JSON.toJSONString((Object)responseNotifyRestVo));
    }

    private void icbcRefundProcessed(CardbusinessAggregatepayB2cOnlineRefundqryResponseV1 req, PayBill payBill) {
        payBill.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
        String intrx_serial_no = req.getIntrx_serial_no();
        payBill.setRefundNo(intrx_serial_no);
        payBill.setOutRefundNo(req.getOuttrx_serial_no());
        PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
        log.info("ICBC\u9000\u6b3e\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
        this.payBillService.update(payBill);
        this.paymentRecordsService.saveByRefundBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND, payBill.getOutRefundNo());
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        log.info("-------------\u6784\u5efaResponseRefundNotifyRestVo\uff0c\u51c6\u5907\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u9000\u6b3e\u6d41\u7a0b-----------");
        ResponseRefundNotifyRestVo responseRefundNotifyRestVo = new ResponseRefundNotifyRestVo();
        responseRefundNotifyRestVo.setMchCode(payBill.getMchCode());
        responseRefundNotifyRestVo.setMchId(wxPayParam.getMchAccount());
        responseRefundNotifyRestVo.setMchName(payMch.getName());
        responseRefundNotifyRestVo.setReturnCode("SUCCESS");
        responseRefundNotifyRestVo.setReturnMsg(null);
        responseRefundNotifyRestVo.setErrCode(null);
        responseRefundNotifyRestVo.setErrCodeDes(null);
        responseRefundNotifyRestVo.setPayChannel(payBill.getTradeChannel());
        responseRefundNotifyRestVo.setServiceCode(payBill.getServiceCode());
        responseRefundNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
        responseRefundNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
        responseRefundNotifyRestVo.setRefundNo(intrx_serial_no);
        responseRefundNotifyRestVo.setTotalAmount(payBill.getDealAmount());
        responseRefundNotifyRestVo.setRefundMoney(BigDecimal.valueOf(Long.parseLong(req.getReject_amt())).divide(new BigDecimal(100)));
        responseRefundNotifyRestVo.setRefundTime(payBill.getRefundTime());
        if (null != payBill.getServiceCode() && !"".equals(payBill.getServiceCode().trim())) {
            responseRefundNotifyRestVo.setAttach(payBill.getServiceCode());
        }
        if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
            responseRefundNotifyRestVo.setRemake(payBill.getRemake());
        }
        responseRefundNotifyRestVo.setNotifyResultStr(JSON.toJSONString((Object)req));
        PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
        responseRefundNotifyRestVo.setApplyId(payApply.getApplyId());
        responseRefundNotifyRestVo.setOutRefundNo(payBill.getOutRefundNo());
        Map signMap = SignUtil.getKeyAndValue((Object)responseRefundNotifyRestVo);
        String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
        responseRefundNotifyRestVo.setSign(sign);
        this.paymentRecordsService.saveByRefundBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK, payBill.getOutRefundNo());
        log.info("ICBC \u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseRefundNotifyRestVo.toString());
        this.notifyService.notify(REFUND, JSON.toJSONString((Object)responseRefundNotifyRestVo));
    }

    private String getTradeState(String tradeStatus) {
        String status = String.valueOf(OrderStatusEnum.UNKNOWN.getValue());
        if (NOTPAY.equals(tradeStatus) || USERPAYING.equals(tradeStatus) || WAIT_BUYER_PAY.equals(tradeStatus)) {
            status = String.valueOf(OrderStatusEnum.UNPAY.getValue());
        }
        if ("SUCCESS".equals(tradeStatus) || PAID_TRADE_SUCCESS.equals(tradeStatus)) {
            status = String.valueOf(OrderStatusEnum.PAID.getValue());
        }
        return status;
    }
}

