/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayOpenAuthTokenAppRequest;
import com.alipay.api.response.AlipayOpenAuthTokenAppResponse;
import com.ebaiyihui.aggregation.payment.common.model.IsvInfo;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.server.bo.ali.AgentOpParam;
import com.ebaiyihui.aggregation.payment.server.bo.ali.AliAppTypeEnum;
import com.ebaiyihui.aggregation.payment.server.bo.ali.AliAuthNotifyResp;
import com.ebaiyihui.aggregation.payment.server.bo.ali.AliIsvAuthReq;
import com.ebaiyihui.aggregation.payment.server.bo.ali.AliIsvInfo;
import com.ebaiyihui.aggregation.payment.server.mapper.IsvInfoMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.MchChanMapper;
import com.ebaiyihui.aggregation.payment.server.service.AliAuthService;
import com.ebaiyihui.aggregation.payment.server.service.notify.Util;
import com.ebaiyihui.framework.response.BaseResponse;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import me.chanjar.weixin.common.util.http.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AliAuthServiceImpl
implements AliAuthService {
    private static final Logger log = LoggerFactory.getLogger(AliAuthServiceImpl.class);
    @Resource
    private IsvInfoMapper isvInfoMapper;
    @Value(value="${pay.bill.environment}")
    protected String payEnvironment;
    @Resource
    private MchChanMapper mchChanMapper;

    public BaseResponse getUrl(String isvCode, String appType, String applyCode) {
        IsvInfo isvInfo = this.isvInfoMapper.selectOne(isvCode, "ALIPAY");
        AliIsvInfo aliIsvInfo = (AliIsvInfo)JSONObject.parseObject((String)isvInfo.getParam(), AliIsvInfo.class);
        AliIsvAuthReq aliIsvAuthReq = new AliIsvAuthReq();
        aliIsvAuthReq.setTaskType("INTERFACE_AUTH");
        aliIsvAuthReq.setPlatformCode("0");
        String display = AliAppTypeEnum.getByValue((String)appType).getDisplay();
        AgentOpParam agentOpParam = new AgentOpParam();
        String state = isvCode + "," + applyCode + "," + appType;
        String encode = Base64.encode(state.getBytes("UTF-8"));
        String baseUrl = "test".equals(this.payEnvironment) ? "https://paydevapi.chinachdu.com/auth_ali/notify" : "https://payapi.chinachdu.com/auth_ali/notify";
        agentOpParam.setState(encode);
        agentOpParam.setIsvAppId(aliIsvInfo.getAppId());
        agentOpParam.setRedirectUri(baseUrl);
        agentOpParam.setAppTypes(new String[]{display});
        aliIsvAuthReq.setAgentOpParam(agentOpParam);
        String jsonString = JSONObject.toJSONString((Object)aliIsvAuthReq);
        log.info("get ali auth param:{}", (Object)jsonString);
        String s = URIUtil.encodeURIComponent((String)jsonString);
        String pc = "https://b.alipay.com/page/message/tasksDetail?bizData=" + s;
        String h5 = "alipays://platformapi/startapp?appId=2021003130652097&page=pages%2Fauthorize%2Findex%3FbizData%3D" + s;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pc", (Object)pc);
        jsonObject.put("h5", (Object)h5);
        return BaseResponse.success((Object)jsonObject);
    }

    public void notify(HttpServletRequest httpServletRequest) {
        Map notifyparams = Util.convertRequestParamsToMap((HttpServletRequest)httpServletRequest);
        log.info("\u652f\u4ed8\u5b9d\u4e09\u65b9\u5e94\u7528\u6388\u6743\u56de\u8c03\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)notifyparams));
        AliAuthNotifyResp aliAuthNotifyResp = (AliAuthNotifyResp)JSON.parseObject((String)JSONObject.toJSONString((Object)notifyparams), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        String state = new String(Base64.decode(aliAuthNotifyResp.getState()), "utf-8");
        String[] s = state.split("_");
        String isvCode = s[0];
        String applyCode = s[1];
        String appType = s[2];
        IsvInfo isvInfo = this.isvInfoMapper.selectOne(isvCode, "ALIPAY");
        AliIsvInfo aliIsvInfo = (AliIsvInfo)JSONObject.parseObject((String)isvInfo.getParam(), AliIsvInfo.class);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", aliIsvInfo.getAppId(), aliIsvInfo.getPrivateKey(), "json", "UTF-8", aliIsvInfo.getPublicKey(), "RSA2");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("grant_type", "authorization_code");
        map.put("code", aliAuthNotifyResp.getApp_auth_code());
        AlipayOpenAuthTokenAppRequest request = new AlipayOpenAuthTokenAppRequest();
        request.setBizContent(JSONObject.toJSONString(map));
        log.info("\u652f\u4ed8\u5b9d\u4e09\u65b9\u5e94\u7528\u83b7\u53d6token\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)request));
        AlipayOpenAuthTokenAppResponse response = (AlipayOpenAuthTokenAppResponse)alipayClient.execute((AlipayRequest)request);
        log.info("\u652f\u4ed8\u5b9d\u4e09\u65b9\u5e94\u7528\u83b7\u53d6token\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        if (response.isSuccess()) {
            WxPayParam wxPayParam = new WxPayParam();
            wxPayParam.setAppAuthToken(response.getAppAuthToken());
            wxPayParam.setMchAccount(aliIsvInfo.getMchAccount());
            wxPayParam.setAppId(aliIsvInfo.getAppId());
            wxPayParam.setAppPrivateKey(aliIsvInfo.getPrivateKey());
            wxPayParam.setMchPublicKey(aliIsvInfo.getPublicKey());
            wxPayParam.setSubMchId(response.getUserId());
            wxPayParam.setSubAppId(response.getAuthAppId());
            this.mchChanMapper.updateOneByCodeAndChannelCode(applyCode, "ALIPAY", appType, JSON.toJSONString((Object)wxPayParam));
        } else {
            log.error("get alipay auth token error,e=", (Object)response.getSubMsg());
        }
    }
}

