/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.response.AlipayTradePayResponse;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestDownloadVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestOfflineOederQueryVO;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrCodeCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrIsSweptCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseCloseOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseReverseOrderVo;
import com.ebaiyihui.aggregation.payment.server.Factory.PayFactory;
import com.ebaiyihui.aggregation.payment.server.constant.URLConstant;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.SynchroNotifyRabbit;
import com.ebaiyihui.aggregation.payment.server.service.BaseService;
import com.ebaiyihui.aggregation.payment.server.service.TradeService;
import com.ebaiyihui.aggregation.payment.server.utils.MapToJsonUtils;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.aggregation.payment.server.wxpay.wxbo.WxPayMicropayResultBO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1;
import com.icbc.api.request.CardbusinessAggregatepayB2cOnlineMerrefundRequestV1;
import com.icbc.api.request.CardbusinessAggregatepayB2cOnlineRefundqryRequestV1;
import com.icbc.api.response.CardbusinessAggregatepayB2cOnlineConsumepurchaseResponseV1;
import com.icbc.api.response.CardbusinessAggregatepayB2cOnlineMerrefundResponseV1;
import com.icbc.api.response.CardbusinessAggregatepayB2cOnlineRefundqryResponseV1;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ICBCPayServiceImpl
extends BaseService
implements TradeService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ICBCPayServiceImpl.class);
    @Autowired
    private URLConstant urlConstant;

    public void afterPropertiesSet() throws Exception {
        PayFactory.register((String)PayChanEnum.ICBC.getDisplay(), (TradeService)this);
    }

    public BaseResponse<String> createOrder(HttpServletRequest request, RequestCreateOrderVo requestCreateOrderVo) {
        log.info("ICBC\u652f\u4ed8\u4e0b\u5355\u5165\u53c2:{}", (Object)requestCreateOrderVo.toString());
        String redisKey = requestCreateOrderVo.getOutTradeNo() + "_" + requestCreateOrderVo.getPayType();
        if (BigDecimal.ZERO.compareTo(requestCreateOrderVo.getTotalAmount()) >= 0) {
            return BaseResponse.error((String)"\u8ba2\u5355\u91d1\u989d\u5f02\u5e38");
        }
        PayBill pb = this.payBillService.getByOutTradeNoAndStatus(requestCreateOrderVo.getOutTradeNo(), OrderStatusEnum.PAID.getValue());
        if (null != pb) {
            return BaseResponse.error((String)"\u5df2\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
        }
        String orderViewId = UniqueKeyGenerator.generateViewId();
        PayBill payBill = this.payBillService.getByCreateOrder(requestCreateOrderVo);
        log.info("ICBC\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)payBill.toString());
        payBill.setDealTradeNo(orderViewId);
        this.payBillService.save(payBill);
        this.paymentRecordsService.saveByBill(orderViewId, requestCreateOrderVo.getServiceCode(), RecordsEnum.DID_NOT_PAY);
        BaseResponse payResponse = this.getICBCPayResponse(requestCreateOrderVo, orderViewId, redisKey);
        return payResponse;
    }

    private BaseResponse<String> getICBCPayResponse(RequestCreateOrderVo requestCreateOrderVo, String orderViewId, String redisKey) {
        PayBill payBill = this.payBillService.getByDealTradeNo(orderViewId);
        MchChan mchChan = this.mchChanMapper.selectOneByCode(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        log.info("ICBC\u83b7\u53d6\u652f\u4ed8\u53c2\u6570:{}", (Object)mchChan.toString());
        if (null == mchChan) {
            return null;
        }
        WxPayParam payParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        log.info("\u5f53\u524dICBC\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)payBill.toString());
        CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1.CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1Biz vo = this.icbcPayBeanConvert(requestCreateOrderVo, payParam);
        BaseResponse payment = this.sendPayment(vo, payParam, orderViewId, requestCreateOrderVo.getOutTradeNo());
        return payment;
    }

    private CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1.CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1Biz icbcPayBeanConvert(RequestCreateOrderVo req, WxPayParam payParam) {
        CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1.CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1Biz param = new CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1.CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1Biz();
        param.setMer_id(payParam.getMchAccount());
        param.setOut_trade_no(req.getOutTradeNo());
        param.setPay_mode("9");
        param.setAccess_type("9");
        param.setMer_prtcl_no(payParam.getSecret());
        param.setOrig_date_time(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
        param.setDecive_info("WEB");
        param.setBody("\u4e92\u8054\u7f51\u533b\u9662");
        param.setFee_type("001");
        param.setSpbill_create_ip("127.0.0.1");
        param.setTotal_fee(ICBCPayServiceImpl.yuan2penny((BigDecimal)req.getActuallyAmount()));
        param.setMer_url(this.urlConstant.getRemoteCallAddress() + "/notify/icbcpaynotify");
        log.info("icbc payment notify url:{}", (Object)param.getMer_url());
        param.setShop_appid(payParam.getAppId());
        param.setIcbc_appid(payParam.getSubAppId());
        param.setOpen_id(req.getUserSign());
        param.setAttach(MapToJsonUtils.mapInitAndToJsonString((String)req.getServiceCode(), (String)(StringUtils.isBlank((CharSequence)req.getApplyCode()) ? req.getMchCode() : req.getApplyCode()), (String)req.getPayType()));
        param.setNotify_type("HS");
        param.setResult_type("1");
        return param;
    }

    private BaseResponse<String> sendPayment(CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1.CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1Biz req, WxPayParam payParam, String orderViewId, String outTradeNo) {
        String icbcAppid = payParam.getSubAppId();
        String icbcPrivateKey = payParam.getAppPrivateKey();
        String icbcPublicKey = payParam.getMchPublicKey();
        DefaultIcbcClient client = new DefaultIcbcClient(icbcAppid, "RSA2", icbcPrivateKey, icbcPublicKey);
        CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1 request = new CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1();
        request.setServiceUrl("https://gw.open.icbc.com.cn/api/cardbusiness/aggregatepay/b2c/online/consumepurchase/V1");
        request.setBizContent((BizContent)req);
        CardbusinessAggregatepayB2cOnlineConsumepurchaseResponseV1 response = null;
        try {
            log.info("icbc payment request:{}", (Object)JSONObject.toJSONString((Object)request));
            response = (CardbusinessAggregatepayB2cOnlineConsumepurchaseResponseV1)client.execute((IcbcRequest)request, System.currentTimeMillis() + "");
            String result = JSON.toJSONString((Object)response);
            log.info("icbc payment response:{}", (Object)result);
            if (response.isSuccess()) {
                String wx_data_package = response.getWx_data_package();
                JSONObject jsonObject = JSONObject.parseObject((String)wx_data_package);
                jsonObject.put("packageValue", (Object)jsonObject.getString("package"));
                jsonObject.put("paySign", (Object)jsonObject.getString("sign"));
                jsonObject.put("outTradeNo", (Object)outTradeNo);
                jsonObject.put("dealTradeNo", (Object)orderViewId);
                jsonObject.put("timeStamp", (Object)jsonObject.getString("timestamp"));
                jsonObject.put("nonceStr", (Object)jsonObject.getString("noncestr"));
                jsonObject.remove((Object)"package");
                jsonObject.remove((Object)"sign");
                jsonObject.remove((Object)"timestamp");
                jsonObject.remove((Object)"noncestr");
                return BaseResponse.success((Object)jsonObject.toJSONString());
            }
            String returnMsg = response.getReturnMsg();
            log.error("icbc payment error ReturnMsg:{}", (Object)returnMsg);
            return BaseResponse.error((String)returnMsg);
        }
        catch (IcbcApiException e) {
            log.error("\u8c03\u7528\u5de5\u884c\u4e0b\u5355\u63a5\u53e3\u5931\u8d25:{}", (Object)e.getMessage());
            return BaseResponse.error((String)"\u4e0b\u5355\u5931\u8d25");
        }
    }

    public BaseResponse<String> refundOrder(RequestRefundOrderVo requestRefundOrderVo) {
        log.info("ICBC\u9000\u6b3e\u7684\u5165\u53c2\uff1a{}", (Object)requestRefundOrderVo.toString());
        try {
            boolean firstRefund = true;
            PayBill payBill = this.payBillService.getByDealTradeNo(requestRefundOrderVo.getDealTradeNo());
            String dealTradeNo = payBill.getDealTradeNo();
            String serviceCode = payBill.getServiceCode();
            String refundNo = requestRefundOrderVo.getOutTradeNo();
            if (refundNo.equals(payBill.getOutTradeNo())) {
                refundNo = UniqueKeyGenerator.generateViewId();
            }
            if (payBill.getOutRefundNo() != null) {
                firstRefund = false;
            }
            String tradeType = payBill.getTradeType();
            MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), tradeType);
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
            this.checkRequestRefundParam(requestRefundOrderVo);
            CardbusinessAggregatepayB2cOnlineMerrefundRequestV1.CardbusinessAggregatepayB2cOnlineMerrefundRequestV1Biz vo = this.icbcRefundBeanConvert(requestRefundOrderVo, refundNo, wxPayParam, payBill);
            this.paymentRecordsService.saveByRefundBill(dealTradeNo, serviceCode, RecordsEnum.REFUND, refundNo);
            boolean sendRefundFlag = this.sendRefund(vo, wxPayParam);
            if (sendRefundFlag) {
                this.saveRefund(payBill, refundNo, firstRefund, requestRefundOrderVo);
                SynchroNotifyRabbit synchroNotifyRabbit = new SynchroNotifyRabbit(new WxPayMicropayResultBO(), new AlipayTradePayResponse(), new Date(), PayChanEnum.ICBC.getDisplay(), "", payBill.getOutTradeNo(), payBill.getDealTradeNo());
                this.rabbitProduct.synchroNotifyOrderPush(synchroNotifyRabbit);
                return BaseResponse.success((Object)"\u9000\u6b3e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("ICBC\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff01\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25" + e.getMessage()));
        }
        return BaseResponse.error((String)"\u7533\u8bf7\u9000\u6b3e\u5931\u8d25");
    }

    private void checkRequestRefundParam(RequestRefundOrderVo req) {
        String outTradeNo = req.getOutTradeNo();
        String dealTradeNo = req.getDealTradeNo();
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)dealTradeNo)) {
            throw new RuntimeException("\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private CardbusinessAggregatepayB2cOnlineMerrefundRequestV1.CardbusinessAggregatepayB2cOnlineMerrefundRequestV1Biz icbcRefundBeanConvert(RequestRefundOrderVo req, String refundNo, WxPayParam wxPayParam, PayBill payBill) {
        CardbusinessAggregatepayB2cOnlineMerrefundRequestV1.CardbusinessAggregatepayB2cOnlineMerrefundRequestV1Biz param = new CardbusinessAggregatepayB2cOnlineMerrefundRequestV1.CardbusinessAggregatepayB2cOnlineMerrefundRequestV1Biz();
        param.setMer_id(wxPayParam.getMchAccount());
        param.setOuttrx_serial_no(refundNo);
        param.setOut_trade_no(payBill.getOutTradeNo());
        param.setRet_total_amt(ICBCPayServiceImpl.yuan2penny((BigDecimal)req.getRefundAmount()));
        param.setTrnsc_ccy("001");
        param.setIcbc_appid(wxPayParam.getSubAppId());
        param.setMer_prtcl_no(wxPayParam.getSecret());
        return param;
    }

    private boolean sendRefund(CardbusinessAggregatepayB2cOnlineMerrefundRequestV1.CardbusinessAggregatepayB2cOnlineMerrefundRequestV1Biz req, WxPayParam payParam) {
        String icbcAppid = payParam.getSubAppId();
        String icbcPrivateKey = payParam.getAppPrivateKey();
        String icbcPublicKey = payParam.getMchPublicKey();
        DefaultIcbcClient client = new DefaultIcbcClient(icbcAppid, "RSA2", icbcPrivateKey, icbcPublicKey);
        CardbusinessAggregatepayB2cOnlineMerrefundRequestV1 request = new CardbusinessAggregatepayB2cOnlineMerrefundRequestV1();
        request.setServiceUrl("https://gw.open.icbc.com.cn/api/cardbusiness/aggregatepay/b2c/online/merrefund/V1");
        request.setBizContent((BizContent)req);
        try {
            log.info("icbc refund request:{}", (Object)JSONObject.toJSONString((Object)request));
            CardbusinessAggregatepayB2cOnlineMerrefundResponseV1 response = (CardbusinessAggregatepayB2cOnlineMerrefundResponseV1)client.execute((IcbcRequest)request, System.currentTimeMillis() + "");
            String result = JSON.toJSONString((Object)response);
            log.info("icbc refund  response:{}", (Object)result);
            if (response.isSuccess()) {
                return true;
            }
            String returnMsg = response.getReturnMsg();
            log.error("icbc refund error ReturnMsg:{}", (Object)returnMsg);
        }
        catch (IcbcApiException e) {
            log.error("\u8c03\u7528\u5de5\u884c\u9000\u6b3e\u63a5\u53e3\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return false;
    }

    private void saveRefund(PayBill refundBill, String refundNo, boolean firstRefund, RequestRefundOrderVo requestRefundOrderVo) {
        refundBill.setStatus(OrderStatusEnum.REFUNDING.getValue());
        refundBill.setRefundAmount(requestRefundOrderVo.getTotalAmount());
        refundBill.setRefundTime(new Date());
        refundBill.setOutRefundNo(refundNo);
        refundBill.setRefundNotifyUrl(requestRefundOrderVo.getRefundNotifyUrl());
        if (firstRefund) {
            this.payBillService.update(refundBill);
        } else {
            this.payBillService.save(refundBill);
        }
        String dealTradeNo = requestRefundOrderVo.getDealTradeNo();
        String serviceCode = refundBill.getServiceCode();
        this.paymentRecordsService.saveByRefundBill(dealTradeNo, serviceCode, RecordsEnum.REFUND, refundNo);
    }

    public ResponseQueryOrderVo queryOrder(PayBill payBill) {
        return null;
    }

    public ResponseQueryRefundOrderVo queryRefundOrder(RequestQueryRefundOrderVo requestQueryRefundOrderVo, PayBill payBill) {
        return null;
    }

    public CardbusinessAggregatepayB2cOnlineRefundqryResponseV1 getIcbcRefundOrder(PayBill payBill) {
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        String icbcAppid = wxPayParam.getSubAppId();
        String icbcPrivateKey = wxPayParam.getAppPrivateKey();
        String icbcPublicKey = wxPayParam.getMchPublicKey();
        DefaultIcbcClient client = new DefaultIcbcClient(icbcAppid, "RSA2", icbcPrivateKey, icbcPublicKey);
        CardbusinessAggregatepayB2cOnlineRefundqryRequestV1 request = new CardbusinessAggregatepayB2cOnlineRefundqryRequestV1();
        CardbusinessAggregatepayB2cOnlineRefundqryRequestV1.CardbusinessAggregatepayB2cOnlineRefundqryRequestV1Biz req = new CardbusinessAggregatepayB2cOnlineRefundqryRequestV1.CardbusinessAggregatepayB2cOnlineRefundqryRequestV1Biz();
        req.setMer_id(wxPayParam.getMchAccount());
        req.setOut_trade_no(payBill.getOutTradeNo());
        req.setOuttrx_serial_no(payBill.getOutRefundNo());
        req.setMer_prtcl_no(wxPayParam.getSecret());
        request.setServiceUrl("https://gw.open.icbc.com.cn/api/cardbusiness/aggregatepay/b2c/online/refundqry/V1");
        request.setBizContent((BizContent)req);
        try {
            log.info("icbc query refund order request:{}", (Object)JSONObject.toJSONString((Object)request));
            CardbusinessAggregatepayB2cOnlineRefundqryResponseV1 response = (CardbusinessAggregatepayB2cOnlineRefundqryResponseV1)client.execute((IcbcRequest)request, System.currentTimeMillis() + "");
            String result = JSON.toJSONString((Object)response);
            log.info("icbc query refund order response:{}", (Object)result);
            if (response.isSuccess()) {
                return response;
            }
            String returnMsg = response.getReturnMsg();
            log.error("icbc query refund order error ReturnMsg:{}", (Object)returnMsg);
        }
        catch (IcbcApiException e) {
            log.error("\u8c03\u7528\u5de5\u884c\u9000\u6b3e\u67e5\u8be2\u63a5\u53e3\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return null;
    }

    public ResponseCloseOrderVo closeOrder(PayBill payBill) {
        return null;
    }

    public ResponseReverseOrderVo reverseOrderVo(PayBill payBill) {
        return null;
    }

    public BaseResponse downLoadBill(RequestDownloadVo requestDownloadVo) {
        return null;
    }

    public ResponseQueryOrderVo offlineQueryOrder(RequestOfflineOederQueryVO reqVo) {
        return null;
    }

    public BaseResponse<String> qrIsSwept(RequestQrIsSweptCreateOrderVo orderVo) throws IOException {
        return null;
    }

    public BaseResponse<String> qrCode(RequestQrCodeCreateOrderVo qrCodeCreateOrderVo) throws IOException {
        return null;
    }

    public BaseResponse<String> createPolymericOrder(HttpServletRequest request, PayBill payBill, RequestCreateOrderVo requestCreateOrderVo) {
        return null;
    }

    public static String yuan2penny(BigDecimal yuan) {
        return yuan.multiply(new BigDecimal(100)).setScale(0, 4).toString();
    }
}

