/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayChan;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.model.PayMchAppLink;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.RequestGetAppIdVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.RequestAddMchParamVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.RequestGetMchChatVO;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.RequestMchParamVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.RequestSaveMchParamVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.ResponseMchParamPageVo;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.MchChanMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayApplyMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayChanMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchAppLinkMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MchChanServiceImpl
extends ServiceImpl<MchChanMapper, MchChan>
implements MchChanService {
    private static final Logger log = LoggerFactory.getLogger(MchChanServiceImpl.class);
    @Autowired
    private MchChanMapper mchChanMapper;
    @Autowired
    private PayChanMapper payChanMapper;
    @Autowired
    private PayMchMapper payMchMapper;
    @Autowired
    private PayApplyMapper payAppplyMapper;
    @Autowired
    private PayMchAppLinkMapper payMchAppLinkMapper;

    public void save(RequestSaveMchParamVo requestSaveMchParamVo) {
        MchChan mchChan = new MchChan();
        BeanUtils.copyProperties((Object)requestSaveMchParamVo, (Object)mchChan);
        mchChan.setStatus(Integer.valueOf(1));
        String param = JSON.toJSONString((Object)requestSaveMchParamVo.getWxPayParam());
        if (PayChanEnum.WECHAT.getDisplay().equals(requestSaveMchParamVo.getChanCode())) {
            mchChan.setMerchantsMark(requestSaveMchParamVo.getWxPayParam().getMchAccount());
        }
        mchChan.setParam(param);
        this.mchChanMapper.insert((Object)mchChan);
    }

    public void addMchChan(RequestAddMchParamVo requestAddMchParamVo) {
        String applyCode = requestAddMchParamVo.getApplyCode();
        PayMch payMch = this.payMchMapper.selectPayMchByApplyCode(applyCode);
        if (payMch == null) {
            PayApply payApply = this.payAppplyMapper.getByApplyCode(applyCode);
            PayMchAppLink payMchAppLink = this.payMchAppLinkMapper.selectOneByApplyId(payApply.getId());
            payMch = (PayMch)this.payMchMapper.selectById((Serializable)payMchAppLink.getPayMchId());
        }
        MchChan mchChan = new MchChan();
        BeanUtils.copyProperties((Object)requestAddMchParamVo, (Object)mchChan);
        mchChan.setStatus(Integer.valueOf(1));
        String param = JSON.toJSONString((Object)requestAddMchParamVo.getWxPayParam());
        if (PayChanEnum.WECHAT.getDisplay().equals(requestAddMchParamVo.getChanCode())) {
            mchChan.setMerchantsMark(requestAddMchParamVo.getWxPayParam().getMchAccount());
        }
        mchChan.setParam(param);
        mchChan.setMchName(requestAddMchParamVo.getMchName());
        mchChan.setMchCode(payMch.getCode());
        mchChan.setMchId(payMch.getId());
        String chanCode = requestAddMchParamVo.getChanCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)chanCode);
        PayChan payChan = (PayChan)this.payChanMapper.selectOne((Wrapper)queryWrapper);
        mchChan.setChanId(payChan.getId());
        mchChan.setChanCode(chanCode);
        this.mchChanMapper.insert((Object)mchChan);
    }

    public void update(ResponseMchParamPageVo responseMchParamPageVo) {
        MchChan mchChan = new MchChan();
        BeanUtils.copyProperties((Object)responseMchParamPageVo, (Object)mchChan);
        String param = JSON.toJSONString((Object)responseMchParamPageVo.getWxPayParam());
        mchChan.setParam(param);
        this.mchChanMapper.updateById((Object)mchChan);
    }

    public ResponseMchParamPageVo getById(Long id) {
        ResponseMchParamPageVo responseMchParamPageVo = new ResponseMchParamPageVo();
        MchChan mchChan = (MchChan)this.mchChanMapper.selectById((Serializable)id);
        if (null == mchChan) {
            return responseMchParamPageVo;
        }
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        BeanUtils.copyProperties((Object)mchChan, (Object)responseMchParamPageVo);
        responseMchParamPageVo.setWxPayParam(wxPayParam);
        return responseMchParamPageVo;
    }

    public int delete(Long id) {
        return this.mchChanMapper.deleteById((Serializable)id);
    }

    public IPage<ResponseMchParamPageVo> getPage(RequestMchParamVo requestMchParamVo) {
        MchChan wrapperMchChan = new MchChan();
        QueryWrapper wrapper = new QueryWrapper();
        if (null != requestMchParamVo.getChanId()) {
            wrapperMchChan.setChanId(requestMchParamVo.getChanId());
        }
        if (null != requestMchParamVo.getMchId()) {
            wrapperMchChan.setMchId(requestMchParamVo.getMchId());
        }
        wrapper.setEntity((Object)wrapperMchChan);
        IPage mchChanIPage = this.mchChanMapper.selectPage((IPage)new Page((long)requestMchParamVo.getPageNum(), (long)requestMchParamVo.getPageSize()), (Wrapper)wrapper);
        if (null == mchChanIPage) {
            return mchChanIPage;
        }
        List mchChans = mchChanIPage.getRecords();
        if (null == mchChans) {
            return mchChanIPage;
        }
        ArrayList<ResponseMchParamPageVo> responseMchParamPageVoList = new ArrayList<ResponseMchParamPageVo>();
        for (MchChan mchChan : mchChans) {
            ResponseMchParamPageVo responseMchParamPageVo = this.getResponseMchParamPageVo(mchChan);
            responseMchParamPageVoList.add(responseMchParamPageVo);
        }
        mchChanIPage.setRecords(responseMchParamPageVoList);
        return mchChanIPage;
    }

    public WxPayParam getWxPay(MchChan mchChan) {
        return (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
    }

    public String getWxPayByMchCodeAndChanCodeAndType(String mchCode, String chanCode, String type) {
        MchChan mchChan = this.getMchChanByApplyAndChanCodeAndType(mchCode, chanCode, type);
        if (null == mchChan) {
            return null;
        }
        return mchChan.getParam();
    }

    public MchChan getMchChanByApplyAndChanCodeAndType(String applyCode, String chanCode, String type) {
        MchChan mchChan = this.mchChanMapper.selectOneByCode(applyCode, chanCode, type);
        return mchChan;
    }

    private PayChan getPayChanCode(String chanCode) {
        PayChan wrapperpayChan = new PayChan();
        wrapperpayChan.setCode(chanCode);
        wrapperpayChan.setStatus(Integer.valueOf(1));
        QueryWrapper payChanWrapper = new QueryWrapper((Object)wrapperpayChan);
        payChanWrapper.last("limit 1");
        PayChan payChan = (PayChan)this.payChanMapper.selectOne((Wrapper)payChanWrapper);
        return payChan;
    }

    private PayMch getPayMchCode(String mchCode) {
        PayMch wrapperPayMch = new PayMch();
        wrapperPayMch.setCode(mchCode);
        wrapperPayMch.setStatus(Integer.valueOf(1));
        QueryWrapper payMchWrapper = new QueryWrapper((Object)wrapperPayMch);
        payMchWrapper.last("limit 1");
        PayMch payMch = (PayMch)this.payMchMapper.selectOne((Wrapper)payMchWrapper);
        if (payMch == null) {
            PayApply payApply = this.payAppplyMapper.getByApplyCode(mchCode);
            Optional.of(payApply).orElseThrow(() -> new IllegalArgumentException("\u5e94\u7528\u7f16\u7801\u65e0\u6548\u8bf7\u68c0\u67e5\u3002applyCode=" + mchCode));
            PayMchAppLink payMchAppLink = this.payMchAppLinkMapper.selectOneByApplyId(payApply.getId());
            payMch = (PayMch)this.payMchMapper.selectById((Serializable)payMchAppLink.getPayMchId());
        }
        return payMch;
    }

    public WxPayParam getByMerchantsId(String merchantsId) {
        MchChan wrapperChan = new MchChan();
        wrapperChan.setMerchantsMark(merchantsId);
        QueryWrapper wrapper = new QueryWrapper((Object)wrapperChan);
        wrapper.last("limit 1");
        MchChan mchChan = (MchChan)this.mchChanMapper.selectOne((Wrapper)wrapper);
        if (null == mchChan) {
            return null;
        }
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        return wxPayParam;
    }

    public WxPayParam getMchChanByMchIdAndChanId(String mchCode, String chanCode, String type) {
        PayMch tempPayMch = this.getPayMchCode(mchCode);
        PayChan tempPayChan = this.getPayChanCode(chanCode);
        MchChan wrappermchChan = new MchChan();
        wrappermchChan.setMchId(tempPayMch.getId());
        wrappermchChan.setChanId(tempPayChan.getId());
        if (StringUtils.isNotBlank((CharSequence)type)) {
            wrappermchChan.setType(type);
        }
        QueryWrapper Wrapper2 = new QueryWrapper((Object)wrappermchChan);
        Wrapper2.last("limit 1");
        MchChan mchChan = (MchChan)this.mchChanMapper.selectOne((Wrapper)Wrapper2);
        if (null == mchChan) {
            return null;
        }
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        return wxPayParam;
    }

    public BaseResponse<List<String>> getAppIdList(RequestGetAppIdVo requestGetAppIdVo) {
        PayMch tempPayMch = this.getPayMchCode(requestGetAppIdVo.getMchCode());
        PayChan tempPayChan = this.getPayChanCode(requestGetAppIdVo.getPayChannel());
        MchChan wrappermchChan = new MchChan();
        wrappermchChan.setMchId(tempPayMch.getId());
        wrappermchChan.setChanId(tempPayChan.getId());
        QueryWrapper wrapper = new QueryWrapper((Object)wrappermchChan);
        List mchChans = this.mchChanMapper.selectList((Wrapper)wrapper);
        if (null == mchChans) {
            return BaseResponse.error((String)"\u67e5\u8be2\u7684AppId\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<String> appIds = new ArrayList<String>();
        for (MchChan mchChan : mchChans) {
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
            appIds.add(wxPayParam.getAppId());
        }
        return BaseResponse.success(appIds);
    }

    public List<ResponseMchParamPageVo> getMchChanByMchIdAndMchCode(RequestGetMchChatVO reqVo) {
        List chanList = this.mchChanMapper.selectMchChanListByMchId(reqVo.getMchId(), reqVo.getMchCode());
        ArrayList<ResponseMchParamPageVo> paramPageVoList = new ArrayList<ResponseMchParamPageVo>();
        for (MchChan mchChan : chanList) {
            ResponseMchParamPageVo responseMchParamPageVo = this.getResponseMchParamPageVo(mchChan);
            paramPageVoList.add(responseMchParamPageVo);
        }
        return paramPageVoList;
    }

    public List<ResponseMchParamPageVo> getMchChanByApply(String applyCode) {
        PayMch payMch = this.payMchMapper.selectPayMchByApplyCode(applyCode);
        if (payMch == null) {
            PayApply payApply = this.payAppplyMapper.getByApplyCode(applyCode);
            if (payApply == null) {
                return null;
            }
            PayMchAppLink payMchAppLink = this.payMchAppLinkMapper.selectOneByApplyId(payApply.getId());
            payMch = (PayMch)this.payMchMapper.selectById((Serializable)payMchAppLink.getPayMchId());
        }
        RequestGetMchChatVO requestGetMchChatVO = new RequestGetMchChatVO();
        requestGetMchChatVO.setMchCode(payMch.getCode());
        requestGetMchChatVO.setMchId(payMch.getId());
        return this.getMchChanByMchIdAndMchCode(requestGetMchChatVO);
    }

    private ResponseMchParamPageVo getResponseMchParamPageVo(MchChan mchChan) {
        ResponseMchParamPageVo responseMchParamPageVo = new ResponseMchParamPageVo();
        BeanUtils.copyProperties((Object)mchChan, (Object)responseMchParamPageVo);
        WxPayParam wxPayParam = (WxPayParam)JSON.parseObject((String)mchChan.getParam(), WxPayParam.class);
        responseMchParamPageVo.setWxPayParam(wxPayParam);
        return responseMchParamPageVo;
    }

    public List<String> getPayChannelByMchCode(String mchCode) {
        return this.mchChanMapper.getPayChannelByCode(mchCode);
    }
}

