/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ebaiyihui.aggregation.payment.common.model.BaseEntity;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.model.PayMchAppLink;
import com.ebaiyihui.aggregation.payment.common.vo.mchvo.MchPageVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchvo.RequestMchVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchvo.RequestPageMchVo;
import com.ebaiyihui.aggregation.payment.server.mapper.PayApplyMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchAppLinkMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.service.PayMchService;
import com.ebaiyihui.aggregation.payment.server.utils.StringUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayMchServiceImpl
implements PayMchService {
    private static final Logger log = LoggerFactory.getLogger(PayMchServiceImpl.class);
    @Autowired
    private PayMchMapper payMchMapper;
    @Autowired
    private PayApplyMapper payApplyMapper;
    @Autowired
    private PayMchAppLinkMapper payMchAppLinkMapper;

    public void save(RequestMchVo requestMchVo) {
        PayMch payMch = new PayMch();
        BeanUtils.copyProperties((Object)requestMchVo, (Object)payMch);
        this.payMchMapper.insert((Object)payMch);
    }

    public void update(PayMch payMch) {
        this.payMchMapper.updateById((Object)payMch);
    }

    public PayMch getById(Long id) {
        return (PayMch)this.payMchMapper.selectById((Serializable)id);
    }

    public int delete(Long id) {
        PayMch payMch = new PayMch();
        payMch.setId(id);
        payMch.setStatus(Integer.valueOf(0));
        int count = this.payMchMapper.deleteById((Serializable)id);
        return count;
    }

    public IPage<PayMch> getPage(RequestPageMchVo requestPageMchVo) {
        PayMch payMchWrapper = new PayMch();
        MchPageVo mchPageVo = requestPageMchVo.getMchPageVo();
        QueryWrapper wrapper = new QueryWrapper();
        if (null != mchPageVo) {
            if (StringUtil.isNotEmpty((String)mchPageVo.getName())) {
                wrapper.like((Object)"name", (Object)mchPageVo.getName());
            }
            payMchWrapper.setStatus(mchPageVo.getStatus());
        }
        wrapper.setEntity((Object)payMchWrapper);
        wrapper.like((Object)"name", (Object)mchPageVo.getName());
        return this.payMchMapper.selectPage((IPage)new Page((long)requestPageMchVo.getPageNum(), (long)requestPageMchVo.getPageSize()), (Wrapper)wrapper);
    }

    public PayMch getByCode(String code) {
        return this.getByApplyCode(code);
    }

    public PayMch checkMchName(String name) {
        return (PayMch)this.payMchMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{PayMch::getCode}).eq(PayMch::getName, (Object)name)).eq(BaseEntity::getStatus, (Object)1));
    }

    public PayMch checkMchCode(String code) {
        return (PayMch)this.payMchMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{PayMch::getCode}).eq(PayMch::getCode, (Object)code)).eq(BaseEntity::getStatus, (Object)1));
    }

    public Boolean updateCheckName(Long id, String name) {
        PayMch payMch = (PayMch)this.payMchMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{PayMch::getName, BaseEntity::getId}).eq(PayMch::getName, (Object)name)).eq(BaseEntity::getStatus, (Object)1));
        if (null == payMch || id.equals(payMch.getId())) {
            return true;
        }
        return false;
    }

    public Boolean updateCheckCode(Long id, String code) {
        PayMch payMch = (PayMch)this.payMchMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{PayMch::getCode, BaseEntity::getId}).eq(PayMch::getCode, (Object)code)).eq(BaseEntity::getStatus, (Object)1));
        if (null == payMch || id.equals(payMch.getId())) {
            return true;
        }
        return false;
    }

    public List<PayMch> getAllPayMch() {
        PayMch payMchWrapper = new PayMch();
        payMchWrapper.setStatus(Integer.valueOf(1));
        QueryWrapper wrapper = new QueryWrapper((Object)payMchWrapper);
        return this.payMchMapper.selectList((Wrapper)wrapper);
    }

    public PayMch getByApplyCode(String applyCode) {
        PayMch payMch = this.payMchMapper.selectPayMchByApplyCode(applyCode);
        if (payMch == null) {
            PayApply payApply = this.payApplyMapper.getByApplyCode(applyCode);
            Optional.of(payApply).orElseThrow(() -> new IllegalArgumentException("\u5e94\u7528\u7f16\u7801\u65e0\u6548\u8bf7\u68c0\u67e5\u3002applyCode=" + applyCode));
            PayMchAppLink payMchAppLink = this.payMchAppLinkMapper.selectOneByApplyId(payApply.getId());
            payMch = (PayMch)this.payMchMapper.selectById((Serializable)payMchAppLink.getPayMchId());
        }
        Optional.of(payMch).orElseThrow(() -> new IllegalArgumentException("\u5e94\u7528\u7f16\u7801\u65e0\u6548\u8bf7\u68c0\u67e5\u3002applyCode=" + applyCode));
        return payMch;
    }
}

