/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.ebaiyihui.aggregation.payment.common.model.ProfitSharingBind;
import com.ebaiyihui.aggregation.payment.common.model.ThirdPartyRelation;
import com.ebaiyihui.aggregation.payment.common.vo.ThirdPartyRelationVO;
import com.ebaiyihui.aggregation.payment.server.mapper.ProfitSharingBindMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ThirdPartyRelationMapper;
import com.ebaiyihui.aggregation.payment.server.service.ThirdPartyRelationService;
import com.ebaiyihui.aggregation.payment.server.utils.Md5Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdPartyRelationServiceImpl
implements ThirdPartyRelationService {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyRelationServiceImpl.class);
    @Autowired
    private ThirdPartyRelationMapper relationMapper;
    @Autowired
    private ProfitSharingBindMapper bindMapper;

    public ThirdPartyRelation getRelationInfoByApplyCode(String applyCode) {
        ThirdPartyRelation infoByApplyCode = this.relationMapper.getRelationInfoByApplyCode(applyCode);
        return infoByApplyCode;
    }

    public int save(ThirdPartyRelationVO partyRelationVO) {
        ThirdPartyRelation partyRelation = new ThirdPartyRelation();
        BeanUtils.copyProperties((Object)partyRelationVO, (Object)partyRelation);
        int insertSelective = this.relationMapper.insertSelective(partyRelation);
        ProfitSharingBind profitSharingBind = new ProfitSharingBind();
        String hyUid = partyRelationVO.getHyUid();
        profitSharingBind.setMainMerchant(hyUid);
        profitSharingBind.setChannel(partyRelationVO.getApplyChannel());
        profitSharingBind.setMainMerchantName(partyRelationVO.getHyLoginNumber());
        profitSharingBind.setBindCode(Md5Utils.get12Char((String)hyUid));
        this.bindMapper.insertSelective(profitSharingBind);
        return insertSelective;
    }

    public int update(ThirdPartyRelationVO partyRelationVO) {
        ThirdPartyRelation relation = new ThirdPartyRelation();
        BeanUtils.copyProperties((Object)partyRelationVO, (Object)relation);
        int keySelective = this.relationMapper.updateByPrimaryKeySelective(relation);
        return keySelective;
    }
}

