/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.ProfitSharingRecord;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.server.enums.ProfitSharingEnums;
import com.ebaiyihui.aggregation.payment.server.service.BaseService;
import com.ebaiyihui.aggregation.payment.server.service.WxProfitSharingService;
import com.ebaiyihui.aggregation.payment.server.utils.UUIDUtil;
import com.ebaiyihui.aggregation.payment.server.wxpay.ProfitSharingDetail;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingFinishRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingQueryRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingQueryResult;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReceiverRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReceiverResult;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingResult;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReturnQueryRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReturnRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReturnResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.ProfitSharingService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.ProfitSharingServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WxProfitSharingServiceImpl
extends BaseService
implements WxProfitSharingService {
    private static final Logger log = LoggerFactory.getLogger(WxProfitSharingServiceImpl.class);

    public ProfitSharingReceiverResult addReceiver(ProfitSharingReceiverRequest request) throws Exception {
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId("BYH", "WECHAT", null);
        WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        wxPayService.getConfig().setKeyPath(wxPayParam.getKeyPath());
        ProfitSharingService profitSharingService = this.wxPayConfiguration.profitSharingService(wxPayParam);
        return profitSharingService.addReceiver(request);
    }

    public ProfitSharingResult profitSharing(ProfitSharingRequest request) throws Exception {
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId("BYH", "WECHAT", null);
        ProfitSharingService profitSharingService = this.wxPayConfiguration.profitSharingService(wxPayParam);
        return profitSharingService.profitSharing(request);
    }

    public ProfitSharingResult profitSharingFinish(ProfitSharingFinishRequest request) throws Exception {
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId("BYH", "WECHAT", null);
        WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
        return new ProfitSharingServiceImpl(wxPayService).profitSharingFinish(request);
    }

    public ProfitSharingQueryResult profitSharingQuery(ProfitSharingQueryRequest request) throws Exception {
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId("BYH", "WECHAT", null);
        WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
        return new ProfitSharingServiceImpl(wxPayService).profitSharingQuery(request);
    }

    public BaseResponse<ProfitSharingReturnResult> profitSharingReturn(ProfitSharingReturnRequest returnRequest) throws Exception {
        boolean judgeResult;
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId("BYH", "WECHAT", null);
        WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
        ProfitSharingRecord saveProfitSharingRecord = new ProfitSharingRecord();
        saveProfitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_REFUND_DEFAULT.getProfitSharingStatusCode());
        saveProfitSharingRecord.setProfitSharingType(ProfitSharingEnums.ProfitSharingTypeEnum.WECHAT_PROFIT_SHARING.getProfitSharingTypeId());
        saveProfitSharingRecord.setOutTradeNo(returnRequest.getOutOrderNo());
        saveProfitSharingRecord.setProfitSharingOperatingData(JSONObject.toJSONString((Object)returnRequest));
        this.profitSharingRecordMapper.insert((Object)saveProfitSharingRecord);
        if (StringUtils.isBlank((CharSequence)returnRequest.getOutOrderNo())) {
            return BaseResponse.error((String)"\u5546\u6237\u5206\u8d26\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ProfitSharingRecord queryProfitSharingRecord = new ProfitSharingRecord();
        queryProfitSharingRecord.setOutTradeNo(returnRequest.getOutOrderNo());
        queryProfitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_SUCCESS.getProfitSharingStatusCode());
        queryProfitSharingRecord.setProfitSharingType(ProfitSharingEnums.ProfitSharingTypeEnum.WECHAT_PROFIT_SHARING.getProfitSharingTypeId());
        QueryWrapper queryWrapper = new QueryWrapper((Object)queryProfitSharingRecord);
        ProfitSharingRecord profitSharingRecord = (ProfitSharingRecord)this.profitSharingRecordMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.isNull(profitSharingRecord) || Objects.isNull(profitSharingRecord.getProfitSharingOperatingData())) {
            return BaseResponse.error((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5f53\u524d\u8ba2\u5355\u53f7\u7684\u5206\u6da6\u8ba2\u5355\u6216\u6570\u636e,\u8bf7\u68c0\u67e5\u8ba2\u5355\u53f7\u662f\u5426\u6b63\u786e");
        }
        ProfitSharingRequest profitSharingRequest = (ProfitSharingRequest)JSONObject.parse((String)profitSharingRecord.getProfitSharingOperatingData());
        List profitSharingDetails = JSONObject.parseArray((String)profitSharingRequest.getReceivers(), ProfitSharingDetail.class);
        if (CollectionUtils.isEmpty((Collection)profitSharingDetails)) {
            return BaseResponse.error((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5f53\u524d\u8ba2\u5355\u53f7\u7684\u5206\u6da6\u4eba\u660e\u7ec6,\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
        }
        boolean result = profitSharingDetails.stream().map(ProfitSharingDetail::getAccount).anyMatch(account -> account.equals(returnRequest.getReturnAccount()));
        if (!result) {
            return BaseResponse.error((String)"\u5f53\u524d\u5206\u8d26\u8bb0\u5f55\u4e2d\u6ca1\u6709\u8fd9\u4e2a\u5206\u8d26Id");
        }
        returnRequest.setOutReturnNo(UUIDUtil.getUUID());
        returnRequest.setReturnAccountType("MERCHANT_ID");
        ProfitSharingReturnResult profitSharingReturnResult = new ProfitSharingServiceImpl(wxPayService).profitSharingReturn(returnRequest);
        log.info("\u8bf7\u6c42\u5fae\u4fe1\u5206\u6da6\u9000\u6b3e\u63a5\u53e3\u8fd4\u56de:[" + profitSharingReturnResult + "]");
        boolean bl = judgeResult = ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_REFUND_SUCCESS.getProfitSharingJudgment().equals(profitSharingReturnResult.getReturnCode()) && ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_REFUND_SUCCESS.getProfitSharingJudgment().equals(profitSharingReturnResult.getResultCode());
        if (judgeResult) {
            saveProfitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_REFUND_SUCCESS.getProfitSharingStatusCode());
            saveProfitSharingRecord.setProfitSharingResultMsg(profitSharingReturnResult.getResult());
        } else {
            saveProfitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_REFUND_FAIL.getProfitSharingStatusCode());
            saveProfitSharingRecord.setProfitSharingErrorCode(profitSharingReturnResult.getErrorCode());
            saveProfitSharingRecord.setProfitSharingResultMsg(profitSharingReturnResult.getErrorMsg());
        }
        int updateNum = this.profitSharingRecordMapper.updateById((Object)saveProfitSharingRecord);
        if (updateNum > 0) {
            log.info("\u5fae\u4fe1\u5206\u6da6\u9000\u6b3e\u4fee\u6539\u6210\u529f");
        }
        return BaseResponse.success((Object)profitSharingReturnResult);
    }

    public ProfitSharingReturnResult profitSharingReturnQuery(ProfitSharingReturnQueryRequest queryRequest) throws Exception {
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId("BYH", "WECHAT", null);
        WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
        return new ProfitSharingServiceImpl(wxPayService).profitSharingReturnQuery(queryRequest);
    }

    public ProfitSharingReceiverResult removeReceiver(ProfitSharingReceiverRequest request) throws Exception {
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId("BYH", "WECHAT", null);
        WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
        return new ProfitSharingServiceImpl(wxPayService).removeReceiver(request);
    }

    public ProfitSharingResult multiProfitSharing(ProfitSharingRequest request) throws Exception {
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId("BYH", "WECHAT", null);
        WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        wxPayService.getConfig().setKeyPath(wxPayParam.getKeyPath());
        ProfitSharingServiceImpl profitSharingService = new ProfitSharingServiceImpl(wxPayService);
        ProfitSharingRecord profitSharingRecord = new ProfitSharingRecord();
        profitSharingRecord.setOutTradeNo(request.getOutOrderNo());
        profitSharingRecord.setProfitSharingType(ProfitSharingEnums.ProfitSharingTypeEnum.WECHAT_PROFIT_SHARING.getProfitSharingTypeId());
        profitSharingRecord.setProfitSharingOperatingData(JSONObject.toJSONString((Object)request));
        profitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_DEFAULT.getProfitSharingStatusCode());
        this.profitSharingRecordMapper.insert((Object)profitSharingRecord);
        ProfitSharingResult profitSharingResult = null;
        try {
            profitSharingResult = profitSharingService.multiProfitSharing(request);
        }
        catch (WxPayException e) {
            profitSharingRecord.setProfitSharingResultMsg(e.getReturnMsg());
            return this.resultToDealWith(profitSharingRecord, profitSharingResult, e);
        }
        return this.resultToDealWith(profitSharingRecord, profitSharingResult);
    }

    public ProfitSharingResult resultToDealWith(ProfitSharingRecord profitSharingRecord, ProfitSharingResult profitSharingResult, WxPayException wxPayException) {
        profitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_FAILURE.getProfitSharingStatusCode());
        profitSharingRecord.setProfitSharingResultMsg(wxPayException.getReturnMsg());
        profitSharingRecord.setProfitSharingErrorCode(wxPayException.getReturnCode());
        ProfitSharingRecord updateProfitSharingRecord = new ProfitSharingRecord();
        updateProfitSharingRecord.setId(profitSharingRecord.getId());
        QueryWrapper queryWrapper = new QueryWrapper((Object)updateProfitSharingRecord);
        this.profitSharingRecordMapper.update((Object)profitSharingRecord, (Wrapper)queryWrapper);
        if (Objects.isNull(profitSharingResult)) {
            profitSharingResult = new ProfitSharingResult();
        }
        BeanUtils.copyProperties((Object)profitSharingRecord, (Object)profitSharingResult);
        profitSharingResult.setReturnMsg(wxPayException.getReturnMsg());
        return profitSharingResult;
    }

    public ProfitSharingResult resultToDealWith(ProfitSharingRecord profitSharingRecord, ProfitSharingResult profitSharingResult) {
        if (ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_SUCCESS.getProfitSharingStatusName().equals(profitSharingResult.getReturnCode())) {
            profitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_PROCESSING.getProfitSharingStatusCode());
            profitSharingRecord.setProfitSharingResultMsg(profitSharingResult.getErrCodeDes());
            profitSharingRecord.setProfitSharingErrorCode(profitSharingResult.getErrCode());
        } else if (ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_FAILURE.getProfitSharingStatusName().equals(profitSharingResult.getReturnCode())) {
            profitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.getProfitSharingStatus((String)profitSharingResult.getReturnCode()));
            profitSharingRecord.setProfitSharingResultMsg(profitSharingResult.getReturnMsg());
        }
        ProfitSharingRecord updateProfitSharingRecord = new ProfitSharingRecord();
        updateProfitSharingRecord.setId(profitSharingRecord.getId());
        QueryWrapper queryWrapper = new QueryWrapper((Object)updateProfitSharingRecord);
        this.profitSharingRecordMapper.update((Object)profitSharingRecord, (Wrapper)queryWrapper);
        return profitSharingResult;
    }
}

