/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.mybank.notify;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.BatchAdditionBill;
import com.ebaiyihui.aggregation.payment.common.model.ThirdNotifyRecord;
import com.ebaiyihui.aggregation.payment.server.enums.ApplyChannelEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.BatchAdditionBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayIsvThirdMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ThirdNotifyRecordMapper;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.RequestHead;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.notify.BkcloudfundsBillpayBatchFinishNotifyModel;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.parser.xml.XmlConverter;
import com.ebaiyihui.aggregation.payment.server.mybank.manage.CommonRequestHandler;
import com.ebaiyihui.aggregation.payment.server.mybank.request.notify.BkcloudfundsBillpayBatchFinishNotifyRequest;
import com.ebaiyihui.aggregation.payment.server.service.mybank.notify.MybankNotifyService;
import com.ebaiyihui.aggregation.payment.server.utils.HttpsClientUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bkcloudfundsBillpayBatchFinishNotifyService")
public class BkcloudfundsBillpayBatchFinishNotifyServiceImpl
implements MybankNotifyService {
    private static final Logger log = LoggerFactory.getLogger(BkcloudfundsBillpayBatchFinishNotifyServiceImpl.class);
    @Autowired
    private CommonRequestHandler commonRequestHandler;
    @Resource
    private ThirdNotifyRecordMapper thirdNotifyRecordMapper;
    @Resource
    private BatchAdditionBillMapper batchAdditionBillMapper;
    @Resource
    private PayIsvThirdMapper payIsvThirdMapper;

    public String notifyHandle(String context, String function, String privateKey) throws Exception {
        log.info("batch finished notify!!");
        BkcloudfundsBillpayBatchFinishNotifyRequest billpayBatchFinishNotifyRequest = (BkcloudfundsBillpayBatchFinishNotifyRequest)XmlConverter.getInstance().toResponse(context, BkcloudfundsBillpayBatchFinishNotifyRequest.class);
        RequestHead head = billpayBatchFinishNotifyRequest.getBkcloudfundsBillpayBatchFinishNotify().getRequestHead();
        BkcloudfundsBillpayBatchFinishNotifyModel model = billpayBatchFinishNotifyRequest.getBkcloudfundsBillpayBatchFinishNotify().getBkcloudfundsBillpayBatchFinishNotifyModel();
        log.info("batch notify model:{}", (Object)JSONObject.toJSONString((Object)model));
        boolean flag = this.saveNotify(head, model);
        this.notifyBatchFinished(model);
        return this.commonRequestHandler.getSignResult(flag, head, privateKey);
    }

    private void notifyBatchFinished(BkcloudfundsBillpayBatchFinishNotifyModel model) {
        BatchAdditionBill batchAdditionBill = new BatchAdditionBill();
        String isvOrgId = model.getIsvOrgId();
        batchAdditionBill.setIsvOrgId(isvOrgId);
        batchAdditionBill.setBatchNo(model.getBatchNo());
        QueryWrapper wrapper = new QueryWrapper((Object)batchAdditionBill);
        List batchAdditionBills = this.batchAdditionBillMapper.selectList((Wrapper)wrapper);
        String param = JSONObject.toJSONString((Object)batchAdditionBills);
        String url = this.payIsvThirdMapper.selectBatchUrlByIsvOrgId(isvOrgId);
        log.info("\u8c03\u7528\u5206\u8d26\u901a\u77e5\u4e1a\u52a1\u63a5\u53e3\u505a\u7ed3\u679c\u901a\u77e5,url={},\u8bf7\u6c42\u53c2\u6570{}", (Object)url, (Object)param);
        JSONObject result = HttpsClientUtil.doPostForJson((String)url, (String)param);
        log.info("\u5206\u8d26\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u8fd4\u56de\u7ed3\u679c\uff1aJSONObject{}", (Object)result);
    }

    private boolean saveNotify(RequestHead head, BkcloudfundsBillpayBatchFinishNotifyModel model) {
        ThirdNotifyRecord thirdNotifyRecord = new ThirdNotifyRecord();
        thirdNotifyRecord.setMarkName(head.getFunction());
        thirdNotifyRecord.setType(ApplyChannelEnum.MYBANK.getApplyChannel());
        thirdNotifyRecord.setParam(JSONObject.toJSONString((Object)model));
        this.thirdNotifyRecordMapper.insert((Object)thirdNotifyRecord);
        this.batchAdditionBillMapper.updateInstanceIdByIsvOrgId(model.getIsvOrgId(), model.getBatchInstanceId());
        return true;
    }
}

