/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.notify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.payparam.AlipayNotifyParam;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.service.notify.INotify;
import com.ebaiyihui.aggregation.payment.server.service.notify.NotifyFactory;
import com.ebaiyihui.aggregation.payment.server.service.notify.RabbitMqPusher;
import com.ebaiyihui.aggregation.payment.server.service.notify.Util;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtil;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliPayNotify
implements INotify,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AliPayNotify.class);
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PayApplyService payApplyService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RabbitMqPusher rabbitMqPusher;

    public String notify(HttpServletRequest request) {
        log.info("=====\u3010\u652f\u4ed8\u5b9d\u3011\u8fdb\u5165\u4e86\u652f\u4ed8\u5b9d\u56de\u8c03=====");
        log.info("===\u652f\u4ed8\u5b9d\u56de\u8c03\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)request.getParameterMap()));
        try {
            Map notifyparams = Util.convertRequestParamsToMap((HttpServletRequest)request);
            PayBill payBill = this.payBillService.getByOutTradeNo((String)notifyparams.get("out_trade_no"));
            log.info("===\u6839\u636e\u56de\u8c03\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f:{}", (Object)payBill);
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)this.mchChanService.getWxPayByMchCodeAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType())), WxPayParam.class);
            boolean signVerified = AlipaySignature.rsaCheckV1((Map)notifyparams, (String)wxPayParam.getMchPublicKey(), (String)"UTF-8", (String)"RSA2");
            if (!signVerified) {
                log.error("=======\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u5b9d\u9a8c\u7b7e\u5931\u8d25=======");
                return "failure";
            }
            BigDecimal bigDecimal = new BigDecimal((String)notifyparams.get("total_amount")).setScale(2, 1);
            BigDecimal orderAmount = payBill.getOrderAmount();
            int compare = bigDecimal.compareTo(orderAmount);
            log.info("\u4ed8\u6b3e\u91d1\u989d\u6bd4\u8f83\u7ed3\u679c:{}", (Object)compare);
            boolean refundFee = notifyparams.containsKey("refund_fee");
            String outTradeNo = (String)notifyparams.get("out_trade_no");
            log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u8ba2\u5355\u53f7\u662f{}", (Object)outTradeNo);
            if (compare == 0) {
                if (!refundFee) {
                    log.info("-------\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03----------");
                    payBill.setTradeNo((String)notifyparams.get("trade_no"));
                    payBill.setStatus(OrderStatusEnum.PAID.getValue());
                    payBill.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)((String)notifyparams.get("gmt_payment"))));
                    log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
                    this.payBillService.update(payBill);
                    this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
                    log.info("-------------\u3010\u652f\u4ed8\u5b9d\u3011\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
                    ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                    responseNotifyRestVo.setTradeNo((String)notifyparams.get("trade_no"));
                    responseNotifyRestVo.setReturnCode((String)notifyparams.get("code"));
                    responseNotifyRestVo.setReturnMsg((String)notifyparams.get("msg"));
                    responseNotifyRestVo.setResultCode("");
                    responseNotifyRestVo.setErrCode("");
                    responseNotifyRestVo.setErrCodeDes("");
                    responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
                    responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
                    responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
                    responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
                    responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
                    if (null != payBill.getAttach() && !"".equals(payBill.getAttach().trim())) {
                        responseNotifyRestVo.setAttach(payBill.getAttach());
                    }
                    if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                        responseNotifyRestVo.setRemake(payBill.getRemake());
                    }
                    responseNotifyRestVo.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)((String)notifyparams.get("gmt_payment"))));
                    PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
                    responseNotifyRestVo.setApplyId(payApply.getApplyId());
                    Map signMap = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
                    String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
                    responseNotifyRestVo.setSign(sign);
                    this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
                    log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseNotifyRestVo.toString());
                    this.rabbitMqPusher.notify("pay", JSON.toJSONString((Object)responseNotifyRestVo));
                    String redisKey = payBill.getServiceCode() + "_" + payBill.getOutTradeNo();
                    this.redisTemplateService.del(redisKey);
                } else {
                    log.info("---------\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03--------------");
                    AlipayNotifyParam alipayNotifyParam = (AlipayNotifyParam)JSON.parseObject((String)JSON.toJSONString((Object)notifyparams), AlipayNotifyParam.class);
                    payBill.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
                    Date notify_time = DateUtil.getTextDate((String)((String)notifyparams.get("notify_time")), (String)"yyyy-MM-dd HH:mm:ss");
                    payBill.setRefundTime(notify_time);
                    payBill.setRefundNo((String)notifyparams.get("notify_id"));
                    payBill.setOutRefundNo((String)notifyparams.get("out_biz_no"));
                    log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u4fee\u6539\u8ba2\u5355\u72b6\u6001{}", (Object)payBill.toString());
                    this.payBillService.update(payBill);
                    log.info("-------------\u3010\u652f\u4ed8\u5b9d\u3011\u6dfb\u52a0\u652f\u4ed8\u8bb0\u5f55\uff1a\u5df2\u9000\u6b3e-------------");
                    this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND);
                    log.info("-------------\u3010\u652f\u4ed8\u5b9d\u3011\u51c6\u5907\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u9000\u6b3e\u6d41\u7a0b-----------");
                    ResponseRefundNotifyRestVo responseRefundNotifyRestVo = new ResponseRefundNotifyRestVo();
                    responseRefundNotifyRestVo.setReturnCode((String)notifyparams.get("notify_type"));
                    responseRefundNotifyRestVo.setReturnMsg((String)notifyparams.get("trade_status"));
                    responseRefundNotifyRestVo.setErrCode("");
                    responseRefundNotifyRestVo.setErrCodeDes("");
                    responseRefundNotifyRestVo.setPayChannel(payBill.getTradeChannel());
                    responseRefundNotifyRestVo.setServiceCode(payBill.getServiceCode());
                    responseRefundNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
                    responseRefundNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
                    responseRefundNotifyRestVo.setRefundNo((String)notifyparams.get("trade_status"));
                    responseRefundNotifyRestVo.setTotalAmount(payBill.getDealAmount());
                    responseRefundNotifyRestVo.setRefundMoney(alipayNotifyParam.getRefundFee());
                    if (null != payBill.getAttach() && !"".equals(payBill.getAttach().trim())) {
                        responseRefundNotifyRestVo.setAttach(payBill.getAttach());
                    }
                    if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                        responseRefundNotifyRestVo.setRemake(payBill.getRemake());
                    }
                    responseRefundNotifyRestVo.setRefundTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)alipayNotifyParam.getGmtRefund().toString()));
                    PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
                    responseRefundNotifyRestVo.setApplyId(payApply.getApplyId());
                    Map signMap = SignUtil.getKeyAndValue((Object)responseRefundNotifyRestVo);
                    String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
                    responseRefundNotifyRestVo.setSign(sign);
                    this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK);
                    log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u6570\u636e{}", (Object)responseRefundNotifyRestVo.toString());
                    this.rabbitMqPusher.notify("refund", JSON.toJSONString((Object)responseRefundNotifyRestVo));
                }
                return "success";
            }
            return "failure";
        }
        catch (AlipayApiException e) {
            log.error("\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u56de\u8c03\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            return "failure";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "failure";
        }
    }

    public void afterPropertiesSet() throws Exception {
        NotifyFactory.register((String)this.getClass().getSimpleName().toLowerCase(), (INotify)this);
    }
}

