/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.notify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.payparam.AlipayNotifyParam;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.notify.INotify;
import com.ebaiyihui.aggregation.payment.server.service.notify.NotifyFactory;
import com.ebaiyihui.aggregation.payment.server.service.notify.RabbitMqPusher;
import com.ebaiyihui.aggregation.payment.server.service.notify.Util;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlipayRefund
implements INotify,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AlipayRefund.class);
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private PayApplyService payApplyService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RabbitMqPusher rabbitMqPusher;

    public String notify(HttpServletRequest request) {
        log.info("=====\u3010\u652f\u4ed8\u5b9d\u3011\u8fdb\u5165\u4e86\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03=====");
        Map notifyparams = Util.convertRequestParamsToMap((HttpServletRequest)request);
        log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)notifyparams));
        try {
            PayBill payBill = this.payBillService.getByDealTradeNo((String)notifyparams.get("out_trade_no"));
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)this.mchChanService.getWxPayByMchCodeAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType())), WxPayParam.class);
            boolean signVerified = AlipaySignature.rsaCheckV1((Map)notifyparams, (String)wxPayParam.getMchPublicKey(), (String)"UTF-8", (String)"RSA2");
            if (!signVerified) {
                log.info("=====\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03\u53c2\u6570\u9a8c\u7b7e\u5931\u8d25=====");
                return "failure";
            }
            AlipayNotifyParam alipayNotifyParam = (AlipayNotifyParam)JSON.parseObject((String)JSON.toJSONString((Object)notifyparams), AlipayNotifyParam.class);
            String orderId = alipayNotifyParam.getOutTradeNo();
            log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u8ba2\u5355\u53f7\uff1a{}", (Object)orderId);
            payBill.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
            payBill.setRefundTime(alipayNotifyParam.getGmtRefund());
            payBill.setRefundNo(alipayNotifyParam.getOutBizNo());
            payBill.setOutRefundNo(null);
            log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u4fee\u6539\u8ba2\u5355\u72b6\u6001{}", (Object)payBill.toString());
            this.payBillService.update(payBill);
            log.info("-------------\u3010\u652f\u4ed8\u5b9d\u3011\u6dfb\u52a0\u652f\u4ed8\u8bb0\u5f55\uff1a\u5df2\u9000\u6b3e-------------");
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND);
            log.info("-------------\u3010\u652f\u4ed8\u5b9d\u3011\u51c6\u5907\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u9000\u6b3e\u6d41\u7a0b-----------");
            ResponseRefundNotifyRestVo responseRefundNotifyRestVo = new ResponseRefundNotifyRestVo();
            responseRefundNotifyRestVo.setReturnCode(alipayNotifyParam.getTradeStatus());
            responseRefundNotifyRestVo.setReturnMsg(alipayNotifyParam.getTradeStatus());
            responseRefundNotifyRestVo.setErrCode("");
            responseRefundNotifyRestVo.setErrCodeDes("");
            responseRefundNotifyRestVo.setPayChannel(payBill.getTradeChannel());
            responseRefundNotifyRestVo.setServiceCode(payBill.getServiceCode());
            responseRefundNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
            responseRefundNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
            responseRefundNotifyRestVo.setRefundNo(alipayNotifyParam.getOutBizNo());
            if (null != payBill.getAttach() && !"".equals(payBill.getAttach().trim())) {
                responseRefundNotifyRestVo.setAttach(payBill.getAttach());
            }
            if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                responseRefundNotifyRestVo.setRemake(payBill.getRemake());
            }
            responseRefundNotifyRestVo.setTotalAmount(payBill.getDealAmount());
            responseRefundNotifyRestVo.setRefundMoney(alipayNotifyParam.getRefundFee());
            responseRefundNotifyRestVo.setRefundTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)alipayNotifyParam.getGmtRefund().toString()));
            PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
            responseRefundNotifyRestVo.setApplyId(payApply.getApplyId());
            Map signMap = SignUtil.getKeyAndValue((Object)responseRefundNotifyRestVo);
            String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
            responseRefundNotifyRestVo.setSign(sign);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK);
            log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u6570\u636e{}", (Object)responseRefundNotifyRestVo.toString());
            this.rabbitMqPusher.notify("refund", JSON.toJSONString((Object)responseRefundNotifyRestVo));
            return "success";
        }
        catch (AlipayApiException e) {
            log.error("\u3010\u652f\u4ed8\u5b9d\u3011\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03\u7ed3\u679c\u5f02\u5e38:\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            return "failure";
        }
    }

    public void afterPropertiesSet() throws Exception {
        String name = this.getClass().getSimpleName();
        String concatName = name.substring(0, 1).toLowerCase().concat(name.substring(1));
        NotifyFactory.register((String)concatName, (INotify)this);
    }
}

