/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.reconciliation;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.BaseEntity;
import com.ebaiyihui.aggregation.payment.common.model.ChannelBill;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.ReWriteBillVO;
import com.ebaiyihui.aggregation.payment.server.config.WxPayConfiguration;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.manage.PushInfoManage;
import com.ebaiyihui.aggregation.payment.server.mapper.PayBillMapper;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.AReconciliationBill;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.ReconciliationTypeFactory;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.BillFilter;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.ChannelBillBO;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.DateCondition;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.PlatformBillBO;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.WxPayBillBO;
import com.github.binarywang.wxpay.bean.request.WxPayDownloadBillRequest;
import com.github.binarywang.wxpay.bean.result.WxPayBillInfo;
import com.github.binarywang.wxpay.bean.result.WxPayBillResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WeChat
extends AReconciliationBill
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WeChat.class);
    final PayBillMapper payBillMapper;
    final WxPayConfiguration wxPayConfiguration;
    final PushInfoManage pushInfoManage;

    public void saveChannelBill(String billDate) {
        LambdaQueryWrapper eq = new LambdaQueryWrapper();
        eq.eq(MchChan::getChanCode, (Object)"WECHAT");
        eq.eq(BaseEntity::getStatus, (Object)1);
        eq.groupBy(MchChan::getMerchantsMark);
        List filterMchChan = this.mchChanMapper.selectList((Wrapper)eq);
        for (MchChan mchChan : filterMchChan) {
            WxPayBillResult wxPayBillResult = this.getBill(mchChan, billDate);
            if (Objects.isNull(wxPayBillResult)) continue;
            this.buildChannelBillAndSave(wxPayBillResult, billDate);
        }
    }

    public Boolean buildChannelBillAndSave(WxPayBillResult wxPayBillResult, String billDate) {
        if (Objects.isNull(wxPayBillResult)) {
            log.info("\u5fae\u4fe1\u8d26\u5355\u62c9\u53d6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u53ef\u80fd\u5fae\u4fe1\u65b9\u8d26\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        ArrayList<ChannelBill> list = new ArrayList<ChannelBill>();
        List wxPayBillInfoStream = wxPayBillResult.getBillInfoList().stream().filter(e -> this.filterBill(e.getAttach(), this.payEnvironment).getEnv()).collect(Collectors.toList());
        if (wxPayBillInfoStream.isEmpty()) {
            log.info("\u5fae\u4fe1\u62c9\u53d6\u8d26\u5355\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            return false;
        }
        for (WxPayBillInfo e2 : wxPayBillInfoStream) {
            log.info("WxPayBillInfo filter wxpaybillinfo={}", (Object)e2);
            String attach = e2.getAttach();
            BillFilter billFilter = this.filterBill(attach, this.payEnvironment);
            WxPayBillBO wxPayBillBO = new WxPayBillBO(e2);
            log.info("wxPayBillBO.buildChannelBillBO billDate={},applyCode={},ServiceCode={},PayType={}", new Object[]{billDate, billFilter.getApplyCode(), billFilter.getServiceCode(), billFilter.getPayType()});
            ChannelBillBO channelBillBO = wxPayBillBO.buildChannelBillBO(billDate, billFilter.getApplyCode(), billFilter.getServiceCode(), billFilter.getPayType());
            ChannelBill channelBill = new ChannelBill();
            BeanUtils.copyProperties((Object)channelBillBO, (Object)channelBill);
            log.info(" save channelBill data={}", (Object)channelBill);
            list.add(channelBill);
        }
        if (!list.isEmpty()) {
            this.channelBillMapper.insertList(list);
            return true;
        }
        return false;
    }

    public void savePlatformBill(String billDate) {
        DateCondition dateCondition = new DateCondition(billDate);
        List payBillList = this.payBillMapper.selectListByReconciliation(dateCondition.getStartTime(), dateCondition.getEndTime(), "WECHAT");
        ArrayList list = new ArrayList();
        payBillList.forEach(e -> {
            PlatformBillBO platformBillBO = new PlatformBillBO();
            platformBillBO.init(e, billDate);
            list.add(platformBillBO.getPlatformBill());
        });
        log.info("platformBill save list data={} ", list);
        this.insertPlatformBill(list);
    }

    public void reconciliationBill(String billDate, String batchNumber) {
        List allList = this.mchChanMapper.selectListByChanCode("WECHAT");
        allList.parallelStream().forEach(e -> {
            int errorCount = 0;
            List channelBillList = this.channelBillMapper.getByDateAndPayTypeAndMchCodeAndState(billDate, "WECHAT", e.getMchCode(), e.getType());
            List platformBillList = this.platformBillMapper.getByDateAndPayTypeAndMchCodeAndState(billDate, "WECHAT", e.getMchCode(), e.getType());
            this.reconciliationHandler(billDate, batchNumber, e, errorCount, channelBillList, platformBillList, "WECHAT");
        });
    }

    public WxPayBillResult getBill(MchChan mchChan, String billDate) {
        log.info("WeChat.getBill mchChan = {},applyCode-getBill={}", (Object)mchChan, (Object)mchChan.getMchCode());
        WxPayParam wxPayParam = (WxPayParam)JSONObject.parseObject((String)mchChan.getParam(), WxPayParam.class);
        String errorMsg = "";
        WxPayBillResult wxPayBillResult = null;
        WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
        this.getWxPayBillResult(wxPayService, wxPayParam);
        WxPayDownloadBillRequest request = new WxPayDownloadBillRequest();
        request.setBillDate(billDate);
        request.setBillType("ALL");
        int retry = 1;
        do {
            try {
                log.info("\u3010\u5fae\u4fe1\u3011\u4e0b\u8f7d\u8d26\u5355\u8bf7\u6c42\u53c2\u6570:{},retry:{}", (Object)request.toString(), (Object)retry);
                wxPayBillResult = wxPayService.downloadBill(request);
            }
            catch (WxPayException e) {
                log.error("\u3010\u5fae\u4fe1\u3011\u4e0b\u8f7d\u5fae\u4fe1\u4ed8\u8d26\u5355\u5f02\u5e38:{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getXmlString(), (Object)e.getReturnMsg());
                if ("No Bill Exist".equalsIgnoreCase(e.getReturnMsg()) || "invalid appid".equalsIgnoreCase(e.getReturnMsg())) break;
                errorMsg = e.getReturnMsg();
            }
        } while (Objects.isNull(wxPayBillResult) && retry++ < 5);
        if (Objects.isNull(wxPayBillResult) && StringUtils.isNotBlank((CharSequence)errorMsg)) {
            super.notifyErrorPush(mchChan, errorMsg);
        }
        log.info("{}-\u8d26\u5355\u4e0b\u8f7d\u6570\u636e\u4e3a:{}", (Object)mchChan.getMchCode(), (Object)wxPayBillResult);
        return wxPayBillResult;
    }

    private void getWxPayBillResult(WxPayService wxPayService, WxPayParam wxPayParam) {
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
            wxPayService.getConfig().setSubMchId(wxPayParam.getSubMchId());
        } else {
            wxPayService.getConfig().setSubMchId(null);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean reWriteBills(ReWriteBillVO reWriteBillVO) {
        super.reWriteBills(reWriteBillVO);
        List mchChans = this.mchChanMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MchChan::getChanCode, (Object)reWriteBillVO.getPlantform())).eq(MchChan::getMchCode, (Object)reWriteBillVO.getMchCode())).eq(BaseEntity::getStatus, (Object)1)).groupBy(MchChan::getMerchantsMark));
        if (mchChans.isEmpty()) {
            log.error("\u91cd\u65b0\u5bf9\u8d26\u672a\u67e5\u8be2\u5230\u5fae\u4fe1\u5546\u6237\u4fe1\u606f \u8bf7\u68c0\u67e5");
            return false;
        }
        for (MchChan mchChan : mchChans) {
            String billDate;
            WxPayBillResult wxPayBillResult = this.getBill(mchChan, billDate = reWriteBillVO.getBillDate());
            boolean b = this.buildChannelBillAndSave(wxPayBillResult, billDate);
            if (!b) continue;
            super.savePlatformBillByMchCode(reWriteBillVO);
            super.reconBillByMchChan(reWriteBillVO, mchChan.getMerchantsMark());
        }
        super.reconciSavePoly(reWriteBillVO);
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        ReconciliationTypeFactory.register((String)PayChanEnum.WECHAT.name(), (AReconciliationBill)this);
    }

    public WeChat(PayBillMapper payBillMapper, WxPayConfiguration wxPayConfiguration, PushInfoManage pushInfoManage) {
        this.payBillMapper = payBillMapper;
        this.wxPayConfiguration = wxPayConfiguration;
        this.pushInfoManage = pushInfoManage;
    }
}

