/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.transfer;

import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayOrderQueryResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayOrerQueryReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.BatchesTransferDetailReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.BatchesTransferDetailResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.PayBatchesTransferReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.PayBatchesTransferResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.TransferDetailReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.TransferDetailResp;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.service.transfer.AlipayTransferServiceImpl;
import com.ebaiyihui.aggregation.payment.server.service.transfer.ITransferService;
import com.ebaiyihui.aggregation.payment.server.service.transfer.TransferServiceImpl;
import com.ebaiyihui.aggregation.payment.server.service.transfer.WxPayServiceImpl;
import com.ebaiyihui.aggregation.payment.server.utils.SpringUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class TransferServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(TransferServiceImpl.class);

    private ITransferService getPayChannel(String payType) {
        PayChanEnum payChanEnum = PayChanEnum.getByDisplay((String)payType);
        switch (1.$SwitchMap$com$ebaiyihui$aggregation$payment$server$enums$PayChanEnum[payChanEnum.ordinal()]) {
            case 1: {
                return (ITransferService)SpringUtils.getBean(AlipayTransferServiceImpl.class);
            }
            case 2: {
                return (ITransferService)SpringUtils.getBean(WxPayServiceImpl.class);
            }
        }
        throw new IllegalArgumentException("\u652f\u4ed8\u6e20\u9053\u53c2\u6570\u9519\u8bef");
    }

    public BaseResponse<B2CPayResp> transfer(B2CPayReq b2CPayReq) {
        ITransferService payChannel = this.getPayChannel(b2CPayReq.getChanCode());
        return payChannel.B2Ctransfer(b2CPayReq);
    }

    public BaseResponse<B2CPayOrderQueryResp> transferOrderQuery(B2CPayOrerQueryReq req) {
        ITransferService payChannel = this.getPayChannel(req.getChanCode());
        return payChannel.transferBillQuery(req);
    }

    public BaseResponse<PayBatchesTransferResp> batchesTransfer(PayBatchesTransferReq req) {
        ITransferService payChannel = this.getPayChannel(req.getChanCode());
        return payChannel.batchesTransfer(req);
    }

    public BaseResponse<BatchesTransferDetailResp> batchesDetail(@RequestBody BatchesTransferDetailReq req) {
        ITransferService payChannel = this.getPayChannel(req.getChanCode());
        return payChannel.batchesDetail(req);
    }

    public BaseResponse<TransferDetailResp> detail(@RequestBody TransferDetailReq req) {
        ITransferService payChannel = this.getPayChannel(req.getChanCode());
        return payChannel.detail(req);
    }
}

