/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.unionpay.sdk;

import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.CertUtil;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.HttpClient;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.LogUtil;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.SDKUtil;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.SecureUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class AcpService {
    public static Map<String, String> sign(Map<String, String> reqData, String encoding) {
        reqData = SDKUtil.filterBlank(reqData);
        SDKUtil.sign((Map)reqData, (String)encoding);
        return reqData;
    }

    public static Map<String, String> sign(Map<String, String> reqData, String certPath, String certPwd, String encoding) {
        reqData = SDKUtil.filterBlank(reqData);
        SDKUtil.signByCertInfo((Map)reqData, (String)certPath, (String)certPwd, (String)encoding);
        return reqData;
    }

    public static Map<String, String> signByCertInfo(Map<String, String> reqData, String certPath, String certPwd, String encoding) {
        reqData = SDKUtil.filterBlank(reqData);
        SDKUtil.signByCertInfo((Map)reqData, (String)certPath, (String)certPwd, (String)encoding);
        return reqData;
    }

    public static Map<String, String> signBySecureKey(Map<String, String> reqData, String secureKey, String encoding) {
        reqData = SDKUtil.filterBlank(reqData);
        SDKUtil.signBySecureKey((Map)reqData, (String)secureKey, (String)encoding);
        return reqData;
    }

    public static boolean validate(Map<String, String> rspData, String encoding) {
        return SDKUtil.validate(rspData, (String)encoding);
    }

    public static boolean validateBySecureKey(Map<String, String> rspData, String secureKey, String encoding) {
        return SDKUtil.validateBySecureKey(rspData, (String)secureKey, (String)encoding);
    }

    public static boolean validateAppResponse(String jsonData, String encoding) {
        Pattern p;
        Matcher m;
        LogUtil.writeLog((String)("\u63a7\u4ef6\u5e94\u7b54\u4fe1\u606f\u9a8c\u7b7e\u5904\u7406\u5f00\u59cb\uff1a[" + jsonData + "]"));
        if (SDKUtil.isEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        if (!(m = (p = Pattern.compile("\\s*\"sign\"\\s*:\\s*\"([^\"]*)\"\\s*")).matcher(jsonData)).find()) {
            return false;
        }
        String sign = m.group(1);
        p = Pattern.compile("\\s*\"data\"\\s*:\\s*\"([^\"]*)\"\\s*");
        m = p.matcher(jsonData);
        if (!m.find()) {
            return false;
        }
        String data = m.group(1);
        p = Pattern.compile("cert_id=(\\d*)");
        m = p.matcher(jsonData);
        if (!m.find()) {
            return false;
        }
        String certId = m.group(1);
        try {
            return SecureUtil.validateSignBySoft((PublicKey)CertUtil.getValidatePublicKey((String)certId), (byte[])SecureUtil.base64Decode((byte[])sign.getBytes(encoding)), (byte[])SecureUtil.sha1X16((String)data, (String)encoding));
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static Map<String, String> post(Map<String, String> reqData, String reqUrl, String encoding) {
        HashMap<String, String> rspData = new HashMap<String, String>();
        LogUtil.writeLog((String)("\u8bf7\u6c42\u94f6\u8054\u5730\u5740:" + reqUrl));
        HttpClient hc = new HttpClient(reqUrl, 30000, 30000);
        try {
            int status = hc.send(reqData, encoding);
            if (200 == status) {
                String resultString = hc.getResult();
                if (null != resultString && !"".equals(resultString)) {
                    Map tmpRspData = SDKUtil.convertResultStringToMap((String)resultString);
                    rspData.putAll(tmpRspData);
                }
            } else {
                LogUtil.writeLog((String)("\u8fd4\u56dehttp\u72b6\u6001\u7801[" + status + "]\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u62a5\u6587\u6216\u8005\u8bf7\u6c42\u5730\u5740\u662f\u5426\u6b63\u786e"));
            }
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return rspData;
    }

    public static String get(String reqUrl, String encoding) {
        LogUtil.writeLog((String)("\u8bf7\u6c42\u94f6\u8054\u5730\u5740:" + reqUrl));
        HttpClient hc = new HttpClient(reqUrl, 30000, 30000);
        try {
            int status = hc.sendGet(encoding);
            if (200 == status) {
                String resultString = hc.getResult();
                if (null != resultString && !"".equals(resultString)) {
                    return resultString;
                }
            } else {
                LogUtil.writeLog((String)("\u8fd4\u56dehttp\u72b6\u6001\u7801[" + status + "]\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u62a5\u6587\u6216\u8005\u8bf7\u6c42\u5730\u5740\u662f\u5426\u6b63\u786e"));
            }
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String createAutoFormHtml(String reqUrl, Map<String, String> hiddens, String encoding) {
        StringBuffer sf = new StringBuffer();
        sf.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/></head><body>");
        sf.append("<form id = \"pay_form\" action=\"" + reqUrl + "\" method=\"post\">");
        if (null != hiddens && 0 != hiddens.size()) {
            Set<Map.Entry<String, String>> set = hiddens.entrySet();
            for (Map.Entry<String, String> ey : set) {
                String key = ey.getKey();
                String value = ey.getValue();
                sf.append("<input type=\"hidden\" name=\"" + key + "\" id=\"" + key + "\" value=\"" + value + "\"/>");
            }
        }
        sf.append("</form>");
        sf.append("</body>");
        sf.append("<script type=\"text/javascript\">");
        sf.append("document.all.pay_form.submit();");
        sf.append("</script>");
        sf.append("</html>");
        return sf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String enCodeFileContent(String filePath, String encoding) {
        String baseFileContent = "";
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
            }
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            int fl = ((InputStream)in).available();
            if (null != in) {
                byte[] s = new byte[fl];
                ((InputStream)in).read(s, 0, fl);
                baseFileContent = new String(SecureUtil.base64Encode((byte[])SDKUtil.deflater((byte[])s)), encoding);
            }
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
                }
            }
        }
        return baseFileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deCodeFileContent(Map<String, String> resData, String fileDirectory, String encoding) {
        String filePath = null;
        String fileContent = resData.get("fileContent");
        if (null != fileContent && !"".equals(fileContent)) {
            FileOutputStream out = null;
            try {
                byte[] fileArray = SDKUtil.inflater((byte[])SecureUtil.base64Decode((byte[])fileContent.getBytes(encoding)));
                filePath = SDKUtil.isEmpty((String)resData.get("fileName")) ? fileDirectory + File.separator + resData.get("merId") + "_" + resData.get("batchNo") + "_" + resData.get("txnTime") + ".txt" : fileDirectory + File.separator + resData.get("fileName");
                File file = new File(filePath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                out = new FileOutputStream(file);
                out.write(fileArray, 0, fileArray.length);
                out.flush();
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return filePath;
    }

    public static String getFileContent(String fileContent, String encoding) {
        String fc = "";
        try {
            fc = new String(SDKUtil.inflater((byte[])SecureUtil.base64Decode((byte[])fileContent.getBytes())), encoding);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return fc;
    }

    public static String getCustomerInfo(Map<String, String> customerInfoMap, String accNo, String encoding) {
        if (customerInfoMap.isEmpty()) {
            return "{}";
        }
        StringBuffer sf = new StringBuffer("{");
        Iterator<String> it = customerInfoMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = customerInfoMap.get(key);
            if (key.equals("pin")) {
                if (null == accNo || "".equals(accNo.trim())) {
                    LogUtil.writeLog((String)"\u9001\u4e86\u5bc6\u7801\uff08PIN\uff09\uff0c\u5fc5\u987b\u5728getCustomerInfo\u53c2\u6570\u4e2d\u4e0a\u4f20\u5361\u53f7");
                    throw new RuntimeException("\u52a0\u5bc6PIN\u6ca1\u9001\u5361\u53f7\u65e0\u6cd5\u540e\u7eed\u5904\u7406");
                }
                value = AcpService.encryptPin((String)accNo, (String)value, (String)encoding);
            }
            sf.append(key).append("=").append(value);
            if (!it.hasNext()) continue;
            sf.append("&");
        }
        String customerInfo = sf.append("}").toString();
        LogUtil.writeLog((String)("\u7ec4\u88c5\u7684customerInfo\u660e\u6587\uff1a" + customerInfo));
        try {
            return new String(SecureUtil.base64Encode((byte[])sf.toString().getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return customerInfo;
    }

    public static String getCustomerInfoWithEncrypt(Map<String, String> customerInfoMap, String accNo, String encoding) {
        if (customerInfoMap.isEmpty()) {
            return "{}";
        }
        StringBuffer sf = new StringBuffer("{");
        StringBuffer encryptedInfoSb = new StringBuffer("");
        for (String key : customerInfoMap.keySet()) {
            String value = customerInfoMap.get(key);
            if (key.equals("phoneNo") || key.equals("cvn2") || key.equals("expired")) {
                encryptedInfoSb.append(key).append("=").append(value).append("&");
                continue;
            }
            if (key.equals("pin")) {
                if (null == accNo || "".equals(accNo.trim())) {
                    LogUtil.writeLog((String)"\u9001\u4e86\u5bc6\u7801\uff08PIN\uff09\uff0c\u5fc5\u987b\u5728getCustomerInfoWithEncrypt\u53c2\u6570\u4e2d\u4e0a\u4f20\u5361\u53f7");
                    throw new RuntimeException("\u52a0\u5bc6PIN\u6ca1\u9001\u5361\u53f7\u65e0\u6cd5\u540e\u7eed\u5904\u7406");
                }
                value = AcpService.encryptPin((String)accNo, (String)value, (String)encoding);
            }
            sf.append(key).append("=").append(value).append("&");
        }
        if (!encryptedInfoSb.toString().equals("")) {
            encryptedInfoSb.setLength(encryptedInfoSb.length() - 1);
            LogUtil.writeLog((String)("\u7ec4\u88c5\u7684customerInfo encryptedInfo\u660e\u6587\uff1a" + encryptedInfoSb.toString()));
            sf.append("encryptedInfo").append("=").append(AcpService.encryptData((String)encryptedInfoSb.toString(), (String)encoding));
        } else {
            sf.setLength(sf.length() - 1);
        }
        String customerInfo = sf.append("}").toString();
        LogUtil.writeLog((String)("\u7ec4\u88c5\u7684customerInfo\u660e\u6587\uff1a" + customerInfo));
        try {
            return new String(SecureUtil.base64Encode((byte[])sf.toString().getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return customerInfo;
    }

    public static Map<String, String> parseCustomerInfo(String customerInfo, String encoding) {
        Map customerInfoMap = null;
        try {
            byte[] b = SecureUtil.base64Decode((byte[])customerInfo.getBytes(encoding));
            String customerInfoNoBase64 = new String(b, encoding);
            LogUtil.writeLog((String)("\u89e3base64\u540e===>" + customerInfoNoBase64));
            customerInfoNoBase64 = customerInfoNoBase64.substring(1, customerInfoNoBase64.length() - 1);
            customerInfoMap = SDKUtil.parseQString((String)customerInfoNoBase64);
            if (customerInfoMap.containsKey("encryptedInfo")) {
                String encInfoStr = (String)customerInfoMap.get("encryptedInfo");
                customerInfoMap.remove("encryptedInfo");
                String encryptedInfoStr = AcpService.decryptData((String)encInfoStr, (String)encoding);
                Map encryptedInfoMap = SDKUtil.parseQString((String)encryptedInfoStr);
                customerInfoMap.putAll(encryptedInfoMap);
            }
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return customerInfoMap;
    }

    public static Map<String, String> parseCustomerInfo(String customerInfo, String certPath, String certPwd, String encoding) {
        Map customerInfoMap = null;
        try {
            byte[] b = SecureUtil.base64Decode((byte[])customerInfo.getBytes(encoding));
            String customerInfoNoBase64 = new String(b, encoding);
            LogUtil.writeLog((String)("\u89e3base64\u540e===>" + customerInfoNoBase64));
            customerInfoNoBase64 = customerInfoNoBase64.substring(1, customerInfoNoBase64.length() - 1);
            customerInfoMap = SDKUtil.parseQString((String)customerInfoNoBase64);
            if (customerInfoMap.containsKey("encryptedInfo")) {
                String encInfoStr = (String)customerInfoMap.get("encryptedInfo");
                customerInfoMap.remove("encryptedInfo");
                String encryptedInfoStr = AcpService.decryptData((String)encInfoStr, (String)certPath, (String)certPwd, (String)encoding);
                Map encryptedInfoMap = SDKUtil.parseQString((String)encryptedInfoStr);
                customerInfoMap.putAll(encryptedInfoMap);
            }
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return customerInfoMap;
    }

    public static String encryptPin(String accNo, String pin, String encoding) {
        return SecureUtil.encryptPin((String)accNo, (String)pin, (String)encoding, (PublicKey)CertUtil.getEncryptCertPublicKey());
    }

    public static String encryptData(String data, String encoding) {
        return SecureUtil.encryptData((String)data, (String)encoding, (PublicKey)CertUtil.getEncryptCertPublicKey());
    }

    public static String decryptData(String base64EncryptedInfo, String encoding) {
        return SecureUtil.decryptData((String)base64EncryptedInfo, (String)encoding, (PrivateKey)CertUtil.getSignCertPrivateKey());
    }

    public static String decryptData(String base64EncryptedInfo, String certPath, String certPwd, String encoding) {
        return SecureUtil.decryptData((String)base64EncryptedInfo, (String)encoding, (PrivateKey)CertUtil.getSignCertPrivateKeyByStoreMap((String)certPath, (String)certPwd));
    }

    public static String encryptTrack(String trackData, String encoding) {
        return SecureUtil.encryptData((String)trackData, (String)encoding, (PublicKey)CertUtil.getEncryptTrackPublicKey());
    }

    public static String getEncryptCertId() {
        return CertUtil.getEncryptCertId();
    }

    public static String base64Encode(String rawStr, String encoding) throws IOException {
        byte[] rawByte = rawStr.getBytes(encoding);
        return new String(SecureUtil.base64Encode((byte[])rawByte), encoding);
    }

    public static String base64Decode(String base64Str, String encoding) throws IOException {
        byte[] rawByte = base64Str.getBytes(encoding);
        return new String(SecureUtil.base64Decode((byte[])rawByte), encoding);
    }

    public static String getCardTransData(Map<String, String> cardTransDataMap, Map<String, String> requestData, String encoding) {
        StringBuffer cardTransDataBuffer = new StringBuffer();
        if (cardTransDataMap.containsKey("track2Data")) {
            StringBuffer track2Buffer = new StringBuffer();
            track2Buffer.append(requestData.get("merId")).append("|").append(requestData.get("orderId")).append("|").append(requestData.get("txnTime")).append("|").append(requestData.get("txnAmt") == null ? Integer.valueOf(0) : (Serializable)((Object)requestData.get("txnAmt"))).append("|").append(cardTransDataMap.get("track2Data"));
            cardTransDataMap.put("track2Data", AcpService.encryptData((String)track2Buffer.toString(), (String)encoding));
        }
        if (cardTransDataMap.containsKey("track3Data")) {
            StringBuffer track3Buffer = new StringBuffer();
            track3Buffer.append(requestData.get("merId")).append("|").append(requestData.get("orderId")).append("|").append(requestData.get("txnTime")).append("|").append(requestData.get("txnAmt") == null ? Integer.valueOf(0) : (Serializable)((Object)requestData.get("txnAmt"))).append("|").append(cardTransDataMap.get("track3Data"));
            cardTransDataMap.put("track3Data", AcpService.encryptData((String)track3Buffer.toString(), (String)encoding));
        }
        return cardTransDataBuffer.append("{").append(SDKUtil.coverMap2String(cardTransDataMap)).append("}").toString();
    }

    public static int updateEncryptCert(Map<String, String> resData, String encoding) {
        return SDKUtil.getEncryptCert(resData, (String)encoding);
    }

    public static int genLuhn(String number) {
        return SecureUtil.genLuhn((String)number);
    }
}

