/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.present;

import android.content.Context;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.IVerHospitalListView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.RegionCtitiesEntity;
import com.kangxin.common.byh.entity.VerHospitalListEntity;
import com.kangxin.common.byh.module.IGionCitiesModule;
import com.kangxin.common.byh.module.impl.GionCitiesModule;
import com.kangxin.common.rx.ProgressDialogObserver;
import io.reactivex.Observer;

public class VerHospitalListPresent {
    private VerLoginModule mLoginModule;
    private IVerHospitalListView verHospitalListView;
    private IGionCitiesModule mCitiesModule;

    public VerHospitalListPresent(IVerHospitalListView verHospitalListView) {
        this.verHospitalListView = verHospitalListView;
        this.mLoginModule = new VerLoginModule();
        this.mCitiesModule = new GionCitiesModule();
    }

    public void reqHospitalList(Long doctorId, Integer page, Integer size, String searchParam, String distCode) {
        this.mLoginModule.getVerHospitalList(doctorId, page, size, searchParam, distCode).subscribe((Observer)new ProgressDialogObserver<ResponseBody<VerHospitalListEntity>>(){

            public void onNext(ResponseBody<VerHospitalListEntity> hospitalListEntityResponseBody) {
                if (hospitalListEntityResponseBody.getCode() != 200) {
                    VerHospitalListPresent.this.verHospitalListView.error(hospitalListEntityResponseBody.getMsg());
                    return;
                }
                VerHospitalListPresent.this.verHospitalListView.showHospitalList(hospitalListEntityResponseBody);
            }

            protected Context attachContext() {
                return VerHospitalListPresent.this.verHospitalListView.injectContext();
            }
        });
    }

    public void getRegioCities(String fileName) {
        this.mCitiesModule.getRegioCities(fileName).subscribe((Observer)new ProgressDialogObserver<RegionCtitiesEntity>(){

            public void onNext(RegionCtitiesEntity regionCtitiesEntity) {
                if (regionCtitiesEntity.getCode() != 200) {
                    VerHospitalListPresent.this.verHospitalListView.error(regionCtitiesEntity.getMsg());
                    return;
                }
                VerHospitalListPresent.this.verHospitalListView.showCities(regionCtitiesEntity.getResult());
            }

            protected Context attachContext() {
                return VerHospitalListPresent.this.verHospitalListView.injectContext();
            }
        });
    }
}

