/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.res.ResourcesCompat;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.module.verlogin.ForgetPassWordActivity;
import com.byh.module.verlogin.LoginActivity;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.entity.VerCodeEntity;
import com.byh.module.verlogin.event.vertify.LoginDispatchStatus;
import com.byh.module.verlogin.event.vertify.LoginStatusManager;
import com.byh.module.verlogin.present.VerLoginPresent;
import com.byh.module.verlogin.view.ILoginView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.widget.ZpPhoneEditText;
import com.kangxin.common.past.AppManager;
import com.kangxin.common.util.VerifyUtil;
import com.tbruyelle.rxpermissions.RxPermissions;
import info.cd120.module_push.PushManager;
import rx.functions.Action1;

public class PwdLoginActivity
extends BaseActivity
implements ILoginView {
    private String TAG = "PwdLoginActivity";
    private ImageView mPwdShowImg;
    private EditText mVerPwdEdt;
    private ImageView mClosePhoneNumImg;
    private ZpPhoneEditText mPhoneNumEdt;
    private Button mLoginBtn;
    private TextView mErrNoticeText;
    private VerLoginPresent mLoginPresent;
    private TextView mForgetPwdText;
    private static final String DEVICE_ID_SP_KEY = "umeng_device_id_sp_key";

    public void start() {
        this.mLoginPresent = new VerLoginPresent(this);
        this.findViewById(R.id.img_back_ver).setOnClickListener(view -> this.finish());
        this.findViewById(R.id.login_question).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ARouter.getInstance().build("/minecontact/ContactUsActivity").navigation();
            }
        });
        this.mPwdShowImg = (ImageView)this.findViewById(R.id.img_pwd_kejian);
        this.mVerPwdEdt = (EditText)this.findViewById(R.id.ver_pwd_edt);
        this.mClosePhoneNumImg = (ImageView)this.findViewById(R.id.clearlogin_img);
        this.mPhoneNumEdt = (ZpPhoneEditText)this.findViewById(R.id.edt_phonenum);
        this.mLoginBtn = (Button)this.findViewById(R.id.login_btn);
        this.mErrNoticeText = (TextView)this.findViewById(R.id.err_notice);
        this.mForgetPwdText = (TextView)this.findViewById(R.id.forget_pwd_tv);
        this.mLoginBtn.setClickable(false);
        this.mClosePhoneNumImg.setOnClickListener(view -> this.mPhoneNumEdt.setText((CharSequence)""));
        this.addEdtChangeListener();
        int type = 129;
        this.mPwdShowImg.setOnClickListener(view -> {
            if (this.mVerPwdEdt.getInputType() == 129) {
                this.mVerPwdEdt.setInputType(144);
                this.mVerPwdEdt.setSelection(this.mVerPwdEdt.getText().length());
                this.mPwdShowImg.setImageResource(R.drawable.ic_ver_kejian);
            } else {
                this.mVerPwdEdt.setInputType(129);
                this.mVerPwdEdt.setSelection(this.mVerPwdEdt.getText().length());
                this.mPwdShowImg.setImageResource(R.drawable.ic_bukejian);
            }
        });
        this.mForgetPwdText.setOnClickListener(v -> {
            String phoneNum = this.mPhoneNumEdt.getPhoneText();
            if (TextUtils.isEmpty((CharSequence)phoneNum)) {
                this.showShortToast("\u8bf7\u8f93\u5165\u624b\u673a\u53f7");
                return;
            }
            if (!VerifyUtil.isMobilePhoneNumber((String)phoneNum)) {
                this.showShortToast(this.getResources().getString(R.string.forget_phone_error_tips));
                return;
            }
            Intent intentFPwd = new Intent(this.getMContext(), ForgetPassWordActivity.class);
            intentFPwd.putExtra("phoneNum", phoneNum);
            this.startActivity(intentFPwd);
        });
    }

    private void addEdtChangeListener() {
        this.mPhoneNumEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                PwdLoginActivity.this.setLoginBtnUseable();
                PwdLoginActivity.this.mErrNoticeText.setVisibility(8);
                if (editable.length() != 0) {
                    PwdLoginActivity.this.mClosePhoneNumImg.setVisibility(0);
                } else {
                    PwdLoginActivity.this.mClosePhoneNumImg.setVisibility(8);
                }
            }
        });
        this.mVerPwdEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                PwdLoginActivity.this.setLoginBtnUseable();
                PwdLoginActivity.this.mErrNoticeText.setVisibility(8);
                if (editable.length() != 0) {
                    PwdLoginActivity.this.mPwdShowImg.setVisibility(0);
                } else {
                    PwdLoginActivity.this.mPwdShowImg.setVisibility(8);
                }
            }
        });
    }

    private void setLoginBtnUseable() {
        String phoneNum = this.mPhoneNumEdt.getPhoneText();
        String pwdNum = this.mVerPwdEdt.getText().toString().trim();
        if (!TextUtils.isEmpty((CharSequence)phoneNum) && !TextUtils.isEmpty((CharSequence)pwdNum)) {
            this.mLoginBtn.setClickable(true);
            this.mLoginBtn.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.vercode_order_bg, null));
        } else {
            this.mLoginBtn.setClickable(false);
            this.mLoginBtn.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.gray_button_background, null));
        }
    }

    public int getContentLayoutId() {
        return R.layout.verpwd_login_activity;
    }

    public void clickLogin(View view) {
        RxPermissions.getInstance((Context)this.getBaseContext()).request(new String[]{"android.permission.READ_PHONE_STATE"}).subscribe((Action1)new Action1<Boolean>(){

            public void call(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    String phoneNum = PwdLoginActivity.this.mPhoneNumEdt.getPhoneText();
                    String pwd = PwdLoginActivity.this.mVerPwdEdt.getText().toString().trim();
                    String loginDeviceNum = PushManager.getDeviceId((Context)PwdLoginActivity.this.mContext);
                    Login login2 = new Login(phoneNum, pwd);
                    login2.setLoginDeviceNum(loginDeviceNum);
                    PwdLoginActivity.this.mLoginPresent.loginApp(PwdLoginActivity.this.getBaseContext(), login2);
                }
            }
        });
    }

    @Override
    public void loginOk(ResponseBody<LoginSuccess> loginSuccess) {
        Log.i((String)this.TAG, (String)("loginOk===>>" + loginSuccess));
        AppManager.getAppManager().finishActivity(PwdLoginActivity.class);
        AppManager.getAppManager().finishActivity(LoginActivity.class);
        this.receiveStatus(((LoginSuccess)loginSuccess.getResult()).getAccountStatus());
    }

    private void receiveStatus(int status) {
        LoginDispatchStatus loginDispatchStatus = new LoginDispatchStatus();
        loginDispatchStatus.registerStatus(new LoginStatusManager((Activity)this));
        loginDispatchStatus.dispatchStatus(status);
    }

    @Override
    public void reqErr(String err) {
        Log.i((String)this.TAG, (String)("reqErr==>>" + err));
        this.mErrNoticeText.setVisibility(0);
        this.mErrNoticeText.setText((CharSequence)err);
    }

    @Override
    public void receiveVercode(VerCodeEntity verCode) {
    }

    @Override
    public void setPwdOk(String msg) {
    }
}

