/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicarecore.util.tool.wx;

import com.ebaiyihui.medicarecore.util.tool.wx.WXPayConfig;
import com.ebaiyihui.medicarecore.util.tool.wx.WXPayConstants;
import com.ebaiyihui.medicarecore.util.tool.wx.WXPayRequest;
import com.ebaiyihui.medicarecore.util.tool.wx.WXPayUtil;
import java.util.HashMap;
import java.util.Map;

public class WXPay {
    private WXPayConfig config;
    private WXPayConstants.SignType signType;
    private boolean autoReport;
    private boolean useSandbox;
    private String notifyUrl;
    private WXPayRequest wxPayRequest;

    public WXPay(WXPayConfig config) throws Exception {
        this(config, null, true, false);
    }

    public WXPay(WXPayConfig config, boolean autoReport) throws Exception {
        this(config, null, autoReport, false);
    }

    public WXPay(WXPayConfig config, boolean autoReport, boolean useSandbox) throws Exception {
        this(config, null, autoReport, useSandbox);
    }

    public WXPay(WXPayConfig config, String notifyUrl) throws Exception {
        this(config, notifyUrl, true, false);
    }

    public WXPay(WXPayConfig config, String notifyUrl, boolean autoReport) throws Exception {
        this(config, notifyUrl, autoReport, false);
    }

    public WXPay(WXPayConfig config, String notifyUrl, boolean autoReport, boolean useSandbox) throws Exception {
        this.config = config;
        this.notifyUrl = notifyUrl;
        this.autoReport = autoReport;
        this.useSandbox = useSandbox;
        this.signType = useSandbox ? WXPayConstants.SignType.MD5 : WXPayConstants.SignType.HMACSHA256;
        this.wxPayRequest = new WXPayRequest(config);
    }

    private void checkWXPayConfig() throws Exception {
        if (this.config == null) {
            throw new Exception("config is null");
        }
        if (this.config.getAppID() == null || this.config.getAppID().trim().length() == 0) {
            throw new Exception("appid in config is empty");
        }
        if (this.config.getMchID() == null || this.config.getMchID().trim().length() == 0) {
            throw new Exception("appid in config is empty");
        }
        if (this.config.getCertStream() == null) {
            throw new Exception("cert stream in config is empty");
        }
        if (this.config.getWXPayDomain() == null) {
            throw new Exception("config.getWXPayDomain() is null");
        }
        if (this.config.getHttpConnectTimeoutMs() < 10) {
            throw new Exception("http connect timeout is too small");
        }
        if (this.config.getHttpReadTimeoutMs() < 10) {
            throw new Exception("http read timeout is too small");
        }
    }

    public Map<String, String> fillRequestData(Map<String, String> reqData) throws Exception {
        reqData.put("appid", this.config.getAppID());
        reqData.put("mch_id", this.config.getMchID());
        reqData.put("nonce_str", WXPayUtil.generateNonceStr());
        if (WXPayConstants.SignType.MD5.equals((Object)this.signType)) {
            reqData.put("sign_type", "MD5");
        } else if (WXPayConstants.SignType.HMACSHA256.equals((Object)this.signType)) {
            reqData.put("sign_type", "HMAC-SHA256");
        }
        reqData.put("sign", WXPayUtil.generateSignature(reqData, (String)this.config.getKey(), (WXPayConstants.SignType)this.signType));
        return reqData;
    }

    public boolean isResponseSignatureValid(Map<String, String> reqData) throws Exception {
        return WXPayUtil.isSignatureValid(reqData, (String)this.config.getKey(), (WXPayConstants.SignType)this.signType);
    }

    public boolean isPayResultNotifySignatureValid(Map<String, String> reqData) throws Exception {
        WXPayConstants.SignType signType;
        String signTypeInData = reqData.get("sign_type");
        if (signTypeInData == null) {
            signType = WXPayConstants.SignType.MD5;
        } else if ((signTypeInData = signTypeInData.trim()).length() == 0) {
            signType = WXPayConstants.SignType.MD5;
        } else if ("MD5".equals(signTypeInData)) {
            signType = WXPayConstants.SignType.MD5;
        } else if ("HMAC-SHA256".equals(signTypeInData)) {
            signType = WXPayConstants.SignType.HMACSHA256;
        } else {
            throw new Exception(String.format("Unsupported sign_type: %s", signTypeInData));
        }
        return WXPayUtil.isSignatureValid(reqData, (String)this.config.getKey(), (WXPayConstants.SignType)signType);
    }

    public String requestWithoutCert(String urlSuffix, Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String msgUUID = reqData.get("nonce_str");
        String reqBody = WXPayUtil.mapToXml(reqData);
        String resp = this.wxPayRequest.requestWithoutCert(urlSuffix, msgUUID, reqBody, connectTimeoutMs, readTimeoutMs, this.autoReport);
        return resp;
    }

    public String requestWithCert(String urlSuffix, Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String msgUUID = reqData.get("nonce_str");
        String reqBody = WXPayUtil.mapToXml(reqData);
        String resp = this.wxPayRequest.requestWithCert(urlSuffix, msgUUID, reqBody, connectTimeoutMs, readTimeoutMs, this.autoReport);
        return resp;
    }

    public Map<String, String> processResponseXml(String xmlStr) throws Exception {
        String RETURN_CODE = "return_code";
        Map respData = WXPayUtil.xmlToMap((String)xmlStr);
        if (!respData.containsKey(RETURN_CODE)) {
            throw new Exception(String.format("No `return_code` in XML: %s", xmlStr));
        }
        String return_code = (String)respData.get(RETURN_CODE);
        if (return_code.equals("FAIL")) {
            return respData;
        }
        if (return_code.equals("SUCCESS")) {
            if (this.isResponseSignatureValid(respData)) {
                return respData;
            }
            throw new Exception(String.format("Invalid sign value in XML: %s", xmlStr));
        }
        throw new Exception(String.format("return_code value %s is invalid in XML: %s", return_code, xmlStr));
    }

    public Map<String, String> microPay(Map<String, String> reqData) throws Exception {
        return this.microPay(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> microPay(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String url = this.useSandbox ? "/sandboxnew/pay/micropay" : "/pay/micropay";
        String respXml = this.requestWithoutCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs);
        return this.processResponseXml(respXml);
    }

    public Map<String, String> microPayWithPos(Map<String, String> reqData) throws Exception {
        return this.microPayWithPos(reqData, this.config.getHttpConnectTimeoutMs());
    }

    public Map<String, String> microPayWithPos(Map<String, String> reqData, int connectTimeoutMs) throws Exception {
        int remainingTimeMs = 60000;
        long startTimestampMs = 0L;
        Map lastResult = null;
        Exception lastException = null;
        while (true) {
            startTimestampMs = WXPayUtil.getCurrentTimestampMs();
            int readTimeoutMs = remainingTimeMs - connectTimeoutMs;
            if (readTimeoutMs <= 1000) break;
            try {
                lastResult = this.microPay(reqData, connectTimeoutMs, readTimeoutMs);
                String returnCode = (String)lastResult.get("return_code");
                if (!returnCode.equals("SUCCESS")) break;
                String resultCode = (String)lastResult.get("result_code");
                String errCode = (String)lastResult.get("err_code");
                if (resultCode.equals("SUCCESS") || !errCode.equals("SYSTEMERROR") && !errCode.equals("BANKERROR") && !errCode.equals("USERPAYING") || (remainingTimeMs -= (int)(WXPayUtil.getCurrentTimestampMs() - startTimestampMs)) <= 100) break;
                WXPayUtil.getLogger().info("microPayWithPos: try micropay again");
                if (remainingTimeMs > 5000) {
                    Thread.sleep(5000L);
                    continue;
                }
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                lastResult = null;
                lastException = ex;
            }
        }
        if (lastResult == null) {
            throw lastException;
        }
        return lastResult;
    }

    public Map<String, String> unifiedOrder(Map<String, String> reqData) throws Exception {
        return this.unifiedOrder(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> unifiedOrder(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String url = this.useSandbox ? "/sandboxnew/pay/unifiedorder" : "/pay/unifiedorder";
        if (this.notifyUrl != null) {
            reqData.put("notify_url", this.notifyUrl);
        }
        String respXml = this.requestWithoutCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs);
        return this.processResponseXml(respXml);
    }

    public Map<String, String> orderQuery(Map<String, String> reqData) throws Exception {
        return this.orderQuery(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> orderQuery(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String url = this.useSandbox ? "/sandboxnew/pay/orderquery" : "/pay/orderquery";
        String respXml = this.requestWithoutCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs);
        return this.processResponseXml(respXml);
    }

    public Map<String, String> reverse(Map<String, String> reqData) throws Exception {
        return this.reverse(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> reverse(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String url = this.useSandbox ? "/sandboxnew/secapi/pay/reverse" : "/secapi/pay/reverse";
        String respXml = this.requestWithCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs);
        return this.processResponseXml(respXml);
    }

    public Map<String, String> closeOrder(Map<String, String> reqData) throws Exception {
        return this.closeOrder(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> closeOrder(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String url = this.useSandbox ? "/sandboxnew/pay/closeorder" : "/pay/closeorder";
        String respXml = this.requestWithoutCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs);
        return this.processResponseXml(respXml);
    }

    public Map<String, String> refund(Map<String, String> reqData) throws Exception {
        return this.refund(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> refund(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String url = this.useSandbox ? "/sandboxnew/secapi/pay/refund" : "/secapi/pay/refund";
        String respXml = this.requestWithCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs);
        return this.processResponseXml(respXml);
    }

    public Map<String, String> refundQuery(Map<String, String> reqData) throws Exception {
        return this.refundQuery(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> refundQuery(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String url = this.useSandbox ? "/sandboxnew/pay/refundquery" : "/pay/refundquery";
        String respXml = this.requestWithoutCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs);
        return this.processResponseXml(respXml);
    }

    public Map<String, String> downloadBill(Map<String, String> reqData) throws Exception {
        return this.downloadBill(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> downloadBill(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        HashMap<String, String> ret;
        String url = this.useSandbox ? "/sandboxnew/pay/downloadbill" : "/pay/downloadbill";
        String respStr = this.requestWithoutCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs).trim();
        if (respStr.indexOf("<") == 0) {
            ret = WXPayUtil.xmlToMap((String)respStr);
        } else {
            ret = new HashMap<String, String>();
            ret.put("return_code", "SUCCESS");
            ret.put("return_msg", "ok");
            ret.put("data", respStr);
        }
        return ret;
    }

    public Map<String, String> report(Map<String, String> reqData) throws Exception {
        return this.report(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> report(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String url = this.useSandbox ? "/sandboxnew/payitil/report" : "/payitil/report";
        String respXml = this.requestWithoutCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs);
        return WXPayUtil.xmlToMap((String)respXml);
    }

    public Map<String, String> shortUrl(Map<String, String> reqData) throws Exception {
        return this.shortUrl(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> shortUrl(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String url = this.useSandbox ? "/sandboxnew/tools/shorturl" : "/tools/shorturl";
        String respXml = this.requestWithoutCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs);
        return this.processResponseXml(respXml);
    }

    public Map<String, String> authCodeToOpenid(Map<String, String> reqData) throws Exception {
        return this.authCodeToOpenid(reqData, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs());
    }

    public Map<String, String> authCodeToOpenid(Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String url = this.useSandbox ? "/sandboxnew/tools/authcodetoopenid" : "/tools/authcodetoopenid";
        String respXml = this.requestWithoutCert(url, this.fillRequestData(reqData), connectTimeoutMs, readTimeoutMs);
        return this.processResponseXml(respXml);
    }
}

