/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicarecore.ybBusiness.service.gz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.medicarecore.util.tool.JsonPropertyFilter;
import com.ebaiyihui.medicarecore.util.tool.StringUtils;
import com.ebaiyihui.medicarecore.ybBusiness.common.YbCommitUtil;
import com.ebaiyihui.medicarecore.ybBusiness.domain.ResultResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.YbConfigEntity;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.request.PayAuthNoRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.request.UndoOrderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.request.YdCreadOrderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.request.YdOrderPayRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.request.YdPatientInfoRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.request.YdQueryOrderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.request.YdRefundOrderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.response.PayAuthNoResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.response.YdBaseResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.response.YdCreadOrderResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.response.YdOrderPayResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.response.YdReundOrderResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.PatientInfoRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.YbPatientInfoResponse;
import com.ebaiyihui.medicarecore.ybBusiness.mapper.YbConfigMapper;
import com.ebaiyihui.medicarecore.ybBusiness.service.databsase.YdMedicalDataBaseService;
import com.ebaiyihui.medicarecore.ybBusiness.service.gz.YdMedicalBusinessService;
import java.util.Collection;
import java.util.Objects;
import org.apache.cxf.common.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YdMedicalBusinessServiceImpl
implements YdMedicalBusinessService {
    @Autowired
    private YbConfigMapper ybConfigMapper;
    @Autowired
    private YdMedicalDataBaseService ydMedicalDataBaseService;
    public static final String SUCCESS_CODE = "0000";

    public ResultResponse<YbConfigEntity> getYbConfig(String orgCode) {
        YbConfigEntity ybConfigEntity = (YbConfigEntity)this.ybConfigMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"organ_code", (Object)orgCode));
        if (Objects.isNull(ybConfigEntity)) {
            return ResultResponse.error((String)"\u83b7\u53d6\u533b\u4fdd\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        return ResultResponse.success((Object)ybConfigEntity);
    }

    public ResultResponse<YdBaseResponse<PayAuthNoResponse>> payAuthNo(PayAuthNoRequest payAuthNoRequest) {
        ResultResponse ybConfigResponse = this.getYbConfig(payAuthNoRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        SimplePropertyPreFilter filter = new SimplePropertyPreFilter(new String[0]);
        filter.getExcludes().add("idCard");
        filter.getExcludes().add("cardNo");
        filter.getExcludes().add("businessId");
        YdBaseResponse ybBaseResponse = new YbCommitUtil().commitYbInfo((YbConfigEntity)ybConfigResponse.getBody(), JSON.toJSONString((Object)payAuthNoRequest, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]), PayAuthNoResponse.class, "getWxPayAuthNo");
        if (!SUCCESS_CODE.equals(ybBaseResponse.getCode())) {
            if (StringUtils.isNotEmpty((String)ybBaseResponse.getMsg())) {
                return ResultResponse.error((String)ybBaseResponse.getMsg());
            }
            return ResultResponse.error((String)"\u4e91\u9876\u533b\u4fdd\u652f\u4ed8\u6388\u6743\u5931\u8d25");
        }
        this.ydMedicalDataBaseService.insetPayAuthNoInfo(payAuthNoRequest, (PayAuthNoResponse)ybBaseResponse.getData());
        return ResultResponse.success((Object)ybBaseResponse);
    }

    public ResultResponse<YdBaseResponse<YbPatientInfoResponse>> ydPatientInfo(PatientInfoRequest ybPatientInfoRequest) {
        ResultResponse ybConfigResponse = this.getYbConfig(ybPatientInfoRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        YdPatientInfoRequest ydPatientInfoRequest = new YdPatientInfoRequest();
        ydPatientInfoRequest.setMdtrtCertNo(ybPatientInfoRequest.getMdtrt_cert_no());
        YdBaseResponse ybBaseResponse = new YbCommitUtil().commitYbInfo((YbConfigEntity)ybConfigResponse.getBody(), JSON.toJSONString((Object)ydPatientInfoRequest), YbPatientInfoResponse.class, "psnInfo");
        if (!SUCCESS_CODE.equals(ybBaseResponse.getCode())) {
            if (StringUtils.isNotEmpty((String)ybBaseResponse.getMsg())) {
                return ResultResponse.error((String)ybBaseResponse.getMsg());
            }
            return ResultResponse.error((String)"\u4e91\u9876\u533b\u4fdd\u652f\u4ed8\u6388\u6743\u5931\u8d25");
        }
        YbPatientInfoResponse ybPatientInfoResponse = (YbPatientInfoResponse)ybBaseResponse.getData();
        ybPatientInfoResponse.getInsuinfos().removeIf(o -> !"1".equals(o.getPsn_insu_stas()) || "330".equals(o.getInsutype()));
        if (CollectionUtils.isEmpty((Collection)ybPatientInfoResponse.getInsuinfos())) {
            return ResultResponse.error((String)"\u672a\u83b7\u53d6\u5230\u4e2a\u4eba\u6709\u6548\u53c2\u4fdd\u4fe1\u606f");
        }
        this.ydMedicalDataBaseService.insetYbUserInfo(ybPatientInfoRequest, ybPatientInfoResponse);
        return ResultResponse.success((Object)ybBaseResponse);
    }

    public ResultResponse<YdBaseResponse<YdCreadOrderResponse>> ydCreateOrder(YdCreadOrderRequest ydCreadOrderRequest) {
        ResultResponse ybConfigResponse = this.getYbConfig(ydCreadOrderRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        ydCreadOrderRequest.setOrgCodg(((YbConfigEntity)ybConfigResponse.getBody()).getInsuranceCode());
        String params = JSON.toJSONString((Object)ydCreadOrderRequest, (SerializeFilter)JsonPropertyFilter.filterIsnullStr(), (SerializerFeature[])new SerializerFeature[0]);
        YdBaseResponse ybBaseResponse = new YbCommitUtil().commitYbInfo((YbConfigEntity)ybConfigResponse.getBody(), params, YdCreadOrderResponse.class, "createOrder");
        if (!SUCCESS_CODE.equals(ybBaseResponse.getCode())) {
            if (StringUtils.isNotEmpty((String)ybBaseResponse.getMsg())) {
                return ResultResponse.error((String)ybBaseResponse.getMsg());
            }
            return ResultResponse.error((String)"\u4e91\u9876\u533b\u4fdd\u4e0b\u5355\u5931\u8d25");
        }
        return ResultResponse.success((Object)ybBaseResponse);
    }

    public ResultResponse<YdBaseResponse<YdOrderPayResponse>> ydOrderPay(YdOrderPayRequest ydOrderPayRequest) {
        ResultResponse ybConfigResponse = this.getYbConfig(ydOrderPayRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        YdBaseResponse ybBaseResponse = new YbCommitUtil().commitYbInfo((YbConfigEntity)ybConfigResponse.getBody(), JSON.toJSONString((Object)ydOrderPayRequest), YdOrderPayResponse.class, "orderPay");
        if (!SUCCESS_CODE.equals(ybBaseResponse.getCode())) {
            if (StringUtils.isNotEmpty((String)ybBaseResponse.getMsg())) {
                return ResultResponse.error((String)ybBaseResponse.getMsg());
            }
            return ResultResponse.error((String)"\u62c9\u8d77\u652f\u4ed8\u5931\u8d25");
        }
        return ResultResponse.success((Object)ybBaseResponse);
    }

    public ResultResponse<YdBaseResponse<String>> ydUndoOrder(UndoOrderRequest undoOrderRequest) {
        ResultResponse ybConfigResponse = this.getYbConfig(undoOrderRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        YdBaseResponse ybBaseResponse = new YbCommitUtil().commitYbInfo((YbConfigEntity)ybConfigResponse.getBody(), JSON.toJSONString((Object)undoOrderRequest), String.class, "undoOrder");
        if (!SUCCESS_CODE.equals(ybBaseResponse.getCode())) {
            if (StringUtils.isNotEmpty((String)ybBaseResponse.getMsg())) {
                return ResultResponse.error((String)ybBaseResponse.getMsg());
            }
            return ResultResponse.error((String)"\u4e91\u9876\u533b\u4fdd\u64a4\u9500\u5931\u8d25");
        }
        return ResultResponse.success((Object)ybBaseResponse);
    }

    public ResultResponse<YdBaseResponse<String>> ydQueryOrder(YdQueryOrderRequest ydQueryOrderRequest) {
        ResultResponse ybConfigResponse = this.getYbConfig(ydQueryOrderRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        YdBaseResponse ybBaseResponse = new YbCommitUtil().commitYbInfo((YbConfigEntity)ybConfigResponse.getBody(), JSON.toJSONString((Object)ydQueryOrderRequest), String.class, "queryOrder");
        if (!SUCCESS_CODE.equals(ybBaseResponse.getCode())) {
            if (StringUtils.isNotEmpty((String)ybBaseResponse.getMsg())) {
                return ResultResponse.error((String)ybBaseResponse.getMsg());
            }
            return ResultResponse.error((String)"\u4e91\u9876\u533b\u4fdd\u67e5\u8be2\u8ba2\u5355\u5931\u8d25");
        }
        return ResultResponse.success((Object)ybBaseResponse);
    }

    public ResultResponse<YdBaseResponse<YdReundOrderResponse>> ydRefundOrder(YdRefundOrderRequest ydRefundOrder) {
        ResultResponse ybConfigResponse = this.getYbConfig(ydRefundOrder.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        YdBaseResponse ybBaseResponse = new YbCommitUtil().commitYbInfo((YbConfigEntity)ybConfigResponse.getBody(), JSON.toJSONString((Object)ydRefundOrder), YdReundOrderResponse.class, "refundOrder");
        if (!SUCCESS_CODE.equals(ybBaseResponse.getCode())) {
            if (StringUtils.isNotEmpty((String)ybBaseResponse.getMsg())) {
                return ResultResponse.error((String)ybBaseResponse.getMsg());
            }
            return ResultResponse.error((String)"\u4e91\u9876\u533b\u4fdd\u4e0b\u5355\u63a5\u53e3\u5931\u8d25");
        }
        return ResultResponse.success((Object)ybBaseResponse);
    }
}

