/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.config;

import com.ebaiyihui.gateway.config.WebSocketConfig;
import com.ebaiyihui.gateway.config.WebSocketProperties;
import com.ebaiyihui.gateway.service.WebSocketAuthService;
import com.ebaiyihui.gateway.service.WebSocketBackendService;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableWebSocket
@ConditionalOnProperty(name={"websocket.enabled"}, havingValue="true", matchIfMissing=true)
public class WebSocketConfig
implements WebSocketConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConfig.class);
    @Autowired
    private WebSocketAuthService webSocketAuthService;
    @Autowired
    private WebSocketProperties webSocketProperties;
    @Autowired
    private WebSocketBackendService webSocketBackendService;

    @PostConstruct
    public void init() {
        log.info("WebSocket\u914d\u7f6e\u521d\u59cb\u5316");
        log.info("WebSocket\u542f\u7528\u72b6\u6001: {}", (Object)this.webSocketProperties.isEnabled());
        log.info("WebSocket\u5904\u7406\u5668\u8def\u5f84: {}", (Object)this.webSocketProperties.getHandlerPaths());
        log.info("WebSocket\u5141\u8bb8\u8de8\u57df\u6e90: {}", (Object)this.webSocketProperties.getAllowedOrigins());
        log.info("WebSocket\u8ba4\u8bc1: \u5b8c\u5168\u590d\u7528API\u8ba4\u8bc1\u903b\u8f91(authority.enabled)");
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        if (!this.webSocketProperties.isEnabled()) {
            log.info("WebSocket\u529f\u80fd\u5df2\u7981\u7528\uff0c\u8df3\u8fc7\u5904\u7406\u5668\u6ce8\u518c");
            return;
        }
        Object[] handlerPaths = this.webSocketProperties.getHandlerPathsArray();
        Object[] allowedOrigins = this.webSocketProperties.getAllowedOriginsArray();
        log.info("\u6ce8\u518cWebSocket\u5904\u7406\u5668 - \u8def\u5f84: {}, \u8de8\u57df\u6e90: {}", (Object)Arrays.toString(handlerPaths), (Object)Arrays.toString(allowedOrigins));
        registry.addHandler((WebSocketHandler)new MyWebSocketHandler(this), (String[])handlerPaths).addInterceptors(new HandshakeInterceptor[]{new AuthHandshakeInterceptor(this)}).setHandshakeHandler((HandshakeHandler)new CustomHandshakeHandler(this)).setAllowedOrigins((String[])allowedOrigins);
        log.info("WebSocket\u7f13\u51b2\u533a\u5927\u5c0f: {}KB, \u8d85\u65f6\u65f6\u95f4: {}\u79d2", (Object)(this.webSocketProperties.getBufferSize() / 1024), (Object)(this.webSocketProperties.getTimeout() / 1000L));
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ WebSocketAuthService access$100(WebSocketConfig x0) {
        return x0.webSocketAuthService;
    }

    static /* synthetic */ WebSocketBackendService access$200(WebSocketConfig x0) {
        return x0.webSocketBackendService;
    }
}

