/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.model;

import com.ebaiyihui.gateway.config.RequestWrapper;
import com.ebaiyihui.gateway.model.AuthRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthRequest {
    private static final Logger log = LoggerFactory.getLogger(AuthRequest.class);
    private String ipAddress;
    private String url;
    private String token;
    private String accessToken;
    private String cloudAuth;
    private String channelSource;
    private String appChannel;
    private String cloud;
    private String appCode;
    private String sign;
    private String params;
    private Map<String, String> extraParams;

    public String getExtraParam(String paramName) {
        return this.extraParams != null ? (String)this.extraParams.get(paramName) : null;
    }

    public Map<String, String> getAllExtraParams() {
        return this.extraParams != null ? new HashMap(this.extraParams) : new HashMap();
    }

    public boolean hasExtraParam(String paramName) {
        return this.extraParams != null && this.extraParams.containsKey(paramName);
    }

    public static AuthRequest fromHttpRequest(HttpServletRequest request) {
        return AuthRequest.builder().ipAddress(AuthRequest.getIpAddress((HttpServletRequest)request)).url(request.getRequestURI()).token(request.getHeader("token")).accessToken(request.getHeader("accessToken")).cloudAuth(request.getHeader("cloudAuth")).channelSource(request.getHeader("channelSource")).appChannel(request.getHeader("appChannel")).cloud(request.getHeader("cloud")).appCode(request.getHeader("appCode")).sign(request.getHeader("signMsg")).params(AuthRequest.extractParams((HttpServletRequest)request)).build();
    }

    public static AuthRequest fromWebSocketHandshake(ServerHttpRequest request) {
        MultiValueMap queryParams = UriComponentsBuilder.fromUri((URI)request.getURI()).build().getQueryParams();
        log.info("WebSocket\u8bf7\u6c42URI: {}", (Object)request.getURI());
        log.info("\u89e3\u6790\u7684\u67e5\u8be2\u53c2\u6570: {}", (Object)queryParams);
        log.info("WebSocket\u8bf7\u6c42\u5934\u4fe1\u606f:");
        request.getHeaders().forEach((key, values) -> log.info("  Header: {} = {}", key, values));
        HashSet<String> coreParams = new HashSet<String>();
        coreParams.add("token");
        coreParams.add("accessToken");
        coreParams.add("channelSource");
        coreParams.add("appCode");
        coreParams.add("cloudAuth");
        coreParams.add("appChannel");
        coreParams.add("cloud");
        coreParams.add("sign");
        coreParams.add("params");
        String token = AuthRequest.getParameterValue((ServerHttpRequest)request, (MultiValueMap)queryParams, (String)"token");
        String accessToken = AuthRequest.getParameterValue((ServerHttpRequest)request, (MultiValueMap)queryParams, (String)"accessToken");
        String channelSource = AuthRequest.getParameterValue((ServerHttpRequest)request, (MultiValueMap)queryParams, (String)"channelSource");
        String appCode = AuthRequest.getParameterValue((ServerHttpRequest)request, (MultiValueMap)queryParams, (String)"appCode");
        String cloudAuth = AuthRequest.getParameterValue((ServerHttpRequest)request, (MultiValueMap)queryParams, (String)"cloudAuth");
        String appChannel = AuthRequest.getParameterValue((ServerHttpRequest)request, (MultiValueMap)queryParams, (String)"appChannel");
        String cloud = AuthRequest.getParameterValue((ServerHttpRequest)request, (MultiValueMap)queryParams, (String)"cloud");
        String sign = AuthRequest.getParameterValue((ServerHttpRequest)request, (MultiValueMap)queryParams, (String)"sign");
        String params = AuthRequest.getParameterValue((ServerHttpRequest)request, (MultiValueMap)queryParams, (String)"params");
        HashMap extraParams = new HashMap();
        request.getHeaders().forEach((headerName, headerValues) -> {
            String value;
            if (!coreParams.contains(headerName) && !AuthRequest.isSystemHeader((String)headerName) && headerValues != null && !headerValues.isEmpty() && StringUtils.isNotBlank((CharSequence)(value = (String)headerValues.get(0)))) {
                extraParams.put(headerName, value);
                log.debug("\u4eceHeader\u83b7\u53d6\u989d\u5916\u53c2\u6570: {} = [{}]", headerName, (Object)value);
            }
        });
        queryParams.forEach((paramName, paramValues) -> {
            String value;
            if (!coreParams.contains(paramName) && !extraParams.containsKey(paramName) && paramValues != null && !paramValues.isEmpty() && StringUtils.isNotBlank((CharSequence)(value = (String)paramValues.get(0)))) {
                extraParams.put(paramName, value);
                log.debug("\u4ece\u67e5\u8be2\u53c2\u6570\u83b7\u53d6\u989d\u5916\u53c2\u6570: {} = [{}]", paramName, (Object)value);
            }
        });
        log.info("\u52a8\u6001\u83b7\u53d6\u7684\u6838\u5fc3\u53c2\u6570\u503c:");
        log.info("  channelSource: [{}]", (Object)channelSource);
        log.info("  accessToken: [{}]", (Object)accessToken);
        log.info("  token: [{}]", (Object)token);
        log.info("  appCode: [{}]", (Object)appCode);
        log.info("  cloudAuth: [{}]", (Object)cloudAuth);
        if (!extraParams.isEmpty()) {
            log.info("\u52a8\u6001\u83b7\u53d6\u7684\u989d\u5916\u53c2\u6570: {}", extraParams);
        }
        return AuthRequest.builder().ipAddress(AuthRequest.getIpAddressFromWebSocket((ServerHttpRequest)request)).url(request.getURI().getPath()).token(token).accessToken(accessToken).cloudAuth(cloudAuth).channelSource(channelSource).appChannel(appChannel).cloud(cloud).appCode(appCode).sign(sign).params(params).extraParams(extraParams).build();
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getIpAddressFromWebSocket(ServerHttpRequest request) {
        String ip = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddress() != null ? request.getRemoteAddress().getAddress().getHostAddress() : "unknown";
        }
        return ip;
    }

    private static String getHeaderValue(ServerHttpRequest request, String headerName) {
        return request.getHeaders().getFirst(headerName);
    }

    private static String getFirst(MultiValueMap<String, String> queryParams, String key) {
        return (String)queryParams.getFirst((Object)key);
    }

    private static String getParameterValue(ServerHttpRequest request, MultiValueMap<String, String> queryParams, String paramName) {
        String headerValue = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)paramName);
        if (StringUtils.isNotBlank((CharSequence)headerValue)) {
            log.debug("\u4eceHeader\u83b7\u53d6\u53c2\u6570 {}: [{}]", (Object)paramName, (Object)headerValue);
            return headerValue;
        }
        String queryValue = AuthRequest.getFirst(queryParams, (String)paramName);
        if (StringUtils.isNotBlank((CharSequence)queryValue)) {
            log.debug("\u4ece\u67e5\u8be2\u53c2\u6570\u83b7\u53d6\u53c2\u6570 {}: [{}]", (Object)paramName, (Object)queryValue);
            return queryValue;
        }
        log.debug("\u53c2\u6570 {} \u672a\u627e\u5230", (Object)paramName);
        return null;
    }

    private static boolean isSystemHeader(String headerName) {
        if (headerName == null) {
            return true;
        }
        String lowerName = headerName.toLowerCase();
        return lowerName.startsWith("sec-websocket") || lowerName.equals("connection") || lowerName.equals("upgrade") || lowerName.equals("host") || lowerName.equals("user-agent") || lowerName.equals("accept") || lowerName.equals("accept-encoding") || lowerName.equals("accept-language") || lowerName.equals("cache-control") || lowerName.equals("pragma") || lowerName.equals("origin") || lowerName.equals("x-forwarded-for") || lowerName.equals("x-real-ip") || lowerName.equals("date") || lowerName.equals("transfer-encoding");
    }

    private static String extractParams(HttpServletRequest request) {
        RequestWrapper requestWrapper = new RequestWrapper(request);
        String body = requestWrapper.getBody();
        String getParam = AuthRequest.getParamOfMethodGet((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)getParam)) {
            try {
                return URLDecoder.decode(getParam, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u89e3\u7801\u53c2\u6570\u5f02\u5e38\uff1a " + e.getMessage());
                return getParam;
            }
        }
        if (body.contains("=") && !body.contains(":")) {
            body = AuthRequest.convertParam((String)body);
            try {
                return URLDecoder.decode(body, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u89e3\u7801\u53c2\u6570\u5f02\u5e38\uff1a " + e.getMessage());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)request.getContentType()) && request.getContentType().contains("multipart")) {
            return "";
        }
        return body;
    }

    private static String getParamOfMethodGet(HttpServletRequest request) {
        if (null == request.getQueryString()) {
            return "";
        }
        String param = URLDecoder.decode(request.getQueryString());
        param = AuthRequest.convertParam((String)param);
        return param;
    }

    private static String convertParam(String param) {
        Object[] params = param.split("&");
        Arrays.sort(params);
        StringBuilder json = new StringBuilder("{");
        for (int i = 0; i < params.length; ++i) {
            String value;
            String[] keyValue = ((String)params[i]).split("=");
            String key = keyValue[0];
            String string = value = keyValue.length > 1 ? keyValue[1] : "";
            if (i > 0) {
                json.append(",");
            }
            json.append("\"").append(key).append("\":\"").append(value).append("\"");
        }
        json.append("}");
        return json.toString();
    }

    AuthRequest(String ipAddress, String url, String token, String accessToken, String cloudAuth, String channelSource, String appChannel, String cloud, String appCode, String sign, String params, Map<String, String> extraParams) {
        this.ipAddress = ipAddress;
        this.url = url;
        this.token = token;
        this.accessToken = accessToken;
        this.cloudAuth = cloudAuth;
        this.channelSource = channelSource;
        this.appChannel = appChannel;
        this.cloud = cloud;
        this.appCode = appCode;
        this.sign = sign;
        this.params = params;
        this.extraParams = extraParams;
    }

    public static AuthRequestBuilder builder() {
        return new AuthRequestBuilder();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getUrl() {
        return this.url;
    }

    public String getToken() {
        return this.token;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getCloudAuth() {
        return this.cloudAuth;
    }

    public String getChannelSource() {
        return this.channelSource;
    }

    public String getAppChannel() {
        return this.appChannel;
    }

    public String getCloud() {
        return this.cloud;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getSign() {
        return this.sign;
    }

    public String getParams() {
        return this.params;
    }

    public Map<String, String> getExtraParams() {
        return this.extraParams;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setCloudAuth(String cloudAuth) {
        this.cloudAuth = cloudAuth;
    }

    public void setChannelSource(String channelSource) {
        this.channelSource = channelSource;
    }

    public void setAppChannel(String appChannel) {
        this.appChannel = appChannel;
    }

    public void setCloud(String cloud) {
        this.cloud = cloud;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setExtraParams(Map<String, String> extraParams) {
        this.extraParams = extraParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthRequest)) {
            return false;
        }
        AuthRequest other = (AuthRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$cloudAuth = this.getCloudAuth();
        String other$cloudAuth = other.getCloudAuth();
        if (this$cloudAuth == null ? other$cloudAuth != null : !this$cloudAuth.equals(other$cloudAuth)) {
            return false;
        }
        String this$channelSource = this.getChannelSource();
        String other$channelSource = other.getChannelSource();
        if (this$channelSource == null ? other$channelSource != null : !this$channelSource.equals(other$channelSource)) {
            return false;
        }
        String this$appChannel = this.getAppChannel();
        String other$appChannel = other.getAppChannel();
        if (this$appChannel == null ? other$appChannel != null : !this$appChannel.equals(other$appChannel)) {
            return false;
        }
        String this$cloud = this.getCloud();
        String other$cloud = other.getCloud();
        if (this$cloud == null ? other$cloud != null : !this$cloud.equals(other$cloud)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$params = this.getParams();
        String other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        Map this$extraParams = this.getExtraParams();
        Map other$extraParams = other.getExtraParams();
        return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $cloudAuth = this.getCloudAuth();
        result = result * 59 + ($cloudAuth == null ? 43 : $cloudAuth.hashCode());
        String $channelSource = this.getChannelSource();
        result = result * 59 + ($channelSource == null ? 43 : $channelSource.hashCode());
        String $appChannel = this.getAppChannel();
        result = result * 59 + ($appChannel == null ? 43 : $appChannel.hashCode());
        String $cloud = this.getCloud();
        result = result * 59 + ($cloud == null ? 43 : $cloud.hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        Map $extraParams = this.getExtraParams();
        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
        return result;
    }

    public String toString() {
        return "AuthRequest(ipAddress=" + this.getIpAddress() + ", url=" + this.getUrl() + ", token=" + this.getToken() + ", accessToken=" + this.getAccessToken() + ", cloudAuth=" + this.getCloudAuth() + ", channelSource=" + this.getChannelSource() + ", appChannel=" + this.getAppChannel() + ", cloud=" + this.getCloud() + ", appCode=" + this.getAppCode() + ", sign=" + this.getSign() + ", params=" + this.getParams() + ", extraParams=" + this.getExtraParams() + ")";
    }
}

