/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.service;

import com.ebaiyihui.gateway.service.WebSocketBackendService;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;

@Service
public class WebSocketBackendService {
    private static final Logger log = LoggerFactory.getLogger(WebSocketBackendService.class);
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private ZuulProperties zuulProperties;
    private final WebSocketClient webSocketClient = new StandardWebSocketClient();
    private final Map<String, WebSocketSession> backendSessions = new ConcurrentHashMap();

    public void establishBackendConnection(WebSocketSession clientSession, String requestPath) {
        try {
            ServiceRouteInfo routeInfo = this.determineServiceRouteFromZuulRoutes(requestPath);
            if (routeInfo == null) {
                log.error("\u65e0\u6cd5\u786e\u5b9a\u76ee\u6807\u670d\u52a1\uff0c\u8def\u5f84: {}", (Object)requestPath);
                clientSession.close(CloseStatus.SERVICE_RESTARTED.withReason("\u65e0\u6cd5\u786e\u5b9a\u76ee\u6807\u670d\u52a1"));
                return;
            }
            String backendWebSocketUrl = this.getBackendWebSocketUrl(routeInfo.getServiceName(), routeInfo.getForwardPath());
            if (backendWebSocketUrl == null) {
                log.error("\u65e0\u6cd5\u83b7\u53d6\u540e\u7aefWebSocket URL\uff0c\u670d\u52a1: {}", (Object)routeInfo.getServiceName());
                clientSession.close(CloseStatus.SERVICE_RESTARTED.withReason("\u540e\u7aef\u670d\u52a1\u4e0d\u53ef\u7528"));
                return;
            }
            log.info("\u5efa\u7acb\u540e\u7aefWebSocket\u8fde\u63a5 - \u5ba2\u6237\u7aef: {}, \u76ee\u6807: {}", (Object)clientSession.getId(), (Object)backendWebSocketUrl);
            WebSocketHttpHeaders forwardHeaders = this.buildForwardHeaders(clientSession);
            WebSocketSession backendSession = (WebSocketSession)this.webSocketClient.doHandshake((WebSocketHandler)new BackendWebSocketHandler(this, clientSession), forwardHeaders, URI.create(backendWebSocketUrl)).get();
            this.backendSessions.put(clientSession.getId(), backendSession);
            log.info("\u540e\u7aefWebSocket\u8fde\u63a5\u5efa\u7acb\u6210\u529f - \u5ba2\u6237\u7aef: {}, \u540e\u7aef: {}", (Object)clientSession.getId(), (Object)backendSession.getId());
        }
        catch (Exception e) {
            log.error("\u5efa\u7acb\u540e\u7aefWebSocket\u8fde\u63a5\u5931\u8d25 - \u5ba2\u6237\u7aef: {}", (Object)clientSession.getId(), (Object)e);
            try {
                clientSession.close(CloseStatus.SERVICE_RESTARTED.withReason("\u8fde\u63a5\u540e\u7aef\u670d\u52a1\u5931\u8d25"));
            }
            catch (Exception ex) {
                log.error("\u5173\u95ed\u5ba2\u6237\u7aef\u8fde\u63a5\u5931\u8d25", (Throwable)ex);
            }
        }
    }

    public void forwardMessage(String clientSessionId, WebSocketMessage<?> message) {
        WebSocketSession backendSession = (WebSocketSession)this.backendSessions.get(clientSessionId);
        if (backendSession != null && backendSession.isOpen()) {
            try {
                backendSession.sendMessage(message);
                log.debug("\u6d88\u606f\u8f6c\u53d1\u5230\u540e\u7aef - \u5ba2\u6237\u7aef: {}, \u540e\u7aef: {}", (Object)clientSessionId, (Object)backendSession.getId());
            }
            catch (Exception e) {
                log.error("\u8f6c\u53d1\u6d88\u606f\u5230\u540e\u7aef\u5931\u8d25 - \u5ba2\u6237\u7aef: {}", (Object)clientSessionId, (Object)e);
                this.cleanupConnection(clientSessionId);
            }
        } else {
            log.warn("\u540e\u7aef\u8fde\u63a5\u4e0d\u53ef\u7528 - \u5ba2\u6237\u7aef: {}", (Object)clientSessionId);
        }
    }

    private WebSocketHttpHeaders buildForwardHeaders(WebSocketSession clientSession) {
        WebSocketHttpHeaders forwardHeaders = new WebSocketHttpHeaders();
        ServerHttpRequest handshakeRequest = (ServerHttpRequest)clientSession.getAttributes().get("handshakeRequest");
        if (handshakeRequest != null) {
            HttpHeaders originalHeaders = handshakeRequest.getHeaders();
            log.info("\u5f00\u59cb\u6784\u5efa\u8f6c\u53d1Headers\uff0c\u539f\u59cbHeaders\u6570\u91cf: {}", (Object)originalHeaders.size());
            originalHeaders.forEach((headerName, headerValues) -> {
                if (!this.isSystemHeader(headerName) && headerValues != null && !headerValues.isEmpty()) {
                    String headerValue = (String)headerValues.get(0);
                    forwardHeaders.add(headerName, headerValue);
                    log.debug("\u8f6c\u53d1Header: {} = {}", headerName, (Object)headerValue);
                }
            });
            log.info("\u6784\u5efa\u5b8c\u6210\uff0c\u8f6c\u53d1Headers\u6570\u91cf: {}", (Object)forwardHeaders.size());
            if (!forwardHeaders.isEmpty()) {
                log.info("\u8f6c\u53d1\u7684Headers: {}", (Object)forwardHeaders.toSingleValueMap());
            }
        } else {
            log.warn("\u65e0\u6cd5\u83b7\u53d6\u63e1\u624b\u8bf7\u6c42\u4fe1\u606f\uff0c\u5c06\u4f7f\u7528\u7a7aHeaders");
        }
        return forwardHeaders;
    }

    private boolean isSystemHeader(String headerName) {
        if (headerName == null) {
            return true;
        }
        String lowerName = headerName.toLowerCase();
        return lowerName.startsWith("sec-websocket") || lowerName.equals("connection") || lowerName.equals("upgrade") || lowerName.equals("host") || lowerName.equals("user-agent") || lowerName.equals("accept") || lowerName.equals("accept-encoding") || lowerName.equals("accept-language") || lowerName.equals("cache-control") || lowerName.equals("pragma") || lowerName.equals("origin") || lowerName.equals("x-forwarded-for") || lowerName.equals("x-real-ip") || lowerName.equals("date") || lowerName.equals("transfer-encoding");
    }

    public void cleanupConnection(String clientSessionId) {
        WebSocketSession backendSession = (WebSocketSession)this.backendSessions.remove(clientSessionId);
        if (backendSession != null && backendSession.isOpen()) {
            try {
                backendSession.close();
                log.info("\u6e05\u7406\u540e\u7aef\u8fde\u63a5 - \u5ba2\u6237\u7aef: {}, \u540e\u7aef: {}", (Object)clientSessionId, (Object)backendSession.getId());
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u540e\u7aef\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private ServiceRouteInfo determineServiceRouteFromZuulRoutes(String requestPath) {
        Map routes = this.zuulProperties.getRoutes();
        for (Map.Entry entry : routes.entrySet()) {
            ZuulProperties.ZuulRoute route = (ZuulProperties.ZuulRoute)entry.getValue();
            String routePath = route.getPath();
            if (!this.isPathMatching(requestPath, routePath)) continue;
            String forwardPath = this.calculateForwardPath(requestPath, routePath);
            log.debug("\u8def\u5f84\u5339\u914d - \u8bf7\u6c42: {}, \u8def\u7531: {}, \u670d\u52a1: {}, \u8f6c\u53d1\u8def\u5f84: {}", new Object[]{requestPath, routePath, route.getServiceId(), forwardPath});
            return new ServiceRouteInfo(route.getServiceId(), forwardPath);
        }
        log.warn("\u672a\u627e\u5230\u5339\u914d\u7684Zuul\u8def\u7531 - \u8bf7\u6c42\u8def\u5f84: {}", (Object)requestPath);
        return null;
    }

    private String calculateForwardPath(String requestPath, String routePath) {
        String prefix;
        if (routePath.endsWith("/**")) {
            String prefix2 = routePath.substring(0, routePath.length() - 3);
            if (requestPath.startsWith(prefix2)) {
                return requestPath.substring(prefix2.length());
            }
        } else if (routePath.endsWith("/*") && requestPath.startsWith(prefix = routePath.substring(0, routePath.length() - 2))) {
            return requestPath.substring(prefix.length());
        }
        return requestPath;
    }

    private boolean isPathMatching(String requestPath, String routePath) {
        if (routePath.endsWith("/**")) {
            String prefix = routePath.substring(0, routePath.length() - 3);
            return requestPath.startsWith(prefix);
        }
        if (routePath.endsWith("/*")) {
            String prefix = routePath.substring(0, routePath.length() - 2);
            return requestPath.startsWith(prefix);
        }
        return requestPath.equals(routePath);
    }

    private String getBackendWebSocketUrl(String serviceName, String forwardPath) {
        try {
            log.info("\u67e5\u627e\u670d\u52a1\u5b9e\u4f8b - \u670d\u52a1\u540d: {}, \u8f6c\u53d1\u8def\u5f84: {}", (Object)serviceName, (Object)forwardPath);
            List instances = this.discoveryClient.getInstances(serviceName);
            if (instances.isEmpty()) {
                log.error("\u672a\u627e\u5230\u670d\u52a1\u5b9e\u4f8b: {}", (Object)serviceName);
                List services = this.discoveryClient.getServices();
                log.info("\u5f53\u524d\u53ef\u7528\u7684\u670d\u52a1\u5217\u8868: {}", (Object)services);
                return null;
            }
            ServiceInstance instance = (ServiceInstance)instances.get(0);
            String protocol = instance.isSecure() ? "wss" : "ws";
            String webSocketUrl = String.format("%s://%s:%d%s", protocol, instance.getHost(), instance.getPort(), forwardPath);
            log.debug("\u540e\u7aefWebSocket URL: {}", (Object)webSocketUrl);
            return webSocketUrl;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u540e\u7aefWebSocket URL\u5931\u8d25: {}", (Object)serviceName, (Object)e);
            return null;
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ Map access$100(WebSocketBackendService x0) {
        return x0.backendSessions;
    }
}

