/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.utils;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.physical.vo.DelayMqEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqUtils.class);
    public static final int ONE_THOUSAND = 1000;
    private static final String X_DELAY = "x-delay";
    private static final String SEND = "send message to rabbitmq: ";

    public static void delayedUpdateOrderStatus(RabbitTemplate rabbitTemplate, DelayMqEntity delayMqEntity, Integer orderExpireTime) {
        rabbitTemplate.convertAndSend("physical.delayed_exchange", "physical.delayed_order_routing_key", (Object)delayMqEntity, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)(orderExpireTime * 1000));
            log.info("\u5ef6\u8fdf\u6d88\u8d39\u7684\u65f6\u95f4{}", (Object)(orderExpireTime * 1000));
            log.info("\u53d1\u9001\u81f3RabbitMQ\u7684\u6d88\u606f{}", (Object)(SEND + JSON.toJSONString((Object)delayMqEntity)));
            return message;
        });
    }
}

