/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ebaiyihui.hkdhisfront.appoint.ReponseInpatientInfoVo;
import com.ebaiyihui.hkdhisfront.appoint.RequestCardNoInVo;
import com.ebaiyihui.hkdhisfront.appoint.ResultInfoVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.common.enums.EntityKeyEnum;
import com.ebaiyihui.hkdhisfront.common.enums.MethodCodeEnum;
import com.ebaiyihui.hkdhisfront.inhosp.DepositRecordsItem;
import com.ebaiyihui.hkdhisfront.inhosp.DepositReq;
import com.ebaiyihui.hkdhisfront.inhosp.DepositRes;
import com.ebaiyihui.hkdhisfront.inhosp.GetIPDepositRecordsReq;
import com.ebaiyihui.hkdhisfront.inhosp.GetInpAdmissionReq;
import com.ebaiyihui.hkdhisfront.inhosp.GetInpAdmissionResItems;
import com.ebaiyihui.hkdhisfront.inhosp.GetOrdItemsReq;
import com.ebaiyihui.hkdhisfront.inhosp.ReponseFeeListVo;
import com.ebaiyihui.hkdhisfront.outpatient.FeeDetail;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseAddBalanceRecordDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseFeeDetailRecordDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseFeeListDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseInpatientInfoDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseInpatientInfoInDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ResultInfoDTO;
import com.ebaiyihui.hkdhisfront.pojo.vo.PrePayRecord;
import com.ebaiyihui.hkdhisfront.pojo.vo.ReponseAddBalanceRecordVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.ReponseCardNoVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestCardNoDateVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestCardNoVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestCreateAccountVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestPrePayVo;
import com.ebaiyihui.hkdhisfront.service.HisRemoteService;
import com.ebaiyihui.hkdhisfront.service.InHospitalService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InHospitalServiceImpl
implements InHospitalService {
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetInpAdmissionResItems> queryPatientInHospInfo(FrontRequest<GetInpAdmissionReq> param) {
        GetInpAdmissionReq getInpAdmissionReq = (GetInpAdmissionReq)param.getBody();
        HashMap<String, ReponseCardNoVo> map = new HashMap<String, ReponseCardNoVo>(1);
        ReponseCardNoVo reponseCardNo = ReponseCardNoVo.builder().cardNo(getInpAdmissionReq.getCardNo()).build();
        map.put(EntityKeyEnum.QUERY_PATIENTS_INFO.getValue(), reponseCardNo);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_PATIENTS_INFO.getValue(), map, ReponseInpatientInfoDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-0211\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponseInpatientInfoDTO responseBody = (ReponseInpatientInfoDTO)frontResponse.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-0211\u63a5\u53e3\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(responseBody.getResult(), "1")) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)frontResponse.getErrCode(), (String)responseBody.getErr());
        }
        GetInpAdmissionResItems getInpAdmissionResItems = GetInpAdmissionResItems.builder().cardNo(responseBody.getCardNo()).inHospNo(responseBody.getPatientNo()).inHospTimes(responseBody.getInNum()).patientName(responseBody.getName()).sex(responseBody.getSex()).idNo(responseBody.getIdCardNo()).birthday(responseBody.getBirth()).address(responseBody.getHome()).age(responseBody.calculateAgeFromIdCard(responseBody.getIdCardNo())).inHospState(responseBody.changeInState()).inDate(responseBody.getInDate()).room(responseBody.getDept()).deptName(responseBody.getDept()).totalDepost(responseBody.getPrepaySum()).totalConsum(responseBody.getCost()).depostBalance(responseBody.getFreeCost()).build();
        return FrontResponse.success((String)param.getTransactionId(), (Object)getInpAdmissionResItems);
    }

    public FrontResponse<List<DepositRecordsItem>> inpatientGetPrepayRecord(FrontRequest<GetIPDepositRecordsReq> param) {
        GetIPDepositRecordsReq getIPDepositRecordsReq = (GetIPDepositRecordsReq)param.getBody();
        HashMap<String, RequestCardNoVo> map = new HashMap<String, RequestCardNoVo>(1);
        RequestCardNoVo requestCardNo = RequestCardNoVo.builder().cardNo(getIPDepositRecordsReq.getInHospNo()).build();
        map.put(EntityKeyEnum.QUERY_ADVANCE.getValue(), requestCardNo);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_ADVANCE.getValue(), map, ReponseAddBalanceRecordDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-025\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponseAddBalanceRecordDTO reponseAddBalanceRecordDTO = (ReponseAddBalanceRecordDTO)frontResponse.getBody();
        if (Objects.isNull(reponseAddBalanceRecordDTO)) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-025\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(reponseAddBalanceRecordDTO.getResult(), "1")) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)frontResponse.getErrCode(), (String)reponseAddBalanceRecordDTO.getErr());
        }
        List prePayRecordList = reponseAddBalanceRecordDTO.getPrePayRecordList();
        if (Objects.isNull(prePayRecordList)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        ArrayList<DepositRecordsItem> depositRecordsItems = new ArrayList<DepositRecordsItem>();
        for (PrePayRecord prePayRecord : prePayRecordList) {
            DepositRecordsItem depositRecordsItem = DepositRecordsItem.builder().receiptId(prePayRecord.getReceiptNo()).rechargeMoney(prePayRecord.getMoney()).rechargeTime(prePayRecord.getDateTime()).rechargeChannel(prePayRecord.getBankName()).rechargeType(prePayRecord.getPayMode()).build();
            depositRecordsItems.add(depositRecordsItem);
        }
        return FrontResponse.success((String)param.getTransactionId(), depositRecordsItems);
    }

    public FrontResponse<ResultInfoVo> patientsCreateAccount(FrontRequest<RequestCreateAccountVo> param) {
        RequestCreateAccountVo requestCreateAccountVo = (RequestCreateAccountVo)param.getBody();
        HashMap<String, RequestCreateAccountVo> map = new HashMap<String, RequestCreateAccountVo>(1);
        RequestCreateAccountVo requestCreateAccount = RequestCreateAccountVo.builder().patientName(requestCreateAccountVo.getPatientName()).iDCardNo(requestCreateAccountVo.getIDCardNo()).pwd(requestCreateAccountVo.getPwd()).userID(requestCreateAccountVo.getUserID()).cardNo(requestCreateAccountVo.getCardNo()).build();
        map.put(EntityKeyEnum.PATIENTS_CREATE_ACCOUNT.getValue(), requestCreateAccount);
        FrontResponse patientsCreateAccount = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PATIENTS_CREATE_ACCOUNT.getValue(), map, ResultInfoDTO.class);
        ResultInfoDTO body = (ResultInfoDTO)patientsCreateAccount.getBody();
        ResultInfoVo resultInfoVo = new ResultInfoVo();
        BeanUtils.copyProperties((Object)body, (Object)resultInfoVo);
        return FrontResponse.success((String)patientsCreateAccount.getTransactionId(), (Object)resultInfoVo);
    }

    public FrontResponse<DepositRes> deposit(FrontRequest<DepositReq> param) {
        DepositReq depositReq = (DepositReq)param.getBody();
        HashMap<String, RequestPrePayVo> map = new HashMap<String, RequestPrePayVo>(1);
        RequestPrePayVo requestPrePay = RequestPrePayVo.builder().cardNo(depositReq.getInHospNo()).amt(depositReq.getAmount()).payMode("QD").bankName(depositReq.changePayChannel()).bankNo(depositReq.getTradeNo()).userID("zwby").flowNo(depositReq.getFlowNo()).build();
        map.put(EntityKeyEnum.ADVANCE.getValue(), requestPrePay);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.ADVANCE.getValue(), map, ResultInfoDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-023\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ResultInfoDTO resultInfoDTO = (ResultInfoDTO)frontResponse.getBody();
        if (Objects.isNull(resultInfoDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-023\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(resultInfoDTO.getResult(), "1")) {
            return FrontResponse.error((String)param.getTransactionId(), (String)frontResponse.getErrCode(), (String)resultInfoDTO.getErr());
        }
        DepositRes depositRes = DepositRes.builder().receiptId(resultInfoDTO.getErr()).build();
        return FrontResponse.success((String)param.getTransactionId(), (Object)depositRes);
    }

    public FrontResponse<List<FeeDetail>> patientsCostInfor(FrontRequest<GetOrdItemsReq> param) {
        GetOrdItemsReq requestCardNoDateVo = (GetOrdItemsReq)param.getBody();
        HashMap<String, RequestCardNoDateVo> map = new HashMap<String, RequestCardNoDateVo>(1);
        RequestCardNoDateVo requestCardNoDate = RequestCardNoDateVo.builder().cardNo(requestCardNoDateVo.getInHospNo()).beginDate(requestCardNoDateVo.getStartDate()).endDate(requestCardNoDateVo.getEndDate()).build();
        map.put(EntityKeyEnum.PATIENT_COST_INFO.getValue(), requestCardNoDate);
        FrontResponse acquirePaycostRecord = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PATIENT_COST_INFO.getValue(), map, ReponseFeeDetailRecordDTO.class);
        if (Objects.isNull(acquirePaycostRecord)) {
            return FrontResponse.error((String)acquirePaycostRecord.getTransactionId(), (String)"0", null);
        }
        ReponseFeeDetailRecordDTO reponseFeeDetailRecordDTO = (ReponseFeeDetailRecordDTO)acquirePaycostRecord.getBody();
        return FrontResponse.success((String)acquirePaycostRecord.getTransactionId(), (Object)reponseFeeDetailRecordDTO.getFeeDetailList());
    }

    public FrontResponse<ReponseAddBalanceRecordVo> queryAdvance(FrontRequest<RequestCardNoVo> param) {
        RequestCardNoVo requestCardNoVo = (RequestCardNoVo)param.getBody();
        HashMap<String, RequestCardNoVo> map = new HashMap<String, RequestCardNoVo>(1);
        RequestCardNoVo requestCardNo = RequestCardNoVo.builder().cardNo(requestCardNoVo.getCardNo()).build();
        map.put(EntityKeyEnum.QUERY_ADVANCE.getValue(), requestCardNo);
        FrontResponse acquireCardTopUpRecord = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_ADVANCE.getValue(), map, ReponseAddBalanceRecordDTO.class);
        if (Objects.isNull(acquireCardTopUpRecord)) {
            return FrontResponse.error((String)acquireCardTopUpRecord.getTransactionId(), (String)"0", null);
        }
        ReponseAddBalanceRecordDTO reponseAddBalanceRecordDTO = (ReponseAddBalanceRecordDTO)acquireCardTopUpRecord.getBody();
        ReponseAddBalanceRecordVo reponseAddBalanceRecordVo = new ReponseAddBalanceRecordVo();
        BeanUtils.copyProperties((Object)reponseAddBalanceRecordDTO, (Object)reponseAddBalanceRecordVo);
        return FrontResponse.success((String)acquireCardTopUpRecord.getTransactionId(), (Object)reponseAddBalanceRecordVo);
    }

    public FrontResponse<ReponseFeeListVo> quedyDailyBill(FrontRequest<GetOrdItemsReq> param) {
        GetOrdItemsReq ordItemsReq = (GetOrdItemsReq)param.getBody();
        HashMap<String, RequestCardNoDateVo> map = new HashMap<String, RequestCardNoDateVo>(1);
        RequestCardNoDateVo requestCardNoDate = RequestCardNoDateVo.builder().cardNo(ordItemsReq.getInHospNo()).beginDate(ordItemsReq.getStartDate() + " 00:00:00").endDate(ordItemsReq.getEndDate() + " 23:59:59").build();
        map.put(EntityKeyEnum.DATE_LISTING.getValue(), requestCardNoDate);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DATE_LISTING.getValue(), map, ReponseFeeListDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-026\u65e5\u7ed3\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponseFeeListDTO dateListing = (ReponseFeeListDTO)frontResponse.getBody();
        if (Objects.isNull(dateListing)) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-026\u65e5\u7ed3\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(dateListing.getResult(), "1")) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)frontResponse.getErrCode(), (String)dateListing.getErr());
        }
        ReponseFeeListVo reponseFeeListVo = new ReponseFeeListVo();
        BeanUtil.copyProperties((Object)dateListing, (Object)reponseFeeListVo, (String[])new String[0]);
        List feeItemList = dateListing.getFeeItemList();
        reponseFeeListVo.setFeeItemList(feeItemList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)reponseFeeListVo);
    }

    public FrontResponse<ReponseInpatientInfoVo> patientsInHospitalInfo(FrontRequest<RequestCardNoInVo> param) {
        RequestCardNoInVo requestCardNoInVo = (RequestCardNoInVo)param.getBody();
        HashMap<String, RequestCardNoDateVo> map = new HashMap<String, RequestCardNoDateVo>(1);
        RequestCardNoDateVo requestCardNoDate = RequestCardNoDateVo.builder().cardNo(requestCardNoInVo.getCardNo()).build();
        map.put(EntityKeyEnum.PATIENT_INHOSPITAL_INFO.getValue(), requestCardNoDate);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PATIENT_INHOSPITAL_INFO.getValue(), map, ReponseInpatientInfoInDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-021\u4f4f\u9662\u60a3\u8005\u4fe1\u606f\u67e5\u8be2");
        }
        ReponseInpatientInfoInDTO dateListing = (ReponseInpatientInfoInDTO)frontResponse.getBody();
        if (Objects.isNull(dateListing)) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-021\u4f4f\u9662\u60a3\u8005\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(dateListing.getResult(), "1")) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)frontResponse.getErrCode(), (String)dateListing.getErr());
        }
        ReponseInpatientInfoVo reponseInpatientInfoVo = new ReponseInpatientInfoVo();
        BeanUtil.copyProperties((Object)dateListing, (Object)reponseInpatientInfoVo, (String[])new String[0]);
        return FrontResponse.success((String)param.getTransactionId(), (Object)reponseInpatientInfoVo);
    }
}

