/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sdk.common.map;

import com.ebaiyihui.sdk.pojo.vo.ClientAccountInfoVO;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAccountInfoMap {
    private static final Logger log = LoggerFactory.getLogger(ClientAccountInfoMap.class);
    private static Map<String, ClientAccountInfoVO> clientAccountInfoMap = new ConcurrentHashMap();

    public static ClientAccountInfoVO get(String clientId) {
        log.info("Fetch client account info: clientId ->{}", (Object)clientId);
        ClientAccountInfoVO clientAccountInfoEntity = (ClientAccountInfoVO)clientAccountInfoMap.get(clientId);
        return clientAccountInfoEntity;
    }

    public static void put(String clientId, ClientAccountInfoVO clientAccountInfoVo) {
        clientAccountInfoMap.put(clientId, clientAccountInfoVo);
    }

    public static void del(String clientId) {
        log.info("Delete client account info: clientId ->{}", (Object)clientId);
        if (clientAccountInfoMap.containsKey(clientId)) {
            clientAccountInfoMap.remove(clientId);
        }
    }

    public boolean containsKey(Object key) {
        return clientAccountInfoMap.containsKey(key);
    }
}

