/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sdk.exception.BusinessException;
import com.ebaiyihui.sdk.mapper.ClientRetransmissionUrlMapper;
import com.ebaiyihui.sdk.pojo.entity.ClientRetransmissionUrlEntity;
import com.ebaiyihui.sdk.pojo.vo.RetransmissionReqVO;
import com.ebaiyihui.sdk.pojo.vo.RetransmissionResVO;
import com.ebaiyihui.sdk.service.RetransmissionService;
import com.ebaiyihui.sdk.utils.HttpUtils;
import com.ebaiyihui.sdk.utils.SignUtil;
import com.ebaiyihui.sdk.utils.TokenUtils;
import io.jsonwebtoken.Claims;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class RetransmissionServiceImpl
implements RetransmissionService {
    private static final Logger log = LoggerFactory.getLogger(RetransmissionServiceImpl.class);
    @Autowired
    ClientRetransmissionUrlMapper retransmissionUrlMapper;

    public BaseResponse<RetransmissionResVO> retransmission(RetransmissionReqVO retransmissionReqVO) {
        log.info("\u8bf7\u6c42\u8f6c\u53d1\u94fe\u63a5\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)retransmissionReqVO));
        String result = null;
        String clientId = this.checkTokenAndSign(retransmissionReqVO.getAccessToken(), retransmissionReqVO.getSign(), JSON.toJSONString((Object)retransmissionReqVO.getBody()));
        log.info("\u5f00\u59cb\u5bfb\u627e\u76f8\u5e94\u7684clientId");
        ClientRetransmissionUrlEntity clientRetransmissionUrlEntity = this.retransmissionUrlMapper.selectByClient(clientId, retransmissionReqVO.getBusinessType());
        if (Objects.isNull(clientRetransmissionUrlEntity) || Objects.isNull(clientRetransmissionUrlEntity.getRequestMethod())) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        log.info("\u5f00\u59cb\u8bf7\u6c42\u5177\u4f53\u4e1a\u52a1\u63a5\u53e3");
        try {
            result = RequestMethod.GET.name().equals(clientRetransmissionUrlEntity.getRequestMethod()) ? HttpUtils.get((String)clientRetransmissionUrlEntity.getRetransmissionUrl(), (Map)((Map)JSON.parseObject((String)JSON.toJSONString((Object)retransmissionReqVO.getBody()), Map.class))) : HttpUtils.doPost((String)clientRetransmissionUrlEntity.getRetransmissionUrl(), (String)JSON.toJSONString((Object)retransmissionReqVO.getBody()), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            if (StringUtils.isNotEmpty((String)result)) {
                log.info("\u8bf7\u6c42\u5177\u4f53\u7684\u4e1a\u52a1\u8bf7\u6c42\u7ed3\u675f,\u8fd4\u56de\u5185\u5bb9:{}", (Object)result);
                return (BaseResponse)JSONObject.parseObject((String)result, BaseResponse.class);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u8bf7\u6c42\u5177\u4f53\u4e1a\u52a1\u8bf7\u6c42\u51fa\u9519\uff0c\u5177\u4f53\u51fa\u9519\u4fe1\u606f\u4e3a" + e.getMessage());
        }
        return null;
    }

    private String checkTokenAndSign(String accessToken, String sign, String body) {
        Claims claims = null;
        if (StringUtils.isEmpty((String)sign)) {
            throw new BusinessException("sign empty");
        }
        if (StringUtils.isEmpty((String)accessToken)) {
            throw new BusinessException("accessToken empty");
        }
        if (StringUtils.isEmpty((String)body)) {
            throw new BusinessException("body empty");
        }
        try {
            claims = TokenUtils.parseJWT((String)accessToken, (String)"byh2020@123..");
        }
        catch (Exception e) {
            throw new BusinessException("accessToken error");
        }
        String clientId = claims.get((Object)"clientId").toString();
        String clientSecret = claims.get((Object)"clientSecret").toString();
        String dataSign = claims.get((Object)"sign").toString();
        String signType = claims.get((Object)"signType").toString();
        if (StringUtils.isEmpty((String)clientId) || StringUtils.isEmpty((String)clientSecret)) {
            throw new BusinessException("accessToken error");
        }
        String checkSign = SignUtil.getSign((String)body, (String)signType, (String)dataSign);
        log.info("\u8ba1\u7b97\u51fa\u7684sign\uff1a{}", (Object)checkSign);
        if (!sign.equals(checkSign)) {
            throw new BusinessException("sign error");
        }
        log.info("\u9a8c\u8bc1\u7b7e\u540d\u901a\u8fc7\uff0c\u8fd4\u56declientId\uff1a{}", (Object)clientId);
        return clientId;
    }
}

