/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sdk.common.map;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTokenExpireTimeMap {
    private static final Logger log = LoggerFactory.getLogger(ClientTokenExpireTimeMap.class);
    private static Map<String, LocalDateTime> clientTokenExpireTimeMap = new ConcurrentHashMap();

    public static LocalDateTime get(String clientId) {
        log.info("Fetch expire time: clientId ->{}", (Object)clientId);
        LocalDateTime expireTime = (LocalDateTime)clientTokenExpireTimeMap.get(clientId);
        return expireTime;
    }

    public static void put(String clientId, LocalDateTime expireTime) {
        clientTokenExpireTimeMap.put(clientId, expireTime);
    }

    public static void del(String clientId) {
        log.info("Delete expire time: clientId ->{}", (Object)clientId);
        if (clientTokenExpireTimeMap.containsKey(clientId)) {
            clientTokenExpireTimeMap.remove(clientId);
        }
    }

    public boolean containsKey(Object key) {
        return clientTokenExpireTimeMap.containsKey(key);
    }
}

