/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sdk.common.map.ClientAccountInfoMap;
import com.ebaiyihui.sdk.common.map.ClientTokenExpireTimeMap;
import com.ebaiyihui.sdk.mapper.ClientAccountInfoMapper;
import com.ebaiyihui.sdk.pojo.entity.ClientAccountInfoEntity;
import com.ebaiyihui.sdk.pojo.vo.ClientAccountInfoVO;
import com.ebaiyihui.sdk.pojo.vo.TokenAuthorizationReqVO;
import com.ebaiyihui.sdk.pojo.vo.TokenAuthorizationResVO;
import com.ebaiyihui.sdk.pojo.vo.TokenRefreshReqVO;
import com.ebaiyihui.sdk.service.AuthorizationService;
import com.ebaiyihui.sdk.utils.SnowflakeIdWorker;
import com.ebaiyihui.sdk.utils.TokenUtils;
import io.jsonwebtoken.Claims;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationServiceImpl
implements AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationServiceImpl.class);
    @Autowired
    private ClientAccountInfoMapper clientAccountInfoMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    public static final int TWO_HOURS = 7200;

    public BaseResponse<TokenAuthorizationResVO> token(TokenAuthorizationReqVO tokenAuthorizationReqVo) {
        ClientAccountInfoEntity clientAccountInfoEntity = this.clientAccountInfoMapper.selectByClientId(tokenAuthorizationReqVo.getClientId());
        if (Objects.isNull(clientAccountInfoEntity)) {
            log.info("clientId\u65e0\u6548");
            return BaseResponse.error((String)"clientId\u65e0\u6548");
        }
        if (!Objects.equals(clientAccountInfoEntity.getClientSecret(), tokenAuthorizationReqVo.getClientSecret())) {
            log.info("clientSecret\u9519\u8bef");
            return BaseResponse.error((String)"clientSecret\u9519\u8bef");
        }
        String accessTokenRandomStr = String.valueOf(this.snowflakeIdWorker.nextId());
        String accessToken = TokenUtils.createJWT((String)clientAccountInfoEntity.getClientId(), (String)clientAccountInfoEntity.getClientSecret(), (String)accessTokenRandomStr, (String)clientAccountInfoEntity.getSign(), (String)clientAccountInfoEntity.getSignType(), (String)"byh2020@123..", (Integer)-1);
        String refreshTokenRandomStr = String.valueOf(this.snowflakeIdWorker.nextId());
        String refreshToken = TokenUtils.createJWT((String)clientAccountInfoEntity.getClientId(), (String)clientAccountInfoEntity.getClientSecret(), (String)refreshTokenRandomStr, (String)clientAccountInfoEntity.getSign(), (String)clientAccountInfoEntity.getSignType(), (String)"byh2020@123..", (Integer)-1);
        clientAccountInfoEntity.setGenerateTokenTime(new Date());
        clientAccountInfoEntity.setGenerateTokenNumber(Integer.valueOf(clientAccountInfoEntity.getGenerateTokenNumber() + 1));
        clientAccountInfoEntity.setAccessToken(accessToken);
        clientAccountInfoEntity.setRefreshToken(refreshToken);
        clientAccountInfoEntity.setAccessTokenUniqueKey(accessTokenRandomStr);
        clientAccountInfoEntity.setRefreshTokenUniqueKey(refreshTokenRandomStr);
        this.clientAccountInfoMapper.updateByPrimaryKeySelective(clientAccountInfoEntity);
        ClientAccountInfoVO clientAccountInfoVo = new ClientAccountInfoVO();
        BeanUtils.copyProperties((Object)clientAccountInfoEntity, (Object)clientAccountInfoVo);
        ClientAccountInfoMap.put((String)clientAccountInfoVo.getClientId(), (ClientAccountInfoVO)clientAccountInfoVo);
        ClientTokenExpireTimeMap.put((String)clientAccountInfoVo.getClientId(), (LocalDateTime)LocalDateTime.now().plusSeconds(7200L));
        TokenAuthorizationResVO tokenAuthorizationResVo = new TokenAuthorizationResVO();
        tokenAuthorizationResVo.setAccessToken(clientAccountInfoEntity.getAccessToken());
        tokenAuthorizationResVo.setRefreshToken(clientAccountInfoEntity.getRefreshToken());
        tokenAuthorizationResVo.setExpiresIn(Integer.valueOf(7200));
        log.info("tokenAuthorizationResVo->{}", (Object)JSON.toJSONString((Object)tokenAuthorizationReqVo));
        return BaseResponse.success((Object)tokenAuthorizationResVo);
    }

    public BaseResponse<TokenAuthorizationResVO> refresh(TokenRefreshReqVO tokenRefreshReqVo) {
        String refreshToken = tokenRefreshReqVo.getRefreshToken();
        Claims claims = null;
        try {
            claims = TokenUtils.parseJWT((String)refreshToken, (String)"byh2020@123..");
        }
        catch (Exception e) {
            log.error("ERROR");
        }
        String clientId = claims.get((Object)"clientId").toString();
        LocalDateTime tokenExpireTime = ClientTokenExpireTimeMap.get((String)clientId);
        if (Objects.nonNull(tokenExpireTime) && LocalDateTime.now().isAfter(tokenExpireTime)) {
            log.info("token\u8fc7\u671f\uff0ctokenExpireTime->{}, currentTime->{}", (Object)tokenExpireTime, (Object)LocalDateTime.now());
            ClientTokenExpireTimeMap.del((String)clientId);
            ClientAccountInfoMap.del((String)clientId);
            return BaseResponse.error((String)"invalid refresh token");
        }
        String clientSecret = claims.get((Object)"clientSecret").toString();
        String refreshTokenRandom = claims.get((Object)"randomStr").toString();
        ClientAccountInfoVO clientAccountInfoVo = ClientAccountInfoMap.get((String)clientId);
        if (Objects.isNull(clientAccountInfoVo) || !Objects.equals(refreshTokenRandom, clientAccountInfoVo.getRefreshTokenUniqueKey())) {
            log.info("token\u5931\u6548\u6216\u8005\u672a\u751f\u6210token: request refresh token unique key->{}", (Object)refreshTokenRandom);
            return BaseResponse.error((String)"invalid refresh token");
        }
        TokenAuthorizationReqVO tokenAuthorizationReqVo = new TokenAuthorizationReqVO();
        tokenAuthorizationReqVo.setClientId(clientId);
        tokenAuthorizationReqVo.setClientSecret(clientSecret);
        return this.token(tokenAuthorizationReqVo);
    }
}

