/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sdk.service.impl;

import com.ebaiyihui.sdk.common.map.ClientAccountInfoMap;
import com.ebaiyihui.sdk.common.map.ClientTokenExpireTimeMap;
import com.ebaiyihui.sdk.mapper.ClientAccountInfoMapper;
import com.ebaiyihui.sdk.pojo.vo.ClientAccountInfoVO;
import com.ebaiyihui.sdk.service.ClientAccountService;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientAccountServiceImpl
implements ClientAccountService {
    private static final Logger log = LoggerFactory.getLogger(ClientAccountServiceImpl.class);
    @Autowired
    private ClientAccountInfoMapper clientAccountInfoMapper;

    public void initClientAccountInfo() {
        log.info("\u521d\u59cb\u5316client account info");
        List clientAccountInfoEntityList = this.clientAccountInfoMapper.selectList();
        clientAccountInfoEntityList.stream().forEach(clientAccountInfoEntity -> {
            ClientAccountInfoVO clientAccountInfoVo = new ClientAccountInfoVO();
            BeanUtils.copyProperties((Object)clientAccountInfoEntity, (Object)clientAccountInfoVo);
            ClientAccountInfoMap.put((String)clientAccountInfoVo.getClientId(), (ClientAccountInfoVO)clientAccountInfoVo);
            if (clientAccountInfoEntity.getGenerateTokenTime() != null) {
                LocalDateTime tokenExpireTime = this.getTokenExpireTime(clientAccountInfoEntity.getGenerateTokenTime());
                if (LocalDateTime.now().isBefore(tokenExpireTime)) {
                    ClientTokenExpireTimeMap.put((String)clientAccountInfoVo.getClientId(), (LocalDateTime)tokenExpireTime);
                }
            }
        });
    }

    private LocalDateTime getTokenExpireTime(Date generateTokenTime) {
        Instant instant = generateTokenTime.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime generateTokenLocalDateTime = instant.atZone(zoneId).toLocalDateTime();
        LocalDateTime tokenExpireTime = generateTokenLocalDateTime.plusHours(2L);
        return tokenExpireTime;
    }
}

