/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sdk.service.impl.sy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sdk.config.sy.SYConfig;
import com.ebaiyihui.sdk.exception.BusinessException;
import com.ebaiyihui.sdk.mapper.OutsideConfigMapper;
import com.ebaiyihui.sdk.pojo.entity.OutsideConfigEntity;
import com.ebaiyihui.sdk.pojo.sy.dto.SYRequestOrderInfoRecDTO;
import com.ebaiyihui.sdk.pojo.sy.dto.SYRequestOrderRefundInfoRecDTO;
import com.ebaiyihui.sdk.pojo.sy.dto.SYRequestOrderStatusInfoRecDTO;
import com.ebaiyihui.sdk.pojo.sy.vo.SYRequestOrderInfoRecVO;
import com.ebaiyihui.sdk.pojo.sy.vo.SYRequestOrderRefundInfoRecVO;
import com.ebaiyihui.sdk.pojo.sy.vo.SYRequestOrderStatusInfoRecVO;
import com.ebaiyihui.sdk.service.sy.SYOrderService;
import com.ebaiyihui.sdk.utils.HttpUtils;
import com.ebaiyihui.sdk.utils.sy.EncrypUtil;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SYOrderServiceImpl
implements SYOrderService {
    private static final Logger log = LoggerFactory.getLogger(SYOrderServiceImpl.class);
    @Autowired
    OutsideConfigMapper outsideConfigMapper;
    @Autowired
    private SYConfig syConfig;

    public BaseResponse orderInfoRec(SYRequestOrderInfoRecVO syRequestOrderInfoRecVO) {
        OutsideConfigEntity outsideConfigEntity = this.outsideConfigMapper.getByBusinessName("SYOrderInfoRec");
        if (Objects.isNull(outsideConfigEntity)) {
            throw new BusinessException("\u9655\u836f\u5b59\u601d\u9088\u4e0b\u5355\u63a5\u53e3\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5\u63a5\u53e3\u914d\u7f6e");
        }
        String requestUrl = outsideConfigEntity.getUrl();
        Map header = EncrypUtil.buildHeader((SYConfig)this.syConfig);
        SYRequestOrderInfoRecDTO params = new SYRequestOrderInfoRecDTO();
        params.setOrderStr(syRequestOrderInfoRecVO);
        params.setSign((String)header.get("sign"));
        log.info("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u4e0b\u5355\u63a5\u53e3\uff0c\u8def\u5f84\u4e3a{}\uff0c\u53c2\u6570\u4e3a{}", (Object)requestUrl, (Object)JSON.toJSONString((Object)params));
        try {
            String result = HttpUtils.post((String)requestUrl, (Map)header, (String)JSON.toJSONString((Object)params));
            log.info("result : {}", (Object)result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                throw new BusinessException("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u4e0b\u5355\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            String resultcode = jsonObject.getString("code");
            if (Objects.equals("200", resultcode)) {
                return BaseResponse.success((Object)jsonObject);
            }
            log.error("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u4e0b\u5355\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25:\u6d88\u606f\u4e3a\uff1a{}", (Object)result);
            throw new BusinessException("\u51fa\u73b0\u9519\u8bef\uff0c\u6d88\u606f\u4e3a:" + result);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u4e0b\u5355\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u4e0b\u5355\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage());
        }
    }

    public BaseResponse orderRefundInfoRec(SYRequestOrderRefundInfoRecVO syRequestOrderRefundInfoRecVO) {
        OutsideConfigEntity outsideConfigEntity = this.outsideConfigMapper.getByBusinessName("SYOrderRefundInfoRec");
        if (Objects.isNull(outsideConfigEntity)) {
            throw new BusinessException("\u9655\u836f\u5b59\u601d\u9088\u9000\u5355\u63a5\u53e3\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5\u63a5\u53e3\u914d\u7f6e");
        }
        String requestUrl = outsideConfigEntity.getUrl();
        Map header = EncrypUtil.buildHeader((SYConfig)this.syConfig);
        SYRequestOrderRefundInfoRecDTO params = new SYRequestOrderRefundInfoRecDTO();
        params.setRefundInfo(syRequestOrderRefundInfoRecVO);
        params.setSign((String)header.get("sign"));
        log.info("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u9000\u5355\u63a5\u53e3\uff0c\u8def\u5f84\u4e3a{}\uff0c\u53c2\u6570\u4e3a{}", (Object)requestUrl, (Object)JSON.toJSONString((Object)params));
        try {
            String result = HttpUtils.post((String)requestUrl, (Map)header, (String)JSON.toJSONString((Object)params));
            log.info("result : {}", (Object)result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                throw new BusinessException("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u9000\u5355\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            String resultcode = jsonObject.getString("code");
            if (Objects.equals("200", resultcode)) {
                return BaseResponse.success((Object)jsonObject);
            }
            log.error("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u9000\u5355\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25:\u6d88\u606f\u4e3a\uff1a{}", (Object)result);
            throw new BusinessException("\u51fa\u73b0\u9519\u8bef\uff0c\u6d88\u606f\u4e3a:" + result);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u9000\u5355\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u9000\u5355\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage());
        }
    }

    public BaseResponse orderStatusInfoRec(SYRequestOrderStatusInfoRecVO syRequestOrderStatusInfoRecVO) {
        OutsideConfigEntity outsideConfigEntity = this.outsideConfigMapper.getByBusinessName("SYOrderStatusInfoRec");
        if (Objects.isNull(outsideConfigEntity)) {
            throw new BusinessException("\u9655\u836f\u5b59\u601d\u9088\u8ba2\u5355\u72b6\u6001\u901a\u77e5\u63a5\u53e3\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5\u63a5\u53e3\u914d\u7f6e");
        }
        String requestUrl = outsideConfigEntity.getUrl();
        Map header = EncrypUtil.buildHeader((SYConfig)this.syConfig);
        SYRequestOrderStatusInfoRecDTO params = new SYRequestOrderStatusInfoRecDTO();
        params.setOrderStatusInfo(syRequestOrderStatusInfoRecVO);
        params.setSign((String)header.get("sign"));
        log.info("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u8ba2\u5355\u72b6\u6001\u901a\u77e5\u63a5\u53e3\uff0c\u8def\u5f84\u4e3a{}\uff0c\u53c2\u6570\u4e3a{}", (Object)requestUrl, (Object)JSON.toJSONString((Object)params));
        try {
            String result = HttpUtils.post((String)requestUrl, (Map)header, (String)JSON.toJSONString((Object)params));
            log.info("result : {}", (Object)result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                throw new BusinessException("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u8ba2\u5355\u72b6\u6001\u901a\u77e5\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            String resultcode = jsonObject.getString("code");
            if (Objects.equals("200", resultcode)) {
                return BaseResponse.success((Object)jsonObject);
            }
            log.error("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u8ba2\u5355\u72b6\u6001\u901a\u77e5\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25:\u6d88\u606f\u4e3a\uff1a{}", (Object)result);
            throw new BusinessException("\u51fa\u73b0\u9519\u8bef\uff0c\u6d88\u606f\u4e3a:" + result);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u8ba2\u5355\u72b6\u6001\u901a\u77e5\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8bf7\u6c42\u9655\u836f\u5b59\u601d\u9088\u8ba2\u5355\u72b6\u6001\u901a\u77e5\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage());
        }
    }
}

