/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sdk.service.impl.zk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sdk.exception.BusinessException;
import com.ebaiyihui.sdk.mapper.OutsideConfigMapper;
import com.ebaiyihui.sdk.pojo.entity.OutsideConfigEntity;
import com.ebaiyihui.sdk.pojo.zk.vo.ZKRequestCancelMainVO;
import com.ebaiyihui.sdk.pojo.zk.vo.ZKRequestPushSendMainVO;
import com.ebaiyihui.sdk.service.zk.ZKOrderService;
import com.ebaiyihui.sdk.utils.HttpUtils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZKOrderServiceImpl
implements ZKOrderService {
    private static final Logger log = LoggerFactory.getLogger(ZKOrderServiceImpl.class);
    @Autowired
    OutsideConfigMapper outsideConfigMapper;

    public BaseResponse insertOrder(ZKRequestPushSendMainVO zkRequestPushSendMainVO) {
        OutsideConfigEntity outsideConfigEntity = this.outsideConfigMapper.getByBusinessName("ZKInsertOrder");
        if (Objects.isNull(outsideConfigEntity)) {
            throw new BusinessException("\u4f17\u5eb7\u8d27\u4ed3\u63a8\u9001\u5904\u65b9\u63a5\u53e3\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5\u63a5\u53e3\u914d\u7f6e");
        }
        String requestUrl = outsideConfigEntity.getUrl();
        log.info("\u5f00\u59cb\u8bf7\u6c42\u4f17\u5eb7\u8d27\u4ed3\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u8def\u5f84\u4e3a{}\uff0c\u53c2\u6570\u4e3a{}", (Object)requestUrl, (Object)JSON.toJSONString((Object)zkRequestPushSendMainVO));
        try {
            String result = HttpUtils.doPost((String)requestUrl, (String)JSON.toJSONString((Object)zkRequestPushSendMainVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("result : {}", (Object)result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                throw new BusinessException("\u8c03\u7528\u4f17\u5eb7\u8d27\u4ed3\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            String resultcode = jsonObject.getString("resultcode");
            if (Objects.equals("1000", resultcode)) {
                return BaseResponse.success((Object)jsonObject);
            }
            log.error("\u8c03\u7528\u4f17\u5eb7\u8d27\u4ed3\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25:\u6d88\u606f\u4e3a\uff1a{}", (Object)result);
            throw new BusinessException("\u51fa\u73b0\u9519\u8bef\uff0c\u6d88\u606f\u4e3a:" + result);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4f17\u5eb7\u8d27\u4ed3\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u4f17\u5eb7\u8d27\u4ed3\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage());
        }
    }

    public BaseResponse cancelOrder(ZKRequestCancelMainVO zkRequestCancelMainVO) {
        OutsideConfigEntity outsideConfigEntity = this.outsideConfigMapper.getByBusinessName("ZKCancelOrder");
        if (Objects.isNull(outsideConfigEntity)) {
            throw new BusinessException("\u4f17\u5eb7\u8d27\u4ed3\u53d6\u6d88\u5904\u65b9\u63a5\u53e3\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5\u63a5\u53e3\u914d\u7f6e");
        }
        String requestUrl = outsideConfigEntity.getUrl();
        log.info("\u5f00\u59cb\u8bf7\u6c42\u4f17\u5eb7\u8d27\u4ed3\u53d6\u6d88\u5904\u65b9\u63a5\u53e3\uff0c\u8def\u5f84\u4e3a{}\uff0c\u53c2\u6570\u4e3a{}", (Object)requestUrl, (Object)JSON.toJSONString((Object)zkRequestCancelMainVO));
        try {
            String result = HttpUtils.doPost((String)requestUrl, (String)JSON.toJSONString((Object)zkRequestCancelMainVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("result : {}", (Object)result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                throw new BusinessException("\u8c03\u7528\u4f17\u5eb7\u8d27\u4ed3\u53d6\u6d88\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            String resultcode = jsonObject.getString("resultcode");
            if (Objects.equals("1000", resultcode)) {
                return BaseResponse.success((Object)jsonObject);
            }
            log.error("\u8c03\u7528\u4f17\u5eb7\u8d27\u4ed3\u53d6\u6d88\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25:\u6d88\u606f\u4e3a\uff1a{}", (Object)result);
            throw new BusinessException("\u51fa\u73b0\u9519\u8bef\uff0c\u6d88\u606f\u4e3a:" + result);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4f17\u5eb7\u8d27\u4ed3\u53d6\u6d88\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u4f17\u5eb7\u8d27\u4ed3\u53d6\u6d88\u5904\u65b9\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u5931\u8d25" + e.getMessage());
        }
    }
}

